/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.http.client.HttpFSKerberosAuthenticator;
import org.apache.hadoop.fs.http.server.HttpFSKerberosAuthenticationHandler;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.lib.service.DelegationTokenManager;
import org.apache.hadoop.lib.service.DelegationTokenManagerException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.token.Token;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class HttpFSKerberosAuthenticationHandler
extends KerberosAuthenticationHandler {
    static final Set<String> DELEGATION_TOKEN_OPS = new HashSet();
    public static final String TYPE = "kerberos-dt";
    private static final String ENTER;

    public String getType() {
        return "kerberos-dt";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        boolean requestContinues = true;
        String op = request.getParameter("op");
        op = op != null ? op.toUpperCase() : null;
        if (!DELEGATION_TOKEN_OPS.contains(op)) return requestContinues;
        if (request.getMethod().equals("OPTIONS")) return requestContinues;
        HttpFSKerberosAuthenticator.DelegationTokenOperation dtOp = HttpFSKerberosAuthenticator.DelegationTokenOperation.valueOf((String)op);
        if (dtOp.getHttpMethod().equals(request.getMethod())) {
            if (dtOp.requiresKerberosCredentials() && token == null) {
                response.sendError(401, MessageFormat.format("Operation [{0}] requires SPNEGO authentication established", dtOp));
                return false;
            }
            DelegationTokenManager tokenManager = (DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class);
            try {
                HashMap<String, Long> map = null;
                switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSKerberosAuthenticator$DelegationTokenOperation[dtOp.ordinal()]) {
                    case 1: {
                        String renewerParam = request.getParameter("renewer");
                        if (renewerParam == null) {
                            renewerParam = token.getUserName();
                        }
                        Token dToken = tokenManager.createToken(UserGroupInformation.getCurrentUser(), renewerParam);
                        map = HttpFSKerberosAuthenticationHandler.delegationTokenToJSON((Token)dToken);
                        break;
                    }
                    case 2: 
                    case 3: {
                        String tokenParam = request.getParameter("token");
                        if (tokenParam == null) {
                            response.sendError(400, MessageFormat.format("Operation [{0}] requires the parameter [{1}]", dtOp, "token"));
                            return false;
                        }
                        if (dtOp == HttpFSKerberosAuthenticator.DelegationTokenOperation.CANCELDELEGATIONTOKEN) {
                            Token dt = new Token();
                            dt.decodeFromUrlString(tokenParam);
                            tokenManager.cancelToken(dt, UserGroupInformation.getCurrentUser().getUserName());
                            break;
                        }
                        Token dt = new Token();
                        dt.decodeFromUrlString(tokenParam);
                        long expirationTime = tokenManager.renewToken(dt, token.getUserName());
                        map = new HashMap<String, Long>();
                        map.put("long", expirationTime);
                    }
                }
                if (!requestContinues) return requestContinues;
                response.setStatus(200);
                if (map == null) return false;
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                JSONObject.writeJSONString((Map)map, (Writer)writer);
                ((Writer)writer).write(ENTER);
                ((Writer)writer).flush();
                return false;
            }
            catch (DelegationTokenManagerException ex) {
                throw new AuthenticationException(ex.toString(), (Throwable)ex);
            }
        }
        response.sendError(400, MessageFormat.format("Wrong HTTP method [{0}] for operation [{1}], it should be [{2}]", request.getMethod(), dtOp, dtOp.getHttpMethod()));
        return false;
    }

    private static Map delegationTokenToJSON(Token token) throws IOException {
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put("urlString", token.encodeToUrlString());
        LinkedHashMap<String, LinkedHashMap<String, String>> response = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        response.put("Token", json);
        return response;
    }

    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String delegationParam = request.getParameter("delegation");
        if (delegationParam != null) {
            try {
                Token dt = new Token();
                dt.decodeFromUrlString(delegationParam);
                DelegationTokenManager tokenManager = (DelegationTokenManager)HttpFSServerWebApp.get().get(DelegationTokenManager.class);
                UserGroupInformation ugi = tokenManager.verifyToken(dt);
                String shortName = ugi.getShortUserName();
                token = new AuthenticationToken(shortName, ugi.getUserName(), this.getType());
                token.setExpires(0L);
            }
            catch (Throwable ex) {
                throw new AuthenticationException("Could not verify DelegationToken, " + ex.toString(), ex);
            }
        } else {
            token = super.authenticate(request, response);
        }
        return token;
    }

    static {
        DELEGATION_TOKEN_OPS.add(HttpFSKerberosAuthenticator.DelegationTokenOperation.GETDELEGATIONTOKEN.toString());
        DELEGATION_TOKEN_OPS.add(HttpFSKerberosAuthenticator.DelegationTokenOperation.RENEWDELEGATIONTOKEN.toString());
        DELEGATION_TOKEN_OPS.add(HttpFSKerberosAuthenticator.DelegationTokenOperation.CANCELDELEGATIONTOKEN.toString());
        ENTER = System.getProperty("line.separator");
    }
}

