/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.DelegationTokenRenewer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.client.HttpFSKerberosAuthenticator;
import org.apache.hadoop.fs.http.client.HttpFSUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
public class HttpFSFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    public static final String SERVICE_NAME = "/webhdfs";
    public static final String SERVICE_VERSION = "/v1";
    public static final String SCHEME = "webhdfs";
    public static final String OP_PARAM = "op";
    public static final String DO_AS_PARAM = "doas";
    public static final String OVERWRITE_PARAM = "overwrite";
    public static final String REPLICATION_PARAM = "replication";
    public static final String BLOCKSIZE_PARAM = "blocksize";
    public static final String PERMISSION_PARAM = "permission";
    public static final String DESTINATION_PARAM = "destination";
    public static final String RECURSIVE_PARAM = "recursive";
    public static final String SOURCES_PARAM = "sources";
    public static final String OWNER_PARAM = "owner";
    public static final String GROUP_PARAM = "group";
    public static final String MODIFICATION_TIME_PARAM = "modificationtime";
    public static final String ACCESS_TIME_PARAM = "accesstime";
    public static final Short DEFAULT_PERMISSION = 493;
    public static final String RENAME_JSON = "boolean";
    public static final String DELETE_JSON = "boolean";
    public static final String MKDIRS_JSON = "boolean";
    public static final String HOME_DIR_JSON = "Path";
    public static final String SET_REPLICATION_JSON = "boolean";
    public static final String UPLOAD_CONTENT_TYPE = "application/octet-stream";
    public static final String FILE_STATUSES_JSON = "FileStatuses";
    public static final String FILE_STATUS_JSON = "FileStatus";
    public static final String PATH_SUFFIX_JSON = "pathSuffix";
    public static final String TYPE_JSON = "type";
    public static final String LENGTH_JSON = "length";
    public static final String OWNER_JSON = "owner";
    public static final String GROUP_JSON = "group";
    public static final String PERMISSION_JSON = "permission";
    public static final String ACCESS_TIME_JSON = "accessTime";
    public static final String MODIFICATION_TIME_JSON = "modificationTime";
    public static final String BLOCK_SIZE_JSON = "blockSize";
    public static final String REPLICATION_JSON = "replication";
    public static final String FILE_CHECKSUM_JSON = "FileChecksum";
    public static final String CHECKSUM_ALGORITHM_JSON = "algorithm";
    public static final String CHECKSUM_BYTES_JSON = "bytes";
    public static final String CHECKSUM_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_JSON = "ContentSummary";
    public static final String CONTENT_SUMMARY_DIRECTORY_COUNT_JSON = "directoryCount";
    public static final String CONTENT_SUMMARY_FILE_COUNT_JSON = "fileCount";
    public static final String CONTENT_SUMMARY_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_QUOTA_JSON = "quota";
    public static final String CONTENT_SUMMARY_SPACE_CONSUMED_JSON = "spaceConsumed";
    public static final String CONTENT_SUMMARY_SPACE_QUOTA_JSON = "spaceQuota";
    public static final String ERROR_JSON = "RemoteException";
    public static final String ERROR_EXCEPTION_JSON = "exception";
    public static final String ERROR_CLASSNAME_JSON = "javaClassName";
    public static final String ERROR_MESSAGE_JSON = "message";
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final String HTTP_GET = "GET";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_DELETE = "DELETE";
    private AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
    private URI uri;
    private InetSocketAddress httpFSAddr;
    private Path workingDir;
    private UserGroupInformation realUser;
    private String doAs;
    private Token<?> delegationToken;

    private <T> T doAsRealUserIfNecessary(Callable<T> callable) throws IOException {
        try {
            if (this.realUser.getShortUserName().equals(this.doAs)) {
                return callable.call();
            }
            return (T)this.realUser.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception ex) {
            throw new IOException(ex.toString(), ex);
        }
    }

    private HttpURLConnection getConnection(String method, Map<String, String> params, Path path, boolean makeQualified) throws IOException {
        if (!this.realUser.getShortUserName().equals(this.doAs)) {
            params.put("doas", this.doAs);
        }
        HttpFSKerberosAuthenticator.injectDelegationToken(params, (Token)this.delegationToken);
        if (makeQualified) {
            path = this.makeQualified(path);
        }
        URL url = HttpFSUtils.createURL((Path)path, params);
        return (HttpURLConnection)this.doAsRealUserIfNecessary((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private HttpURLConnection getConnection(URL url, String method) throws IOException {
        Class klass = this.getConf().getClass("httpfs.authenticator.class", HttpFSKerberosAuthenticator.class, Authenticator.class);
        Authenticator authenticator = (Authenticator)ReflectionUtils.newInstance((Class)klass, (Configuration)this.getConf());
        try {
            HttpURLConnection conn = new AuthenticatedURL(authenticator).openConnection(url, this.authToken);
            conn.setRequestMethod(method);
            if (method.equals("POST") || method.equals("PUT")) {
                conn.setDoOutput(true);
            }
            return conn;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.realUser = ugi.getRealUser();
        if (this.realUser == null) {
            this.realUser = UserGroupInformation.getLoginUser();
        }
        this.doAs = ugi.getShortUserName();
        super.initialize(name, conf);
        try {
            this.uri = new URI(name.getScheme() + "://" + name.getAuthority());
            this.httpFSAddr = NetUtils.createSocketAddr((String)this.getCanonicalUri().toString());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public String getScheme() {
        return "webhdfs";
    }

    public URI getUri() {
        return this.uri;
    }

    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.OPEN.toString());
        HttpURLConnection conn = this.getConnection(Operation.OPEN.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        return new FSDataInputStream((InputStream)new HttpFSDataInputStream(conn.getInputStream(), bufferSize));
    }

    public static String permissionToString(FsPermission p) {
        return Integer.toString(p == null ? DEFAULT_PERMISSION.shortValue() : p.toShort(), 8);
    }

    private FSDataOutputStream uploadData(String method, Path f, Map<String, String> params, int bufferSize, int expectedStatus) throws IOException {
        HttpURLConnection conn = this.getConnection(method, params, f, true);
        conn.setInstanceFollowRedirects(false);
        boolean exceptionAlreadyHandled = false;
        try {
            if (conn.getResponseCode() == 307) {
                exceptionAlreadyHandled = true;
                String location = conn.getHeaderField("Location");
                if (location != null) {
                    conn = this.getConnection(new URL(location), method);
                    conn.setRequestProperty("Content-Type", "application/octet-stream");
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream(), bufferSize);
                        return new HttpFSDataOutputStream(conn, (OutputStream)os, expectedStatus, this.statistics);
                    }
                    catch (IOException ex) {
                        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)expectedStatus);
                        throw ex;
                    }
                }
                HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)307);
                throw new IOException("Missing HTTP 'Location' header for [" + conn.getURL() + "]");
            }
            throw new IOException(MessageFormat.format("Expected HTTP status was [307], received [{0}]", conn.getResponseCode()));
        }
        catch (IOException ex) {
            if (exceptionAlreadyHandled) {
                throw ex;
            }
            HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)307);
            throw ex;
        }
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.CREATE.toString());
        params.put("overwrite", Boolean.toString(overwrite));
        params.put("replication", Short.toString(replication));
        params.put("blocksize", Long.toString(blockSize));
        params.put("permission", HttpFSFileSystem.permissionToString((FsPermission)permission));
        return this.uploadData(Operation.CREATE.getMethod(), f, params, bufferSize, 201);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.APPEND.toString());
        return this.uploadData(Operation.APPEND.getMethod(), f, params, bufferSize, 200);
    }

    public void concat(Path f, Path[] psrcs) throws IOException {
        ArrayList<String> strPaths = new ArrayList<String>(psrcs.length);
        for (Path psrc : psrcs) {
            strPaths.add(psrc.toUri().getPath());
        }
        String srcs = StringUtils.join((CharSequence)",", strPaths);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.CONCAT.toString());
        params.put("sources", srcs);
        HttpURLConnection conn = this.getConnection(Operation.CONCAT.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.RENAME.toString());
        params.put("destination", dst.toString());
        HttpURLConnection conn = this.getConnection(Operation.RENAME.getMethod(), params, src, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, false);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.DELETE.toString());
        params.put("recursive", Boolean.toString(recursive));
        HttpURLConnection conn = this.getConnection(Operation.DELETE.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.LISTSTATUS.toString());
        HttpURLConnection conn = this.getConnection(Operation.LISTSTATUS.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
        json = (JSONObject)json.get((Object)"FileStatuses");
        JSONArray jsonArray = (JSONArray)json.get((Object)"FileStatus");
        FileStatus[] array = new FileStatus[jsonArray.size()];
        f = this.makeQualified(f);
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = this.createFileStatus(f, (JSONObject)jsonArray.get(i));
        }
        return array;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        if (this.workingDir == null) {
            this.workingDir = this.getHomeDirectory();
        }
        return this.workingDir;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.MKDIRS.toString());
        params.put("permission", HttpFSFileSystem.permissionToString((FsPermission)permission));
        HttpURLConnection conn = this.getConnection(Operation.MKDIRS.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.GETFILESTATUS.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETFILESTATUS.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
        json = (JSONObject)json.get((Object)"FileStatus");
        f = this.makeQualified(f);
        return this.createFileStatus(f, json);
    }

    public Path getHomeDirectory() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.GETHOMEDIRECTORY.toString());
        try {
            HttpURLConnection conn = this.getConnection(Operation.GETHOMEDIRECTORY.getMethod(), params, new Path(this.getUri().toString(), "/"), false);
            HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
            JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
            return new Path((String)json.get((Object)"Path"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.SETOWNER.toString());
        params.put("owner", username);
        params.put("group", groupname);
        HttpURLConnection conn = this.getConnection(Operation.SETOWNER.getMethod(), params, p, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.SETPERMISSION.toString());
        params.put("permission", HttpFSFileSystem.permissionToString((FsPermission)permission));
        HttpURLConnection conn = this.getConnection(Operation.SETPERMISSION.getMethod(), params, p, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.SETTIMES.toString());
        params.put("modificationtime", Long.toString(mtime));
        params.put("accesstime", Long.toString(atime));
        HttpURLConnection conn = this.getConnection(Operation.SETTIMES.getMethod(), params, p, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.SETREPLICATION.toString());
        params.put("replication", Short.toString(replication));
        HttpURLConnection conn = this.getConnection(Operation.SETREPLICATION.getMethod(), params, src, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    private FileStatus createFileStatus(Path parent, JSONObject json) {
        String pathSuffix = (String)json.get((Object)"pathSuffix");
        Path path = pathSuffix.equals("") ? parent : new Path(parent, pathSuffix);
        FILE_TYPE type = FILE_TYPE.valueOf((String)((String)json.get((Object)"type")));
        long len = (Long)json.get((Object)"length");
        String owner = (String)json.get((Object)"owner");
        String group = (String)json.get((Object)"group");
        FsPermission permission = new FsPermission(Short.parseShort((String)json.get((Object)"permission"), 8));
        long aTime = (Long)json.get((Object)"accessTime");
        long mTime = (Long)json.get((Object)"modificationTime");
        long blockSize = (Long)json.get((Object)"blockSize");
        short replication = ((Long)json.get((Object)"replication")).shortValue();
        FileStatus fileStatus = null;
        switch (6.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$FILE_TYPE[type.ordinal()]) {
            case 1: 
            case 2: {
                fileStatus = new FileStatus(len, type == FILE_TYPE.DIRECTORY, (int)replication, blockSize, mTime, aTime, permission, owner, group, path);
                break;
            }
            case 3: {
                Path symLink = null;
                fileStatus = new FileStatus(len, false, (int)replication, blockSize, mTime, aTime, permission, owner, group, symLink, path);
            }
        }
        return fileStatus;
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.GETCONTENTSUMMARY.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETCONTENTSUMMARY.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)((JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn)).get((Object)"ContentSummary");
        return new ContentSummary(((Long)json.get((Object)"length")).longValue(), ((Long)json.get((Object)"fileCount")).longValue(), ((Long)json.get((Object)"directoryCount")).longValue(), ((Long)json.get((Object)"quota")).longValue(), ((Long)json.get((Object)"spaceConsumed")).longValue(), ((Long)json.get((Object)"spaceQuota")).longValue());
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", Operation.GETFILECHECKSUM.toString());
        HttpURLConnection conn = this.getConnection(Operation.GETFILECHECKSUM.getMethod(), params, f, true);
        HttpFSUtils.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)((JSONObject)HttpFSUtils.jsonParse((HttpURLConnection)conn)).get((Object)"FileChecksum");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return (Token)this.doAsRealUserIfNecessary((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public long renewDelegationToken(Token<?> token) throws IOException {
        return (Long)this.doAsRealUserIfNecessary((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void cancelDelegationToken(Token<?> token) throws IOException {
        HttpFSKerberosAuthenticator.cancelDelegationToken((URI)this.uri, (AuthenticatedURL.Token)this.authToken, token);
    }

    public Token<?> getRenewToken() {
        return this.delegationToken;
    }

    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        this.delegationToken = token;
    }

    static /* synthetic */ HttpURLConnection access$000(HttpFSFileSystem x0, URL x1, String x2) throws IOException {
        return x0.getConnection(x1, x2);
    }

    static /* synthetic */ URI access$100(HttpFSFileSystem x0) {
        return x0.uri;
    }

    static /* synthetic */ InetSocketAddress access$200(HttpFSFileSystem x0) {
        return x0.httpFSAddr;
    }

    static /* synthetic */ AuthenticatedURL.Token access$300(HttpFSFileSystem x0) {
        return x0.authToken;
    }
}

