/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.util.LinkedHashMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionProvider
implements ExceptionMapper<Throwable> {
    private static Logger LOG = LoggerFactory.getLogger(ExceptionProvider.class);
    private static final String ENTER = System.getProperty("line.separator");

    protected Response createResponse(Response.Status status, Throwable throwable) {
        LinkedHashMap<String, String> json = new LinkedHashMap<String, String>();
        json.put("message", this.getOneLineMessage(throwable));
        json.put("exception", throwable.getClass().getSimpleName());
        json.put("javaClassName", throwable.getClass().getName());
        LinkedHashMap<String, LinkedHashMap<String, String>> response = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        response.put("RemoteException", json);
        this.log(status, throwable);
        return Response.status((Response.Status)status).type("application/json").entity(response).build();
    }

    protected String getOneLineMessage(Throwable throwable) {
        int i;
        String message = throwable.getMessage();
        if (message != null && (i = message.indexOf(ENTER)) > -1) {
            message = message.substring(0, i);
        }
        return message;
    }

    protected void log(Response.Status status, Throwable throwable) {
        LOG.debug("{}", (Object)throwable.getMessage(), (Object)throwable);
    }

    public Response toResponse(Throwable throwable) {
        return this.createResponse(Response.Status.BAD_REQUEST, throwable);
    }
}

