/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.servlet;

import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HostnameFilter
implements Filter {
    static final ThreadLocal<String> HOSTNAME_TL = new ThreadLocal();

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            String hostname = InetAddress.getByName(request.getRemoteAddr()).getCanonicalHostName();
            HOSTNAME_TL.set(hostname);
            chain.doFilter(request, response);
        }
        finally {
            HOSTNAME_TL.remove();
        }
    }

    public static String get() {
        return (String)HOSTNAME_TL.get();
    }

    public void destroy() {
    }
}

