/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.hadoop;

import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.lib.lang.XException;
import org.apache.hadoop.lib.server.BaseService;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.lib.service.FileSystemAccessException;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.util.Check;
import org.apache.hadoop.lib.util.ConfigurationUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAccessService
extends BaseService
implements FileSystemAccess {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemAccessService.class);
    public static final String PREFIX = "hadoop";
    private static final String INSTRUMENTATION_GROUP = "hadoop";
    public static final String AUTHENTICATION_TYPE = "authentication.type";
    public static final String KERBEROS_KEYTAB = "authentication.kerberos.keytab";
    public static final String KERBEROS_PRINCIPAL = "authentication.kerberos.principal";
    public static final String NAME_NODE_WHITELIST = "name.node.whitelist";
    private static final String HADOOP_CONF_PREFIX = "conf:";
    private static final String NAME_NODE_PROPERTY = "fs.default.name";
    private Collection<String> nameNodeWhitelist;
    Configuration serviceHadoopConf;
    private AtomicInteger unmanagedFileSystems = new AtomicInteger();

    public FileSystemAccessService() {
        super("hadoop");
    }

    protected void init() throws ServiceException {
        LOG.info("Using FileSystemAccess JARs version [{}]", (Object)VersionInfo.getVersion());
        String security = this.getServiceConfig().get(AUTHENTICATION_TYPE, "simple").trim();
        if (security.equals("kerberos")) {
            String defaultName = this.getServer().getName();
            String keytab = System.getProperty("user.home") + "/" + defaultName + ".keytab";
            keytab = this.getServiceConfig().get(KERBEROS_KEYTAB, keytab).trim();
            if (keytab.length() == 0) {
                throw new ServiceException((XException.ERROR)FileSystemAccessException.ERROR.H01, new Object[]{KERBEROS_KEYTAB});
            }
            String principal = defaultName + "/localhost@LOCALHOST";
            principal = this.getServiceConfig().get(KERBEROS_PRINCIPAL, principal).trim();
            if (principal.length() == 0) {
                throw new ServiceException((XException.ERROR)FileSystemAccessException.ERROR.H01, new Object[]{KERBEROS_PRINCIPAL});
            }
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            }
            catch (IOException ex) {
                throw new ServiceException((XException.ERROR)FileSystemAccessException.ERROR.H02, new Object[]{ex.getMessage(), ex});
            }
            LOG.info("Using FileSystemAccess Kerberos authentication, principal [{}] keytab [{}]", (Object)principal, (Object)keytab);
        } else if (security.equals("simple")) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "simple");
            UserGroupInformation.setConfiguration((Configuration)conf);
            LOG.info("Using FileSystemAccess simple/pseudo authentication, principal [{}]", (Object)System.getProperty("user.name"));
        } else {
            throw new ServiceException((XException.ERROR)FileSystemAccessException.ERROR.H09, new Object[]{security});
        }
        this.serviceHadoopConf = new Configuration(false);
        for (Map.Entry entry : this.getServiceConfig()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(HADOOP_CONF_PREFIX)) continue;
            name = name.substring(HADOOP_CONF_PREFIX.length());
            String value = (String)entry.getValue();
            this.serviceHadoopConf.set(name, value);
        }
        this.setRequiredServiceHadoopConf(this.serviceHadoopConf);
        LOG.debug("FileSystemAccess default configuration:");
        for (Map.Entry entry : this.serviceHadoopConf) {
            LOG.debug("  {} = {}", entry.getKey(), entry.getValue());
        }
        this.nameNodeWhitelist = this.toLowerCase(this.getServiceConfig().getTrimmedStringCollection(NAME_NODE_WHITELIST));
    }

    public void postInit() throws ServiceException {
        super.postInit();
        Instrumentation instrumentation = (Instrumentation)this.getServer().get(Instrumentation.class);
        instrumentation.addVariable("hadoop", "unmanaged.fs", (Instrumentation.Variable)new /* Unavailable Anonymous Inner Class!! */);
        instrumentation.addSampler("hadoop", "unmanaged.fs", 60, (Instrumentation.Variable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Set<String> toLowerCase(Collection<String> collection) {
        HashSet<String> set = new HashSet<String>();
        for (String value : collection) {
            set.add(value.toLowerCase());
        }
        return set;
    }

    public Class getInterface() {
        return FileSystemAccess.class;
    }

    public Class[] getServiceDependencies() {
        return new Class[]{Instrumentation.class};
    }

    protected UserGroupInformation getUGI(String user) throws IOException {
        return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
    }

    protected void setRequiredServiceHadoopConf(Configuration conf) {
        conf.set("fs.hdfs.impl.disable.cache", "true");
    }

    protected Configuration createHadoopConf(Configuration conf) {
        Configuration hadoopConf = new Configuration();
        ConfigurationUtils.copy((Configuration)this.serviceHadoopConf, (Configuration)hadoopConf);
        ConfigurationUtils.copy((Configuration)conf, (Configuration)hadoopConf);
        return hadoopConf;
    }

    protected Configuration createNameNodeConf(Configuration conf) {
        return this.createHadoopConf(conf);
    }

    protected FileSystem createFileSystem(Configuration namenodeConf) throws IOException {
        return FileSystem.get((Configuration)namenodeConf);
    }

    protected void closeFileSystem(FileSystem fs) throws IOException {
        fs.close();
    }

    protected void validateNamenode(String namenode) throws FileSystemAccessException {
        if (this.nameNodeWhitelist.size() > 0 && !this.nameNodeWhitelist.contains("*") && !this.nameNodeWhitelist.contains(namenode.toLowerCase())) {
            throw new FileSystemAccessException(FileSystemAccessException.ERROR.H05, new Object[]{namenode, "not in whitelist"});
        }
    }

    protected void checkNameNodeHealth(FileSystem fileSystem) throws FileSystemAccessException {
    }

    public <T> T execute(String user, Configuration conf, FileSystemAccess.FileSystemExecutor<T> executor) throws FileSystemAccessException {
        Check.notEmpty((String)user, (String)"user");
        Check.notNull((Object)conf, (String)"conf");
        Check.notNull(executor, (String)"executor");
        if (conf.get(NAME_NODE_PROPERTY) == null || conf.getTrimmed(NAME_NODE_PROPERTY).length() == 0) {
            throw new FileSystemAccessException(FileSystemAccessException.ERROR.H06, new Object[]{NAME_NODE_PROPERTY});
        }
        try {
            this.validateNamenode(new URI(conf.get(NAME_NODE_PROPERTY)).getAuthority());
            UserGroupInformation ugi = this.getUGI(user);
            return (T)ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (FileSystemAccessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FileSystemAccessException(FileSystemAccessException.ERROR.H03, new Object[]{ex});
        }
    }

    public FileSystem createFileSystemInternal(String user, Configuration conf) throws IOException, FileSystemAccessException {
        Check.notEmpty((String)user, (String)"user");
        Check.notNull((Object)conf, (String)"conf");
        try {
            this.validateNamenode(new URI(conf.get(NAME_NODE_PROPERTY)).getAuthority());
            UserGroupInformation ugi = this.getUGI(user);
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (FileSystemAccessException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new FileSystemAccessException(FileSystemAccessException.ERROR.H08, new Object[]{ex.getMessage(), ex});
        }
    }

    public FileSystem createFileSystem(String user, Configuration conf) throws IOException, FileSystemAccessException {
        this.unmanagedFileSystems.incrementAndGet();
        return this.createFileSystemInternal(user, conf);
    }

    public void releaseFileSystem(FileSystem fs) throws IOException {
        this.unmanagedFileSystems.decrementAndGet();
        this.closeFileSystem(fs);
    }

    public Configuration getDefaultConfiguration() {
        Configuration conf = new Configuration(false);
        ConfigurationUtils.copy((Configuration)this.serviceHadoopConf, (Configuration)conf);
        return conf;
    }

    static /* synthetic */ AtomicInteger access$000(FileSystemAccessService x0) {
        return x0.unmanagedFileSystems;
    }

    static /* synthetic */ Server access$100(FileSystemAccessService x0) {
        return x0.getServer();
    }
}

