/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.client.HttpKerberosAuthenticator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpFSFileSystem
extends FileSystem {
    public static final String SERVICE_NAME = "/webhdfs";
    public static final String SERVICE_VERSION = "/v1";
    public static final String SERVICE_PREFIX = "/webhdfs/v1";
    public static final String OP_PARAM = "op";
    public static final String DO_AS_PARAM = "doas";
    public static final String OVERWRITE_PARAM = "overwrite";
    public static final String REPLICATION_PARAM = "replication";
    public static final String BLOCKSIZE_PARAM = "blocksize";
    public static final String PERMISSION_PARAM = "permission";
    public static final String DESTINATION_PARAM = "destination";
    public static final String RECURSIVE_PARAM = "recursive";
    public static final String OWNER_PARAM = "owner";
    public static final String GROUP_PARAM = "group";
    public static final String MODIFICATION_TIME_PARAM = "modificationtime";
    public static final String ACCESS_TIME_PARAM = "accesstime";
    public static final String RENEWER_PARAM = "renewer";
    public static final String DEFAULT_PERMISSION = "default";
    public static final String RENAME_JSON = "boolean";
    public static final String DELETE_JSON = "boolean";
    public static final String MKDIRS_JSON = "boolean";
    public static final String HOME_DIR_JSON = "Path";
    public static final String SET_REPLICATION_JSON = "boolean";
    public static final String UPLOAD_CONTENT_TYPE = "application/octet-stream";
    public static final String FILE_STATUSES_JSON = "FileStatuses";
    public static final String FILE_STATUS_JSON = "FileStatus";
    public static final String PATH_SUFFIX_JSON = "pathSuffix";
    public static final String TYPE_JSON = "type";
    public static final String LENGTH_JSON = "length";
    public static final String OWNER_JSON = "owner";
    public static final String GROUP_JSON = "group";
    public static final String PERMISSION_JSON = "permission";
    public static final String ACCESS_TIME_JSON = "accessTime";
    public static final String MODIFICATION_TIME_JSON = "modificationTime";
    public static final String BLOCK_SIZE_JSON = "blockSize";
    public static final String REPLICATION_JSON = "replication";
    public static final String FILE_CHECKSUM_JSON = "FileChecksum";
    public static final String CHECKSUM_ALGORITHM_JSON = "algorithm";
    public static final String CHECKSUM_BYTES_JSON = "bytes";
    public static final String CHECKSUM_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_JSON = "ContentSummary";
    public static final String CONTENT_SUMMARY_DIRECTORY_COUNT_JSON = "directoryCount";
    public static final String CONTENT_SUMMARY_FILE_COUNT_JSON = "fileCount";
    public static final String CONTENT_SUMMARY_LENGTH_JSON = "length";
    public static final String CONTENT_SUMMARY_QUOTA_JSON = "quota";
    public static final String CONTENT_SUMMARY_SPACE_CONSUMED_JSON = "spaceConsumed";
    public static final String CONTENT_SUMMARY_SPACE_QUOTA_JSON = "spaceQuota";
    public static final String DELEGATION_TOKEN_JSON = "Token";
    public static final String DELEGATION_TOKEN_URL_STRING_JSON = "urlString";
    public static final String ERROR_JSON = "RemoteException";
    public static final String ERROR_EXCEPTION_JSON = "exception";
    public static final String ERROR_CLASSNAME_JSON = "javaClassName";
    public static final String ERROR_MESSAGE_JSON = "message";
    public static final int HTTP_TEMPORARY_REDIRECT = 307;
    private static final String HTTP_GET = "GET";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_DELETE = "DELETE";
    private AuthenticatedURL.Token authToken = new AuthenticatedURL.Token();
    private URI uri;
    private Path workingDir;
    private String doAs;

    private HttpURLConnection getConnection(String method, Map<String, String> params, Path path, boolean makeQualified) throws IOException {
        params.put("doas", this.doAs);
        if (makeQualified) {
            path = this.makeQualified(path);
        }
        URI uri = path.toUri();
        StringBuilder sb = new StringBuilder();
        sb.append(uri.getScheme()).append("://").append(uri.getAuthority()).append("/webhdfs/v1").append(uri.getPath());
        String separator = "?";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append(separator).append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF8"));
            separator = "&";
        }
        URL url = new URL(sb.toString());
        return this.getConnection(url, method);
    }

    private HttpURLConnection getConnection(URL url, String method) throws IOException {
        Class klass = this.getConf().getClass("httpfs.authenticator.class", HttpKerberosAuthenticator.class, Authenticator.class);
        Authenticator authenticator = (Authenticator)ReflectionUtils.newInstance((Class)klass, (Configuration)this.getConf());
        try {
            HttpURLConnection conn = new AuthenticatedURL(authenticator).openConnection(url, this.authToken);
            conn.setRequestMethod(method);
            if (method.equals("POST") || method.equals("PUT")) {
                conn.setDoOutput(true);
            }
            return conn;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private static Object jsonParse(HttpURLConnection conn) throws IOException {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse((Reader)new InputStreamReader(conn.getInputStream()));
        }
        catch (ParseException ex) {
            throw new IOException("JSON parser error, " + ex.getMessage(), ex);
        }
    }

    private static void validateResponse(HttpURLConnection conn, int expected) throws IOException {
        int status = conn.getResponseCode();
        if (status != expected) {
            try {
                JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
                json = (JSONObject)json.get((Object)"RemoteException");
                String message = (String)json.get((Object)"message");
                String exception = (String)json.get((Object)"exception");
                String className = (String)json.get((Object)"javaClassName");
                try {
                    ClassLoader cl = HttpFSFileSystem.class.getClassLoader();
                    Class<?> klass = cl.loadClass(className);
                    Constructor<?> constr = klass.getConstructor(String.class);
                    throw (IOException)constr.newInstance(message);
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new IOException(MessageFormat.format("{0} - {1}", exception, message));
                }
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof IOException) {
                    throw (IOException)ex.getCause();
                }
                throw new IOException(MessageFormat.format("HTTP status [{0}], {1}", status, conn.getResponseMessage()));
            }
        }
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.doAs = ugi.getUserName();
        super.initialize(name, conf);
        try {
            this.uri = new URI(name.getScheme() + "://" + name.getHost() + ":" + name.getPort());
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", GetOpValues.OPEN.toString());
        HttpURLConnection conn = this.getConnection("GET", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        return new FSDataInputStream((InputStream)new HttpFSDataInputStream(conn.getInputStream(), bufferSize));
    }

    public static String permissionToString(FsPermission p) {
        return p == null ? "default" : Integer.toString(p.toShort(), 8);
    }

    private FSDataOutputStream uploadData(String method, Path f, Map<String, String> params, int bufferSize, int expectedStatus) throws IOException {
        HttpURLConnection conn = this.getConnection(method, params, f, true);
        conn.setInstanceFollowRedirects(false);
        boolean exceptionAlreadyHandled = false;
        try {
            if (conn.getResponseCode() == 307) {
                exceptionAlreadyHandled = true;
                String location = conn.getHeaderField("Location");
                if (location != null) {
                    conn = this.getConnection(new URL(location), method);
                    conn.setRequestProperty("Content-Type", "application/octet-stream");
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream(), bufferSize);
                        return new HttpFSDataOutputStream(conn, (OutputStream)os, expectedStatus, this.statistics);
                    }
                    catch (IOException ex) {
                        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)expectedStatus);
                        throw ex;
                    }
                }
                HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)307);
                throw new IOException("Missing HTTP 'Location' header for [" + conn.getURL() + "]");
            }
            throw new IOException(MessageFormat.format("Expected HTTP status was [307], received [{0}]", conn.getResponseCode()));
        }
        catch (IOException ex) {
            if (exceptionAlreadyHandled) {
                throw ex;
            }
            HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)307);
            throw ex;
        }
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.CREATE.toString());
        params.put("overwrite", Boolean.toString(overwrite));
        params.put("replication", Short.toString(replication));
        params.put("blocksize", Long.toString(blockSize));
        params.put("permission", HttpFSFileSystem.permissionToString((FsPermission)permission));
        return this.uploadData("PUT", f, params, bufferSize, 201);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PostOpValues.APPEND.toString());
        return this.uploadData("POST", f, params, bufferSize, 200);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.RENAME.toString());
        params.put("destination", dst.toString());
        HttpURLConnection conn = this.getConnection("PUT", params, src, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, false);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", DeleteOpValues.DELETE.toString());
        params.put("recursive", Boolean.toString(recursive));
        HttpURLConnection conn = this.getConnection("DELETE", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", GetOpValues.LISTSTATUS.toString());
        HttpURLConnection conn = this.getConnection("GET", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
        json = (JSONObject)json.get((Object)"FileStatuses");
        JSONArray jsonArray = (JSONArray)json.get((Object)"FileStatus");
        FileStatus[] array = new FileStatus[jsonArray.size()];
        f = this.makeQualified(f);
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = this.createFileStatus(f, (JSONObject)jsonArray.get(i));
        }
        return array;
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        if (this.workingDir == null) {
            this.workingDir = this.getHomeDirectory();
        }
        return this.workingDir;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.MKDIRS.toString());
        params.put("permission", HttpFSFileSystem.permissionToString((FsPermission)permission));
        HttpURLConnection conn = this.getConnection("PUT", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", GetOpValues.GETFILESTATUS.toString());
        HttpURLConnection conn = this.getConnection("GET", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
        json = (JSONObject)json.get((Object)"FileStatus");
        f = this.makeQualified(f);
        return this.createFileStatus(f, json);
    }

    public Path getHomeDirectory() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", GetOpValues.GETHOMEDIR.toString());
        try {
            HttpURLConnection conn = this.getConnection("GET", params, new Path(this.getUri().toString(), "/"), false);
            HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
            JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
            return new Path((String)json.get((Object)"Path"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.SETOWNER.toString());
        params.put("owner", username);
        params.put("group", groupname);
        HttpURLConnection conn = this.getConnection("PUT", params, p, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.SETPERMISSION.toString());
        params.put("permission", HttpFSFileSystem.permissionToString((FsPermission)permission));
        HttpURLConnection conn = this.getConnection("PUT", params, p, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.SETTIMES.toString());
        params.put("modificationtime", Long.toString(mtime));
        params.put("accesstime", Long.toString(atime));
        HttpURLConnection conn = this.getConnection("PUT", params, p, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", PutOpValues.SETREPLICATION.toString());
        params.put("replication", Short.toString(replication));
        HttpURLConnection conn = this.getConnection("PUT", params, src, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn);
        return (Boolean)json.get((Object)"boolean");
    }

    private FileStatus createFileStatus(Path parent, JSONObject json) {
        String pathSuffix = (String)json.get((Object)"pathSuffix");
        Path path = pathSuffix.equals("") ? parent : new Path(parent, pathSuffix);
        FILE_TYPE type = FILE_TYPE.valueOf((String)((String)json.get((Object)"type")));
        long len = (Long)json.get((Object)"length");
        String owner = (String)json.get((Object)"owner");
        String group = (String)json.get((Object)"group");
        FsPermission permission = new FsPermission(Short.parseShort((String)json.get((Object)"permission"), 8));
        long aTime = (Long)json.get((Object)"accessTime");
        long mTime = (Long)json.get((Object)"modificationTime");
        long blockSize = (Long)json.get((Object)"blockSize");
        short replication = ((Long)json.get((Object)"replication")).shortValue();
        FileStatus fileStatus = null;
        switch (2.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$FILE_TYPE[type.ordinal()]) {
            case 1: 
            case 2: {
                fileStatus = new FileStatus(len, type == FILE_TYPE.DIRECTORY, (int)replication, blockSize, mTime, aTime, permission, owner, group, path);
                break;
            }
            case 3: {
                Path symLink = null;
                fileStatus = new FileStatus(len, false, (int)replication, blockSize, mTime, aTime, permission, owner, group, symLink, path);
            }
        }
        return fileStatus;
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", GetOpValues.GETCONTENTSUMMARY.toString());
        HttpURLConnection conn = this.getConnection("GET", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)((JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn)).get((Object)"ContentSummary");
        return new ContentSummary(((Long)json.get((Object)"length")).longValue(), ((Long)json.get((Object)"fileCount")).longValue(), ((Long)json.get((Object)"directoryCount")).longValue(), ((Long)json.get((Object)"quota")).longValue(), ((Long)json.get((Object)"spaceConsumed")).longValue(), ((Long)json.get((Object)"spaceQuota")).longValue());
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", GetOpValues.GETFILECHECKSUM.toString());
        HttpURLConnection conn = this.getConnection("GET", params, f, true);
        HttpFSFileSystem.validateResponse((HttpURLConnection)conn, (int)200);
        JSONObject json = (JSONObject)((JSONObject)HttpFSFileSystem.jsonParse((HttpURLConnection)conn)).get((Object)"FileChecksum");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ void access$000(HttpURLConnection x0, int x1) throws IOException {
        HttpFSFileSystem.validateResponse((HttpURLConnection)x0, (int)x1);
    }
}

