/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.text.MessageFormat;
import junit.framework.Assert;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.SysPropsForTestsLoader;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestExceptionHelper;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Rule;
import org.junit.rules.MethodRule;

public abstract class HTestCase {
    public static final String TEST_WAITFOR_RATIO_PROP = "test.waitfor.ratio";
    private static float WAITFOR_RATIO_DEFAULT;
    private float waitForRatio = WAITFOR_RATIO_DEFAULT;
    @Rule
    public MethodRule testDir = new TestDirHelper();
    @Rule
    public MethodRule jettyTestHelper = new TestJettyHelper();
    @Rule
    public MethodRule exceptionHelper = new TestExceptionHelper();

    protected void setWaitForRatio(float ratio) {
        this.waitForRatio = ratio;
    }

    protected float getWaitForRatio() {
        return this.waitForRatio;
    }

    protected void sleep(long time) {
        try {
            Thread.sleep((long)(this.getWaitForRatio() * (float)time));
        }
        catch (InterruptedException ex) {
            System.err.println(MessageFormat.format("Sleep interrupted, {0}", ex.toString()));
        }
    }

    protected long waitFor(int timeout, Predicate predicate) {
        return this.waitFor(timeout, false, predicate);
    }

    protected long waitFor(int timeout, boolean failIfTimeout, Predicate predicate) {
        long started = System.currentTimeMillis();
        long mustEnd = System.currentTimeMillis() + (long)(this.getWaitForRatio() * (float)timeout);
        long lastEcho = 0L;
        try {
            boolean eval;
            long waiting = mustEnd - System.currentTimeMillis();
            System.out.println(MessageFormat.format("Waiting up to [{0}] msec", waiting));
            while (!(eval = predicate.evaluate()) && System.currentTimeMillis() < mustEnd) {
                if (System.currentTimeMillis() - lastEcho > 5000L) {
                    waiting = mustEnd - System.currentTimeMillis();
                    System.out.println(MessageFormat.format("Waiting up to [{0}] msec", waiting));
                    lastEcho = System.currentTimeMillis();
                }
                Thread.sleep(100L);
            }
            if (!eval) {
                if (failIfTimeout) {
                    Assert.fail((String)MessageFormat.format("Waiting timed out after [{0}] msec", timeout));
                } else {
                    System.out.println(MessageFormat.format("Waiting timed out after [{0}] msec", timeout));
                }
            }
            return eval ? System.currentTimeMillis() - started : -1L;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        SysPropsForTestsLoader.init();
        WAITFOR_RATIO_DEFAULT = Float.parseFloat(System.getProperty(TEST_WAITFOR_RATIO_PROP, "1"));
    }
}

