/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.apache.hadoop.lib.util.Check;
import org.apache.hadoop.lib.wsrs.Param;

public abstract class StringParam
extends Param<String> {
    private Pattern pattern;

    public StringParam(String name, String str) {
        this(name, str, null);
    }

    public StringParam(String name, String str, Pattern pattern) {
        this.pattern = pattern;
        this.value = this.parseParam(name, str);
    }

    public String parseParam(String name, String str) {
        String ret = null;
        Check.notNull((Object)name, (String)"name");
        try {
            if (str != null && (str = str.trim()).length() > 0) {
                return this.parse(str);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter [{0}], invalid value [{1}], value must be [{2}]", name, str, this.getDomain()));
        }
        return ret;
    }

    protected String parse(String str) throws Exception {
        if (this.pattern != null && !this.pattern.matcher(str).matches()) {
            throw new IllegalArgumentException("Invalid value");
        }
        return str;
    }

    protected String getDomain() {
        return this.pattern == null ? "a string" : this.pattern.pattern();
    }
}

