/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.StreamingOutput;
import org.apache.hadoop.io.IOUtils;

public class InputStreamEntity
implements StreamingOutput {
    private InputStream is;
    private long offset;
    private long len;

    public InputStreamEntity(InputStream is, long offset, long len) {
        this.is = is;
        this.offset = offset;
        this.len = len;
    }

    public InputStreamEntity(InputStream is) {
        this(is, 0L, -1L);
    }

    public void write(OutputStream os) throws IOException {
        long skipped = this.is.skip(this.offset);
        if (skipped < this.offset) {
            throw new IOException("Requested offset beyond stream size");
        }
        if (this.len == -1L) {
            IOUtils.copyBytes((InputStream)this.is, (OutputStream)os, (int)4096, (boolean)true);
        } else {
            IOUtils.copyBytes((InputStream)this.is, (OutputStream)os, (long)this.len, (boolean)true);
        }
    }
}

