/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.util;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.lib.util.Check;
import org.apache.hadoop.test.HTestCase;
import org.junit.Test;

public class TestCheck
extends HTestCase {
    @Test
    public void notNullNotNull() {
        Assert.assertEquals((String)((String)Check.notNull((Object)"value", (String)"name")), (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notNullNull() {
        Check.notNull(null, (String)"name");
    }

    @Test
    public void notNullElementsNotNull() {
        Check.notNullElements(new ArrayList(), (String)"name");
        Check.notNullElements(Arrays.asList("a"), (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notNullElementsNullList() {
        Check.notNullElements(null, (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notNullElementsNullElements() {
        Check.notNullElements(Arrays.asList("a", "", null), (String)"name");
    }

    @Test
    public void notEmptyElementsNotNull() {
        Check.notEmptyElements(new ArrayList(), (String)"name");
        Check.notEmptyElements(Arrays.asList("a"), (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyElementsNullList() {
        Check.notEmptyElements(null, (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyElementsNullElements() {
        Check.notEmptyElements(Arrays.asList("a", null), (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyElementsEmptyElements() {
        Check.notEmptyElements(Arrays.asList("a", ""), (String)"name");
    }

    @Test
    public void notEmptyNotEmtpy() {
        Assert.assertEquals((String)Check.notEmpty((String)"value", (String)"name"), (String)"value");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyNull() {
        Check.notEmpty(null, (String)"name");
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEmptyEmpty() {
        Check.notEmpty((String)"", (String)"name");
    }

    @Test
    public void validIdentifierValid() throws Exception {
        Assert.assertEquals((String)Check.validIdentifier((String)"a", (int)1, (String)""), (String)"a");
        Assert.assertEquals((String)Check.validIdentifier((String)"a1", (int)2, (String)""), (String)"a1");
        Assert.assertEquals((String)Check.validIdentifier((String)"a_", (int)3, (String)""), (String)"a_");
        Assert.assertEquals((String)Check.validIdentifier((String)"_", (int)1, (String)""), (String)"_");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validIdentifierInvalid1() throws Exception {
        Check.validIdentifier((String)"!", (int)1, (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validIdentifierInvalid2() throws Exception {
        Check.validIdentifier((String)"a1", (int)1, (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void validIdentifierInvalid3() throws Exception {
        Check.validIdentifier((String)"1", (int)1, (String)"");
    }

    @Test
    public void checkGTZeroGreater() {
        Assert.assertEquals((int)Check.gt0((int)120, (String)"test"), (int)120);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkGTZeroZero() {
        Check.gt0((int)0, (String)"test");
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkGTZeroLessThanZero() {
        Check.gt0((int)-1, (String)"test");
    }

    @Test
    public void checkGEZero() {
        Assert.assertEquals((int)Check.ge0((int)120, (String)"test"), (int)120);
        Assert.assertEquals((int)Check.ge0((int)0, (String)"test"), (int)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkGELessThanZero() {
        Check.ge0((int)-1, (String)"test");
    }
}

