/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.servlet;

import junit.framework.Assert;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.servlet.ServerWebApp;
import org.apache.hadoop.lib.servlet.TestServerWebApp;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.junit.Test;

public class TestServerWebApp
extends HTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void getHomeDirNotDef() {
        ServerWebApp.getHomeDir((String)"TestServerWebApp00");
    }

    @Test
    public void getHomeDir() {
        System.setProperty("TestServerWebApp0.home.dir", "/tmp");
        Assert.assertEquals((String)ServerWebApp.getHomeDir((String)"TestServerWebApp0"), (String)"/tmp");
        Assert.assertEquals((String)ServerWebApp.getDir((String)"TestServerWebApp0", (String)".log.dir", (String)"/tmp/log"), (String)"/tmp/log");
        System.setProperty("TestServerWebApp0.log.dir", "/tmplog");
        Assert.assertEquals((String)ServerWebApp.getDir((String)"TestServerWebApp0", (String)".log.dir", (String)"/tmp/log"), (String)"/tmplog");
    }

    @Test
    @TestDir
    public void lifecycle() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        System.setProperty("TestServerWebApp1.home.dir", dir);
        System.setProperty("TestServerWebApp1.config.dir", dir);
        System.setProperty("TestServerWebApp1.log.dir", dir);
        System.setProperty("TestServerWebApp1.temp.dir", dir);
        1 server = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.UNDEF);
        server.contextInitialized(null);
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.NORMAL);
        server.contextDestroyed(null);
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.SHUTDOWN);
    }

    @Test(expected=RuntimeException.class)
    @TestDir
    public void failedInit() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        System.setProperty("TestServerWebApp2.home.dir", dir);
        System.setProperty("TestServerWebApp2.config.dir", dir);
        System.setProperty("TestServerWebApp2.log.dir", dir);
        System.setProperty("TestServerWebApp2.temp.dir", dir);
        System.setProperty("testserverwebapp2.services", "FOO");
        2 server = new /* Unavailable Anonymous Inner Class!! */;
        server.contextInitialized(null);
    }
}

