/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.security;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.service.Groups;
import org.apache.hadoop.lib.service.security.GroupsService;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.util.StringUtils;
import org.junit.Test;

public class TestGroupsService
extends HTestCase {
    @Test
    @TestDir
    public void service() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName())));
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Groups groups = (Groups)server.get(Groups.class);
        Assert.assertNotNull((Object)groups);
        List g = groups.getGroups(System.getProperty("user.name"));
        Assert.assertNotSame((Object)g.size(), (Object)0);
        server.destroy();
    }

    @Test(expected=RuntimeException.class)
    @TestDir
    public void invalidGroupsMapping() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", StringUtils.join((CharSequence)",", Arrays.asList(GroupsService.class.getName())));
        conf.set("server.groups.hadoop.security.group.mapping", String.class.getName());
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }
}

