/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.hadoop;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.lib.service.FileSystemAccessException;
import org.apache.hadoop.lib.service.hadoop.FileSystemAccessService;
import org.apache.hadoop.lib.service.instrumentation.InstrumentationService;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestException;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestHdfsHelper;
import org.apache.hadoop.util.StringUtils;
import org.junit.Test;

public class TestFileSystemAccessService
extends HFSTestCase {
    @Test
    @TestDir
    public void simpleSecurity() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Assert.assertNotNull((Object)server.get(FileSystemAccess.class));
        server.destroy();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="H01.*")
    @TestDir
    public void noKerberosKeytabProperty() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.authentication.type", "kerberos");
        conf.set("server.hadoop.authentication.kerberos.keytab", " ");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="H01.*")
    @TestDir
    public void noKerberosPrincipalProperty() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.authentication.type", "kerberos");
        conf.set("server.hadoop.authentication.kerberos.keytab", "/tmp/foo");
        conf.set("server.hadoop.authentication.kerberos.principal", " ");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="H02.*")
    @TestDir
    public void kerberosInitializationFailure() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.authentication.type", "kerberos");
        conf.set("server.hadoop.authentication.kerberos.keytab", "/tmp/foo");
        conf.set("server.hadoop.authentication.kerberos.principal", "foo@FOO");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServiceException.class, msgRegExp="H09.*")
    @TestDir
    public void invalidSecurity() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.authentication.type", "foo");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestDir
    public void serviceHadoopConf() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.conf:foo", "FOO");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccessService fsAccess = (FileSystemAccessService)server.get(FileSystemAccess.class);
        Assert.assertEquals((String)fsAccess.serviceHadoopConf.get("foo"), (String)"FOO");
        server.destroy();
    }

    @Test
    @TestDir
    public void inWhitelists() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccessService fsAccess = (FileSystemAccessService)server.get(FileSystemAccess.class);
        fsAccess.validateNamenode("NN");
        server.destroy();
        conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.name.node.whitelist", "*");
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        fsAccess = (FileSystemAccessService)server.get(FileSystemAccess.class);
        fsAccess.validateNamenode("NN");
        server.destroy();
        conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.name.node.whitelist", "NN");
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        fsAccess = (FileSystemAccessService)server.get(FileSystemAccess.class);
        fsAccess.validateNamenode("NN");
        server.destroy();
    }

    @Test
    @TestException(exception=FileSystemAccessException.class, msgRegExp="H05.*")
    @TestDir
    public void NameNodeNotinWhitelists() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.hadoop.name.node.whitelist", "NN");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccessService fsAccess = (FileSystemAccessService)server.get(FileSystemAccess.class);
        fsAccess.validateNamenode("NNx");
    }

    @Test
    @TestDir
    @TestHdfs
    public void createFileSystem() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccess hadoop = (FileSystemAccess)server.get(FileSystemAccess.class);
        FileSystem fs = hadoop.createFileSystem("u", TestHdfsHelper.getHdfsConf());
        Assert.assertNotNull((Object)fs);
        fs.mkdirs(new Path("/tmp/foo"));
        hadoop.releaseFileSystem(fs);
        try {
            fs.mkdirs(new Path("/tmp/foo"));
            Assert.fail();
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        server.destroy();
    }

    @Test
    @TestDir
    @TestHdfs
    public void fileSystemExecutor() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccess hadoop = (FileSystemAccess)server.get(FileSystemAccess.class);
        FileSystem[] fsa = new FileSystem[1];
        hadoop.execute("u", TestHdfsHelper.getHdfsConf(), (FileSystemAccess.FileSystemExecutor)new /* Unavailable Anonymous Inner Class!! */);
        try {
            fsa[0].mkdirs(new Path("/tmp/foo"));
            Assert.fail();
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        server.destroy();
    }

    @Test
    @TestException(exception=FileSystemAccessException.class, msgRegExp="H06.*")
    @TestDir
    @TestHdfs
    public void fileSystemExecutorNoNameNode() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccess fsAccess = (FileSystemAccess)server.get(FileSystemAccess.class);
        Configuration hdfsConf = TestHdfsHelper.getHdfsConf();
        hdfsConf.set("fs.default.name", "");
        fsAccess.execute("u", hdfsConf, (FileSystemAccess.FileSystemExecutor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Test
    @TestDir
    @TestHdfs
    public void fileSystemExecutorException() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(InstrumentationService.class.getName(), FileSystemAccessService.class.getName()));
        Configuration conf = new Configuration(false);
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        FileSystemAccess hadoop = (FileSystemAccess)server.get(FileSystemAccess.class);
        FileSystem[] fsa = new FileSystem[1];
        try {
            hadoop.execute("u", TestHdfsHelper.getHdfsConf(), (FileSystemAccess.FileSystemExecutor)new /* Unavailable Anonymous Inner Class!! */);
            Assert.fail();
        }
        catch (FileSystemAccessException ex) {
            Assert.assertEquals((Object)ex.getError(), (Object)FileSystemAccessException.ERROR.H03);
        }
        catch (Exception ex) {
            Assert.fail();
        }
        try {
            fsa[0].mkdirs(new Path("/tmp/foo"));
            Assert.fail();
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            Assert.fail();
        }
        server.destroy();
    }
}

