/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.ServerException;
import org.apache.hadoop.lib.server.TestServer;
import org.apache.hadoop.test.HTestCase;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestException;
import org.apache.hadoop.util.StringUtils;
import org.junit.Test;

public class TestServer
extends HTestCase {
    private static List<String> ORDER = new ArrayList();

    @Test
    @TestDir
    public void constructorsGetters() throws Exception {
        Server server = new Server("server", "/a", "/b", "/c", "/d", new Configuration(false));
        Assert.assertEquals((String)server.getHomeDir(), (String)"/a");
        Assert.assertEquals((String)server.getConfigDir(), (String)"/b");
        Assert.assertEquals((String)server.getLogDir(), (String)"/c");
        Assert.assertEquals((String)server.getTempDir(), (String)"/d");
        Assert.assertEquals((String)server.getName(), (String)"server");
        Assert.assertEquals((String)server.getPrefix(), (String)"server");
        Assert.assertEquals((String)server.getPrefixedName("name"), (String)"server.name");
        Assert.assertNotNull((Object)server.getConfig());
        server = new Server("server", "/a", "/b", "/c", "/d");
        Assert.assertEquals((String)server.getHomeDir(), (String)"/a");
        Assert.assertEquals((String)server.getConfigDir(), (String)"/b");
        Assert.assertEquals((String)server.getLogDir(), (String)"/c");
        Assert.assertEquals((String)server.getTempDir(), (String)"/d");
        Assert.assertEquals((String)server.getName(), (String)"server");
        Assert.assertEquals((String)server.getPrefix(), (String)"server");
        Assert.assertEquals((String)server.getPrefixedName("name"), (String)"server.name");
        Assert.assertNull((Object)server.getConfig());
        server = new Server("server", TestDirHelper.getTestDir().getAbsolutePath(), new Configuration(false));
        Assert.assertEquals((String)server.getHomeDir(), (String)TestDirHelper.getTestDir().getAbsolutePath());
        Assert.assertEquals((String)server.getConfigDir(), (String)(TestDirHelper.getTestDir() + "/conf"));
        Assert.assertEquals((String)server.getLogDir(), (String)(TestDirHelper.getTestDir() + "/log"));
        Assert.assertEquals((String)server.getTempDir(), (String)(TestDirHelper.getTestDir() + "/temp"));
        Assert.assertEquals((String)server.getName(), (String)"server");
        Assert.assertEquals((String)server.getPrefix(), (String)"server");
        Assert.assertEquals((String)server.getPrefixedName("name"), (String)"server.name");
        Assert.assertNotNull((Object)server.getConfig());
        server = new Server("server", TestDirHelper.getTestDir().getAbsolutePath());
        Assert.assertEquals((String)server.getHomeDir(), (String)TestDirHelper.getTestDir().getAbsolutePath());
        Assert.assertEquals((String)server.getConfigDir(), (String)(TestDirHelper.getTestDir() + "/conf"));
        Assert.assertEquals((String)server.getLogDir(), (String)(TestDirHelper.getTestDir() + "/log"));
        Assert.assertEquals((String)server.getTempDir(), (String)(TestDirHelper.getTestDir() + "/temp"));
        Assert.assertEquals((String)server.getName(), (String)"server");
        Assert.assertEquals((String)server.getPrefix(), (String)"server");
        Assert.assertEquals((String)server.getPrefixedName("name"), (String)"server.name");
        Assert.assertNull((Object)server.getConfig());
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S01.*")
    @TestDir
    public void initNoHomeDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S02.*")
    @TestDir
    public void initHomeDirNotDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        new FileOutputStream(homeDir).close();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S01.*")
    @TestDir
    public void initNoConfigDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S02.*")
    @TestDir
    public void initConfigDirNotDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        File configDir = new File(homeDir, "conf");
        new FileOutputStream(configDir).close();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S01.*")
    @TestDir
    public void initNoLogDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S02.*")
    @TestDir
    public void initLogDirNotDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        File logDir = new File(homeDir, "log");
        new FileOutputStream(logDir).close();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S01.*")
    @TestDir
    public void initNoTempDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S02.*")
    @TestDir
    public void initTempDirNotDir() throws Exception {
        File homeDir = new File(TestDirHelper.getTestDir(), "home");
        Assert.assertTrue((boolean)homeDir.mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        File tempDir = new File(homeDir, "temp");
        new FileOutputStream(tempDir).close();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = new Server("server", homeDir.getAbsolutePath(), conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S05.*")
    @TestDir
    public void siteFileNotAFile() throws Exception {
        String homeDir = TestDirHelper.getTestDir().getAbsolutePath();
        File siteFile = new File(homeDir, "server-site.xml");
        Assert.assertTrue((boolean)siteFile.mkdir());
        Server server = new Server("server", homeDir, homeDir, homeDir, homeDir);
        server.init();
    }

    private Server createServer(Configuration conf) {
        return new Server("server", TestDirHelper.getTestDir().getAbsolutePath(), TestDirHelper.getTestDir().getAbsolutePath(), TestDirHelper.getTestDir().getAbsolutePath(), TestDirHelper.getTestDir().getAbsolutePath(), conf);
    }

    @Test
    @TestDir
    public void log4jFile() throws Exception {
        InputStream is = Server.getResource((String)"default-log4j.properties");
        FileOutputStream os = new FileOutputStream(new File(TestDirHelper.getTestDir(), "server-log4j.properties"));
        IOUtils.copyBytes((InputStream)is, (OutputStream)os, (int)1024, (boolean)true);
        Configuration conf = new Configuration(false);
        Server server = this.createServer(conf);
        server.init();
    }

    @Test
    @TestDir
    public void lifeCycle() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("server.services", LifeCycleService.class.getName());
        Server server = this.createServer(conf);
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.UNDEF);
        server.init();
        Assert.assertNotNull((Object)server.get(LifeCycleService.class));
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.NORMAL);
        server.destroy();
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.SHUTDOWN);
    }

    @Test
    @TestDir
    public void startWithStatusNotNormal() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("server.startup.status", "ADMIN");
        Server server = this.createServer(conf);
        server.init();
        Assert.assertEquals((Object)server.getStatus(), (Object)Server.Status.ADMIN);
        server.destroy();
    }

    @Test(expected=IllegalArgumentException.class)
    @TestDir
    public void nonSeteableStatus() throws Exception {
        Configuration conf = new Configuration(false);
        Server server = this.createServer(conf);
        server.init();
        server.setStatus(Server.Status.SHUTDOWN);
    }

    @Test
    @TestDir
    public void changeStatus() throws Exception {
        TestService.LIFECYCLE.clear();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = this.createServer(conf);
        server.init();
        server.setStatus(Server.Status.ADMIN);
        Assert.assertTrue((boolean)TestService.LIFECYCLE.contains("serverStatusChange"));
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S11.*")
    @TestDir
    public void changeStatusServiceException() throws Exception {
        TestService.LIFECYCLE.clear();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestServiceExceptionOnStatusChange.class.getName());
        Server server = this.createServer(conf);
        server.init();
    }

    @Test
    @TestDir
    public void setSameStatus() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = this.createServer(conf);
        server.init();
        TestService.LIFECYCLE.clear();
        server.setStatus(server.getStatus());
        Assert.assertFalse((boolean)TestService.LIFECYCLE.contains("serverStatusChange"));
    }

    @Test
    @TestDir
    public void serviceLifeCycle() throws Exception {
        TestService.LIFECYCLE.clear();
        Configuration conf = new Configuration(false);
        conf.set("server.services", TestService.class.getName());
        Server server = this.createServer(conf);
        server.init();
        Assert.assertNotNull((Object)server.get(TestService.class));
        server.destroy();
        Assert.assertEquals((Object)TestService.LIFECYCLE, Arrays.asList("init", "postInit", "serverStatusChange", "destroy"));
    }

    @Test
    @TestDir
    public void loadingDefaultConfig() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Server server = new Server("testserver", dir, dir, dir, dir);
        server.init();
        Assert.assertEquals((String)server.getConfig().get("testserver.a"), (String)"default");
    }

    @Test
    @TestDir
    public void loadingSiteConfig() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        File configFile = new File(dir, "testserver-site.xml");
        FileWriter w = new FileWriter(configFile);
        w.write("<configuration><property><name>testserver.a</name><value>site</value></property></configuration>");
        ((Writer)w).close();
        Server server = new Server("testserver", dir, dir, dir, dir);
        server.init();
        Assert.assertEquals((String)server.getConfig().get("testserver.a"), (String)"site");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @TestDir
    public void loadingSysPropConfig() throws Exception {
        try {
            System.setProperty("testserver.a", "sysprop");
            String dir = TestDirHelper.getTestDir().getAbsolutePath();
            File configFile = new File(dir, "testserver-site.xml");
            FileWriter w = new FileWriter(configFile);
            w.write("<configuration><property><name>testserver.a</name><value>site</value></property></configuration>");
            ((Writer)w).close();
            Server server = new Server("testserver", dir, dir, dir, dir);
            server.init();
            Assert.assertEquals((String)server.getConfig().get("testserver.a"), (String)"sysprop");
        }
        finally {
            System.getProperties().remove("testserver.a");
        }
    }

    @Test(expected=IllegalStateException.class)
    @TestDir
    public void illegalState1() throws Exception {
        Server server = new Server("server", TestDirHelper.getTestDir().getAbsolutePath(), new Configuration(false));
        server.destroy();
    }

    @Test(expected=IllegalStateException.class)
    @TestDir
    public void illegalState2() throws Exception {
        Server server = new Server("server", TestDirHelper.getTestDir().getAbsolutePath(), new Configuration(false));
        server.get(Object.class);
    }

    @Test(expected=IllegalStateException.class)
    @TestDir
    public void illegalState3() throws Exception {
        Server server = new Server("server", TestDirHelper.getTestDir().getAbsolutePath(), new Configuration(false));
        server.setService(null);
    }

    @Test(expected=IllegalStateException.class)
    @TestDir
    public void illegalState4() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Server server = new Server("server", dir, dir, dir, dir, new Configuration(false));
        server.init();
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S08.*")
    @TestDir
    public void invalidSservice() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", "foo");
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S07.*")
    @TestDir
    public void serviceWithNoDefaultConstructor() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", MyService7.class.getName());
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S04.*")
    @TestDir
    public void serviceNotImplementingServiceInterface() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        conf.set("server.services", MyService4.class.getName());
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestException(exception=ServerException.class, msgRegExp="S10.*")
    @TestDir
    public void serviceWithMissingDependency() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration conf = new Configuration(false);
        String services = StringUtils.join((CharSequence)",", Arrays.asList(MyService3.class.getName(), MyService6.class.getName()));
        conf.set("server.services", services);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
    }

    @Test
    @TestDir
    public void services() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        ORDER.clear();
        Configuration conf = new Configuration(false);
        Server server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Assert.assertEquals((int)ORDER.size(), (int)0);
        ORDER.clear();
        String services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService3.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Assert.assertEquals((Object)((MyService1)server.get(MyService1.class)).getInterface(), MyService1.class);
        Assert.assertEquals((Object)((MyService3)server.get(MyService3.class)).getInterface(), MyService3.class);
        Assert.assertEquals((int)ORDER.size(), (int)4);
        Assert.assertEquals((String)((String)ORDER.get(0)), (String)"s1.init");
        Assert.assertEquals((String)((String)ORDER.get(1)), (String)"s3.init");
        Assert.assertEquals((String)((String)ORDER.get(2)), (String)"s1.postInit");
        Assert.assertEquals((String)((String)ORDER.get(3)), (String)"s3.postInit");
        server.destroy();
        Assert.assertEquals((int)ORDER.size(), (int)6);
        Assert.assertEquals((String)((String)ORDER.get(4)), (String)"s3.destroy");
        Assert.assertEquals((String)((String)ORDER.get(5)), (String)"s1.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService2.class.getName(), MyService3.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        try {
            server.init();
            Assert.fail();
        }
        catch (ServerException ex) {
            Assert.assertEquals(MyService2.class, ex.getError().getClass());
        }
        catch (Exception ex) {
            Assert.fail();
        }
        Assert.assertEquals((int)ORDER.size(), (int)3);
        Assert.assertEquals((String)((String)ORDER.get(0)), (String)"s1.init");
        Assert.assertEquals((String)((String)ORDER.get(1)), (String)"s2.init");
        Assert.assertEquals((String)((String)ORDER.get(2)), (String)"s1.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService5.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Assert.assertEquals((int)ORDER.size(), (int)4);
        Assert.assertEquals((String)((String)ORDER.get(0)), (String)"s1.init");
        Assert.assertEquals((String)((String)ORDER.get(1)), (String)"s5.init");
        Assert.assertEquals((String)((String)ORDER.get(2)), (String)"s1.postInit");
        Assert.assertEquals((String)((String)ORDER.get(3)), (String)"s5.postInit");
        server.destroy();
        Assert.assertEquals((int)ORDER.size(), (int)6);
        Assert.assertEquals((String)((String)ORDER.get(4)), (String)"s5.destroy");
        Assert.assertEquals((String)((String)ORDER.get(5)), (String)"s1.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService3.class.getName()));
        String servicesExt = StringUtils.join((CharSequence)",", Arrays.asList(MyService1a.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        conf.set("server.services.ext", servicesExt);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Assert.assertEquals(((MyService1)server.get(MyService1.class)).getClass(), MyService1a.class);
        Assert.assertEquals((int)ORDER.size(), (int)4);
        Assert.assertEquals((String)((String)ORDER.get(0)), (String)"s1a.init");
        Assert.assertEquals((String)((String)ORDER.get(1)), (String)"s3.init");
        Assert.assertEquals((String)((String)ORDER.get(2)), (String)"s1a.postInit");
        Assert.assertEquals((String)((String)ORDER.get(3)), (String)"s3.postInit");
        server.destroy();
        Assert.assertEquals((int)ORDER.size(), (int)6);
        Assert.assertEquals((String)((String)ORDER.get(4)), (String)"s3.destroy");
        Assert.assertEquals((String)((String)ORDER.get(5)), (String)"s1a.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService3.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        server.setService(MyService1a.class);
        Assert.assertEquals((int)ORDER.size(), (int)6);
        Assert.assertEquals((String)((String)ORDER.get(4)), (String)"s1.destroy");
        Assert.assertEquals((String)((String)ORDER.get(5)), (String)"s1a.init");
        Assert.assertEquals(((MyService1)server.get(MyService1.class)).getClass(), MyService1a.class);
        server.destroy();
        Assert.assertEquals((int)ORDER.size(), (int)8);
        Assert.assertEquals((String)((String)ORDER.get(6)), (String)"s3.destroy");
        Assert.assertEquals((String)((String)ORDER.get(7)), (String)"s1a.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService3.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        server.setService(MyService5.class);
        Assert.assertEquals((int)ORDER.size(), (int)5);
        Assert.assertEquals((String)((String)ORDER.get(4)), (String)"s5.init");
        Assert.assertEquals(((MyService5)server.get(MyService5.class)).getClass(), MyService5.class);
        server.destroy();
        Assert.assertEquals((int)ORDER.size(), (int)8);
        Assert.assertEquals((String)((String)ORDER.get(5)), (String)"s5.destroy");
        Assert.assertEquals((String)((String)ORDER.get(6)), (String)"s3.destroy");
        Assert.assertEquals((String)((String)ORDER.get(7)), (String)"s1.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService3.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        try {
            server.setService(MyService7.class);
            Assert.fail();
        }
        catch (ServerException ex) {
            Assert.assertEquals((Object)ServerException.ERROR.S09, (Object)ex.getError());
        }
        catch (Exception ex) {
            Assert.fail();
        }
        Assert.assertEquals((int)ORDER.size(), (int)6);
        Assert.assertEquals((String)((String)ORDER.get(4)), (String)"s3.destroy");
        Assert.assertEquals((String)((String)ORDER.get(5)), (String)"s1.destroy");
        ORDER.clear();
        services = StringUtils.join((CharSequence)",", Arrays.asList(MyService1.class.getName(), MyService6.class.getName()));
        conf = new Configuration(false);
        conf.set("server.services", services);
        server = new Server("server", dir, dir, dir, dir, conf);
        server.init();
        Assert.assertEquals((Object)((MyService1)server.get(MyService1.class)).getInterface(), MyService1.class);
        Assert.assertEquals((Object)((MyService6)server.get(MyService6.class)).getInterface(), MyService6.class);
        server.destroy();
    }

    static /* synthetic */ List access$000() {
        return ORDER;
    }
}

