/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.server;

import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.TestBaseService;
import org.apache.hadoop.test.HTestCase;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBaseService
extends HTestCase {
    @Test
    public void baseService() throws Exception {
        MyService service = new MyService();
        Assert.assertNull((Object)service.getInterface());
        Assert.assertEquals((String)service.getPrefix(), (String)"myservice");
        Assert.assertEquals((int)service.getServiceDependencies().length, (int)0);
        Server server = (Server)Mockito.mock(Server.class);
        Configuration conf = new Configuration(false);
        conf.set("server.myservice.foo", "FOO");
        conf.set("server.myservice1.bar", "BAR");
        Mockito.when((Object)server.getConfig()).thenReturn((Object)conf);
        Mockito.when((Object)server.getPrefixedName("myservice.foo")).thenReturn((Object)"server.myservice.foo");
        Mockito.when((Object)server.getPrefixedName("myservice.")).thenReturn((Object)"server.myservice.");
        service.init(server);
        Assert.assertEquals((String)service.getPrefixedName("foo"), (String)"server.myservice.foo");
        Assert.assertEquals((int)service.getServiceConfig().size(), (int)1);
        Assert.assertEquals((String)service.getServiceConfig().get("foo"), (String)"FOO");
        Assert.assertTrue((boolean)MyService.INIT);
    }
}

