/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.lib.service.security.DummyGroupMapping;
import org.apache.hadoop.test.HFSTestCase;
import org.apache.hadoop.test.HadoopUsersConfTestHelper;
import org.apache.hadoop.test.TestDir;
import org.apache.hadoop.test.TestDirHelper;
import org.apache.hadoop.test.TestHdfs;
import org.apache.hadoop.test.TestHdfsHelper;
import org.apache.hadoop.test.TestJetty;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Test;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

public class TestHttpFSServer
extends HFSTestCase {
    @Test
    @TestDir
    @TestJetty
    public void server() throws Exception {
        String dir = TestDirHelper.getTestDir().getAbsolutePath();
        Configuration hoopConf = new Configuration(false);
        HttpFSServerWebApp server = new HttpFSServerWebApp(dir, dir, dir, dir, hoopConf);
        server.init();
        server.destroy();
    }

    private void createHttpFSServer() throws Exception {
        File homeDir = TestDirHelper.getTestDir();
        Assert.assertTrue((boolean)new File(homeDir, "conf").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "log").mkdir());
        Assert.assertTrue((boolean)new File(homeDir, "temp").mkdir());
        HttpFSServerWebApp.setHomeDirForCurrentThread((String)homeDir.getAbsolutePath());
        File secretFile = new File(new File(homeDir, "conf"), "secret");
        FileWriter w = new FileWriter(secretFile);
        w.write("secret");
        ((Writer)w).close();
        String fsDefaultName = TestHdfsHelper.getHdfsConf().get("fs.default.name");
        Configuration conf = new Configuration(false);
        conf.set("httpfs.hadoop.conf:fs.default.name", fsDefaultName);
        conf.set("httpfs.groups.hadoop.security.group.mapping", DummyGroupMapping.class.getName());
        conf.set("httpfs.authentication.signature.secret.file", secretFile.getAbsolutePath());
        File hoopSite = new File(new File(homeDir, "conf"), "httpfs-site.xml");
        FileOutputStream os = new FileOutputStream(hoopSite);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("webapp");
        WebAppContext context = new WebAppContext(url.getPath(), "/webhdfs");
        Server server = TestJettyHelper.getJettyServer();
        server.addHandler((Handler)context);
        server.start();
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void instrumentation() throws Exception {
        this.createHttpFSServer();
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1?user.name={0}&op=instrumentation", "nobody"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((int)conn.getResponseCode(), (int)401);
        url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1?user.name={0}&op=instrumentation", "root"));
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((int)conn.getResponseCode(), (int)200);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = reader.readLine();
        reader.close();
        Assert.assertTrue((boolean)line.contains("\"counters\":{"));
        url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/foo?user.name={0}&op=instrumentation", "root"));
        conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((int)conn.getResponseCode(), (int)400);
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testHdfsAccess() throws Exception {
        this.createHttpFSServer();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/?user.name={0}&op=liststatus", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((int)conn.getResponseCode(), (int)200);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        reader.readLine();
        reader.close();
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testGlobFilter() throws Exception {
        this.createHttpFSServer();
        FileSystem fs = FileSystem.get((Configuration)TestHdfsHelper.getHdfsConf());
        fs.mkdirs(new Path("/tmp"));
        fs.create(new Path("/tmp/foo.txt")).close();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/tmp?user.name={0}&op=liststatus&filter=f*", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((int)conn.getResponseCode(), (int)200);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        reader.readLine();
        reader.close();
    }

    @Test
    @TestDir
    @TestJetty
    @TestHdfs
    public void testPutNoOperation() throws Exception {
        this.createHttpFSServer();
        String user = HadoopUsersConfTestHelper.getHadoopUsers()[0];
        URL url = new URL(TestJettyHelper.getJettyURL(), MessageFormat.format("/webhdfs/v1/foo?user.name={0}", user));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod("PUT");
        Assert.assertEquals((int)conn.getResponseCode(), (int)400);
    }
}

