/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.CheckUploadContentTypeFilter;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCheckUploadContentTypeFilter {
    @Test
    public void putUpload() throws Exception {
        this.test("PUT", HttpFSFileSystem.PutOpValues.CREATE.toString(), "application/octet-stream", true, false);
    }

    @Test
    public void postUpload() throws Exception {
        this.test("POST", HttpFSFileSystem.PostOpValues.APPEND.toString(), "APPLICATION/OCTET-STREAM", true, false);
    }

    @Test
    public void putUploadWrong() throws Exception {
        this.test("PUT", HttpFSFileSystem.PutOpValues.CREATE.toString(), "plain/text", false, false);
        this.test("PUT", HttpFSFileSystem.PutOpValues.CREATE.toString(), "plain/text", true, true);
    }

    @Test
    public void postUploadWrong() throws Exception {
        this.test("POST", HttpFSFileSystem.PostOpValues.APPEND.toString(), "plain/text", false, false);
        this.test("POST", HttpFSFileSystem.PostOpValues.APPEND.toString(), "plain/text", true, true);
    }

    @Test
    public void getOther() throws Exception {
        this.test("GET", HttpFSFileSystem.GetOpValues.GETHOMEDIR.toString(), "plain/text", false, false);
    }

    @Test
    public void putOther() throws Exception {
        this.test("PUT", HttpFSFileSystem.PutOpValues.MKDIRS.toString(), "plain/text", false, false);
    }

    private void test(String method, String operation, String contentType, boolean upload, boolean error) throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.reset((Object[])new HttpServletRequest[]{request});
        Mockito.when((Object)request.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)request.getParameter("op")).thenReturn((Object)operation);
        Mockito.when((Object)request.getParameter("data")).thenReturn((Object)Boolean.toString(upload));
        Mockito.when((Object)request.getContentType()).thenReturn((Object)contentType);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        CheckUploadContentTypeFilter filter = new CheckUploadContentTypeFilter();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        if (error) {
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)400), Mockito.contains((String)"Data upload"));
        } else {
            ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

