/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.hadoop.lib.service.FileSystemAccessException;
import org.apache.hadoop.lib.wsrs.ExceptionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Provider
public class HttpFSExceptionProvider
extends ExceptionProvider {
    private static Logger AUDIT_LOG = LoggerFactory.getLogger((String)"httpfsaudit");
    private static Logger LOG = LoggerFactory.getLogger(HttpFSExceptionProvider.class);

    public Response toResponse(Throwable throwable) {
        if (throwable instanceof FileSystemAccessException) {
            throwable = throwable.getCause();
        }
        Response.Status status = throwable instanceof SecurityException ? Response.Status.UNAUTHORIZED : (throwable instanceof FileNotFoundException ? Response.Status.NOT_FOUND : (throwable instanceof IOException ? Response.Status.INTERNAL_SERVER_ERROR : (throwable instanceof UnsupportedOperationException ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR)));
        return this.createResponse(status, throwable);
    }

    protected void log(Response.Status status, Throwable throwable) {
        String method = MDC.get((String)"method");
        String path = MDC.get((String)"path");
        String message = this.getOneLineMessage(throwable);
        AUDIT_LOG.warn("FAILED [{}:{}] response [{}] {}", new Object[]{method, path, status, message});
        LOG.warn("[{}:{}] response [{}] {}", new Object[]{method, path, status, message, throwable});
    }
}

