/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import org.junit.Test;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mortbay.jetty.Server;

public class TestJettyHelper
implements MethodRule {
    private static ThreadLocal<Server> TEST_SERVLET_TL = new InheritableThreadLocal();

    @Test
    public void dummy() {
    }

    public Statement apply(Statement statement, FrameworkMethod frameworkMethod, Object o) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Server createJettyServer() {
        try {
            String host = InetAddress.getLocalHost().getHostName();
            ServerSocket ss = new ServerSocket(0);
            int port = ss.getLocalPort();
            ss.close();
            Server server = new Server(0);
            server.getConnectors()[0].setHost(host);
            server.getConnectors()[0].setPort(port);
            return server;
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not stop embedded servlet container, " + ex.getMessage(), ex);
        }
    }

    public static Server getJettyServer() {
        Server server = (Server)TEST_SERVLET_TL.get();
        if (server == null) {
            throw new IllegalStateException("This test does not use @TestJetty");
        }
        return server;
    }

    public static URL getJettyURL() {
        Server server = (Server)TEST_SERVLET_TL.get();
        if (server == null) {
            throw new IllegalStateException("This test does not use @TestJetty");
        }
        try {
            return new URL("http://" + server.getConnectors()[0].getHost() + ":" + server.getConnectors()[0].getPort());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("It should never happen, " + ex.getMessage(), ex);
        }
    }

    static /* synthetic */ Server access$000(TestJettyHelper x0) {
        return x0.createJettyServer();
    }

    static /* synthetic */ ThreadLocal access$100() {
        return TEST_SERVLET_TL;
    }
}

