/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;

public class SysPropsForTestsLoader {
    public static final String TEST_PROPERTIES_PROP = "test.properties";

    public static void init() {
    }

    static {
        try {
            String testFileName = System.getProperty(TEST_PROPERTIES_PROP, TEST_PROPERTIES_PROP);
            File currentDir = new File(testFileName).getAbsoluteFile().getParentFile();
            File testFile = new File(currentDir, testFileName);
            while (currentDir != null && !testFile.exists()) {
                testFile = new File(testFile.getAbsoluteFile().getParentFile().getParentFile(), testFileName);
                if ((currentDir = currentDir.getParentFile()) == null) continue;
                testFile = new File(currentDir, testFileName);
            }
            if (testFile.exists()) {
                System.out.println();
                System.out.println(">>> test.properties : " + testFile.getAbsolutePath());
                Properties testProperties = new Properties();
                testProperties.load(new FileReader(testFile));
                for (Map.Entry<Object, Object> entry : testProperties.entrySet()) {
                    if (System.getProperties().containsKey(entry.getKey())) continue;
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            } else if (System.getProperty(TEST_PROPERTIES_PROP) != null) {
                System.err.println(MessageFormat.format("Specified 'test.properties' file does not exist [{0}]", System.getProperty(TEST_PROPERTIES_PROP)));
                System.exit(-1);
            } else {
                System.out.println(">>> test.properties : <NONE>");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

