/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.test;

import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.SysPropsForTestsLoader;

/*
 * Exception performing whole class analysis ignored.
 */
public class HadoopUsersConfTestHelper {
    public static final String HADOOP_PROXYUSER = "test.hadoop.proxyuser";
    public static final String HADOOP_PROXYUSER_HOSTS = "test.hadoop.proxyuser.hosts";
    public static final String HADOOP_PROXYUSER_GROUPS = "test.hadoop.proxyuser.groups";
    public static final String HADOOP_USER_PREFIX = "test.hadoop.user.";
    private static final String[] DEFAULT_USERS;
    private static final String[] DEFAULT_USERS_GROUP;

    public static String getHadoopProxyUser() {
        return System.getProperty("test.hadoop.proxyuser", System.getProperty("user.name"));
    }

    public static String getHadoopProxyUserHosts() {
        return System.getProperty("test.hadoop.proxyuser.hosts", "*");
    }

    public static String getHadoopProxyUserGroups() {
        return System.getProperty("test.hadoop.proxyuser.groups", "*");
    }

    public static String[] getHadoopUsers() {
        ArrayList<String> users = new ArrayList<String>();
        for (String name : System.getProperties().stringPropertyNames()) {
            if (!name.startsWith("test.hadoop.user.")) continue;
            users.add(name.substring("test.hadoop.user.".length()));
        }
        return users.size() != 0 ? users.toArray(new String[users.size()]) : DEFAULT_USERS;
    }

    public static String[] getHadoopUserGroups(String user) {
        if (HadoopUsersConfTestHelper.getHadoopUsers() == DEFAULT_USERS) {
            return DEFAULT_USERS_GROUP;
        }
        String groups = System.getProperty("test.hadoop.user." + user);
        return groups != null ? groups.split(",") : new String[]{};
    }

    public static Configuration getBaseConf() {
        Configuration conf = new Configuration();
        for (String name : System.getProperties().stringPropertyNames()) {
            conf.set(name, System.getProperty(name));
        }
        return conf;
    }

    public static void addUserConf(Configuration conf) {
        conf.set("hadoop.security.authentication", "simple");
        conf.set("hadoop.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".hosts", HadoopUsersConfTestHelper.getHadoopProxyUserHosts());
        conf.set("hadoop.proxyuser." + HadoopUsersConfTestHelper.getHadoopProxyUser() + ".groups", HadoopUsersConfTestHelper.getHadoopProxyUserGroups());
        for (String user : HadoopUsersConfTestHelper.getHadoopUsers()) {
            String[] groups = HadoopUsersConfTestHelper.getHadoopUserGroups((String)user);
            UserGroupInformation.createUserForTesting((String)user, (String[])groups);
        }
    }

    static {
        SysPropsForTestsLoader.init();
        DEFAULT_USERS = new String[]{"user1", "user2"};
        DEFAULT_USERS_GROUP = new String[]{"group1", "supergroup"};
    }
}

