/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.wsrs;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import java.security.Principal;
import javax.ws.rs.core.MultivaluedMap;
import junit.framework.Assert;
import org.apache.hadoop.lib.wsrs.UserProvider;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.MDC;

public class TestUserProvider {
    @Test
    public void noUser() {
        MDC.remove((String)"user");
        HttpRequestContext request = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn(null);
        MultivaluedMap map = (MultivaluedMap)Mockito.mock(MultivaluedMap.class);
        Mockito.when((Object)map.getFirst((Object)"user.name")).thenReturn(null);
        Mockito.when((Object)request.getQueryParameters()).thenReturn((Object)map);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
        UserProvider up = new UserProvider();
        Assert.assertNull((Object)up.getValue(context));
        Assert.assertNull((Object)MDC.get((String)"user"));
    }

    @Test
    public void queryStringUser() {
        MDC.remove((String)"user");
        HttpRequestContext request = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn(null);
        MultivaluedMap map = (MultivaluedMap)Mockito.mock(MultivaluedMap.class);
        Mockito.when((Object)map.getFirst((Object)"user.name")).thenReturn((Object)"foo");
        Mockito.when((Object)request.getQueryParameters()).thenReturn((Object)map);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
        UserProvider up = new UserProvider();
        Assert.assertEquals((String)up.getValue(context).getName(), (String)"foo");
        Assert.assertEquals((String)MDC.get((String)"user"), (String)"foo");
    }

    @Test
    public void principalUser() {
        MDC.remove((String)"user");
        HttpRequestContext request = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)request.getUserPrincipal()).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)context.getRequest()).thenReturn((Object)request);
        UserProvider up = new UserProvider();
        Assert.assertEquals((String)up.getValue(context).getName(), (String)"bar");
        Assert.assertEquals((String)MDC.get((String)"user"), (String)"bar");
    }

    @Test
    public void getters() {
        UserProvider up = new UserProvider();
        Assert.assertEquals((Object)up.getScope(), (Object)ComponentScope.PerRequest);
        Assert.assertEquals((Object)up.getInjectable(null, null, Principal.class), (Object)up);
        Assert.assertNull((Object)up.getInjectable(null, null, String.class));
    }
}

