/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.util.ConfigurationUtils;
import org.junit.Test;

public class TestConfigurationUtils {
    @Test
    public void constructors() throws Exception {
        Configuration conf = new Configuration(false);
        Assert.assertEquals((int)conf.size(), (int)0);
        byte[] bytes = "<configuration><property><name>a</name><value>A</value></property></configuration>".getBytes();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        conf = new Configuration(false);
        ConfigurationUtils.load((Configuration)conf, (InputStream)is);
        Assert.assertEquals((int)conf.size(), (int)1);
        Assert.assertEquals((String)conf.get("a"), (String)"A");
    }

    @Test(expected=IOException.class)
    public void constructorsFail3() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("<xonfiguration></xonfiguration>".getBytes());
        Configuration conf = new Configuration(false);
        ConfigurationUtils.load((Configuration)conf, (InputStream)is);
    }

    @Test
    public void copy() throws Exception {
        Configuration srcConf = new Configuration(false);
        Configuration targetConf = new Configuration(false);
        srcConf.set("testParameter1", "valueFromSource");
        srcConf.set("testParameter2", "valueFromSource");
        targetConf.set("testParameter2", "valueFromTarget");
        targetConf.set("testParameter3", "valueFromTarget");
        ConfigurationUtils.copy((Configuration)srcConf, (Configuration)targetConf);
        Assert.assertEquals((String)"valueFromSource", (String)targetConf.get("testParameter1"));
        Assert.assertEquals((String)"valueFromSource", (String)targetConf.get("testParameter2"));
        Assert.assertEquals((String)"valueFromTarget", (String)targetConf.get("testParameter3"));
    }

    @Test
    public void injectDefaults() throws Exception {
        Configuration srcConf = new Configuration(false);
        Configuration targetConf = new Configuration(false);
        srcConf.set("testParameter1", "valueFromSource");
        srcConf.set("testParameter2", "valueFromSource");
        targetConf.set("testParameter2", "originalValueFromTarget");
        targetConf.set("testParameter3", "originalValueFromTarget");
        ConfigurationUtils.injectDefaults((Configuration)srcConf, (Configuration)targetConf);
        Assert.assertEquals((String)"valueFromSource", (String)targetConf.get("testParameter1"));
        Assert.assertEquals((String)"originalValueFromTarget", (String)targetConf.get("testParameter2"));
        Assert.assertEquals((String)"originalValueFromTarget", (String)targetConf.get("testParameter3"));
        Assert.assertEquals((String)"valueFromSource", (String)srcConf.get("testParameter1"));
        Assert.assertEquals((String)"valueFromSource", (String)srcConf.get("testParameter2"));
        Assert.assertNull((Object)srcConf.get("testParameter3"));
    }

    @Test
    public void resolve() {
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "${a}");
        Assert.assertEquals((String)conf.getRaw("a"), (String)"A");
        Assert.assertEquals((String)conf.getRaw("b"), (String)"${a}");
        conf = ConfigurationUtils.resolve((Configuration)conf);
        Assert.assertEquals((String)conf.getRaw("a"), (String)"A");
        Assert.assertEquals((String)conf.getRaw("b"), (String)"A");
    }

    @Test
    public void testVarResolutionAndSysProps() {
        String userName = System.getProperty("user.name");
        Configuration conf = new Configuration(false);
        conf.set("a", "A");
        conf.set("b", "${a}");
        conf.set("c", "${user.name}");
        conf.set("d", "${aaa}");
        Assert.assertEquals((String)conf.getRaw("a"), (String)"A");
        Assert.assertEquals((String)conf.getRaw("b"), (String)"${a}");
        Assert.assertEquals((String)conf.getRaw("c"), (String)"${user.name}");
        Assert.assertEquals((String)conf.get("a"), (String)"A");
        Assert.assertEquals((String)conf.get("b"), (String)"A");
        Assert.assertEquals((String)conf.get("c"), (String)userName);
        Assert.assertEquals((String)conf.get("d"), (String)"${aaa}");
        conf.set("user.name", "foo");
        Assert.assertEquals((String)conf.get("user.name"), (String)"foo");
    }
}

