/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.service.instrumentation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.lib.server.BaseService;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.service.Scheduler;
import org.apache.hadoop.lib.service.instrumentation.InstrumentationService;

public class InstrumentationService
extends BaseService
implements Instrumentation {
    public static final String PREFIX = "instrumentation";
    public static final String CONF_TIMERS_SIZE = "timers.size";
    private int timersSize;
    private Lock counterLock;
    private Lock timerLock;
    private Lock variableLock;
    private Lock samplerLock;
    private Map<String, Map<String, AtomicLong>> counters;
    private Map<String, Map<String, Timer>> timers;
    private Map<String, Map<String, VariableHolder>> variables;
    private Map<String, Map<String, Sampler>> samplers;
    private List<Sampler> samplersList;
    private Map<String, Map<String, ?>> all;

    public InstrumentationService() {
        super(PREFIX);
    }

    public void init() throws ServiceException {
        this.timersSize = this.getServiceConfig().getInt(CONF_TIMERS_SIZE, 10);
        this.counterLock = new ReentrantLock();
        this.timerLock = new ReentrantLock();
        this.variableLock = new ReentrantLock();
        this.samplerLock = new ReentrantLock();
        ConcurrentHashMap<String, VariableHolder> jvmVariables = new ConcurrentHashMap<String, VariableHolder>();
        this.counters = new ConcurrentHashMap();
        this.timers = new ConcurrentHashMap();
        this.variables = new ConcurrentHashMap();
        this.samplers = new ConcurrentHashMap();
        this.samplersList = new ArrayList();
        this.all = new LinkedHashMap();
        this.all.put("os-env", System.getenv());
        this.all.put("sys-props", System.getProperties());
        this.all.put("jvm", jvmVariables);
        this.all.put("counters", this.counters);
        this.all.put("timers", this.timers);
        this.all.put("variables", this.variables);
        this.all.put("samplers", this.samplers);
        jvmVariables.put("free.memory", new VariableHolder((Instrumentation.Variable)new /* Unavailable Anonymous Inner Class!! */));
        jvmVariables.put("max.memory", new VariableHolder((Instrumentation.Variable)new /* Unavailable Anonymous Inner Class!! */));
        jvmVariables.put("total.memory", new VariableHolder((Instrumentation.Variable)new /* Unavailable Anonymous Inner Class!! */));
    }

    public void postInit() throws ServiceException {
        Scheduler scheduler = (Scheduler)this.getServer().get(Scheduler.class);
        if (scheduler != null) {
            scheduler.schedule((Runnable)new SamplersRunnable(this), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    public Class getInterface() {
        return Instrumentation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getToAdd(String group, String name, Class<T> klass, Lock lock, Map<String, Map<String, T>> map) {
        boolean locked = false;
        try {
            Object element;
            Map<String, T> groupMap = map.get(group);
            if (groupMap == null) {
                lock.lock();
                locked = true;
                groupMap = map.get(group);
                if (groupMap == null) {
                    groupMap = new ConcurrentHashMap<String, T>();
                    map.put(group, groupMap);
                }
            }
            if ((element = groupMap.get(name)) == null) {
                if (!locked) {
                    lock.lock();
                    locked = true;
                }
                if ((element = groupMap.get(name)) == null) {
                    try {
                        element = klass == Timer.class ? new Timer(this.timersSize) : klass.newInstance();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                    groupMap.put(name, element);
                }
            }
            T t = element;
            return t;
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    public Cron createCron() {
        return new Cron();
    }

    public void incr(String group, String name, long count) {
        AtomicLong counter = (AtomicLong)this.getToAdd(group, name, AtomicLong.class, this.counterLock, this.counters);
        counter.addAndGet(count);
    }

    public void addCron(String group, String name, Instrumentation.Cron cron) {
        Timer timer = (Timer)this.getToAdd(group, name, Timer.class, this.timerLock, this.timers);
        timer.addCron((Cron)cron);
    }

    public void addVariable(String group, String name, Instrumentation.Variable<?> variable) {
        VariableHolder holder = (VariableHolder)this.getToAdd(group, name, VariableHolder.class, this.variableLock, this.variables);
        holder.var = variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSampler(String group, String name, int samplingSize, Instrumentation.Variable<Long> variable) {
        Sampler sampler = (Sampler)this.getToAdd(group, name, Sampler.class, this.samplerLock, this.samplers);
        this.samplerLock.lock();
        try {
            sampler.init(samplingSize, variable);
            this.samplersList.add(sampler);
        }
        finally {
            this.samplerLock.unlock();
        }
    }

    public Map<String, Map<String, ?>> getSnapshot() {
        return this.all;
    }

    static /* synthetic */ Lock access$000(InstrumentationService x0) {
        return x0.samplerLock;
    }

    static /* synthetic */ List access$100(InstrumentationService x0) {
        return x0.samplersList;
    }
}

