/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.AccessControlException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.http.client.HttpFSFileSystem;
import org.apache.hadoop.fs.http.server.FSOperations;
import org.apache.hadoop.fs.http.server.HttpFSParams;
import org.apache.hadoop.fs.http.server.HttpFSServer;
import org.apache.hadoop.fs.http.server.HttpFSServerWebApp;
import org.apache.hadoop.lib.service.FileSystemAccess;
import org.apache.hadoop.lib.service.FileSystemAccessException;
import org.apache.hadoop.lib.service.Groups;
import org.apache.hadoop.lib.service.Instrumentation;
import org.apache.hadoop.lib.service.ProxyUser;
import org.apache.hadoop.lib.servlet.FileSystemReleaseFilter;
import org.apache.hadoop.lib.servlet.HostnameFilter;
import org.apache.hadoop.lib.wsrs.InputStreamEntity;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Path(value="/v1")
public class HttpFSServer {
    private static Logger AUDIT_LOG = LoggerFactory.getLogger((String)"httpfsaudit");

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response root(@Context Principal user, @QueryParam(value="op") HttpFSParams.GetOpParam op, @QueryParam(value="filter") @DefaultValue(value="") HttpFSParams.FilterParam filter, @QueryParam(value="doas") @DefaultValue(value="") HttpFSParams.DoAsParam doAs) throws IOException, FileSystemAccessException {
        return this.get(user, new HttpFSParams.FsPathParam(""), op, new HttpFSParams.OffsetParam("0"), new HttpFSParams.LenParam("-1"), filter, doAs, new HttpFSParams.OverwriteParam("true"), new HttpFSParams.BlockSizeParam("-1"), new HttpFSParams.PermissionParam("default"), new HttpFSParams.ReplicationParam("-1"));
    }

    private String getEffectiveUser(Principal user, String doAs) throws IOException {
        String effectiveUser = user.getName();
        if (doAs != null && !doAs.equals(user.getName())) {
            ProxyUser proxyUser = (ProxyUser)HttpFSServerWebApp.get().get(ProxyUser.class);
            proxyUser.validate(user.getName(), HostnameFilter.get(), doAs);
            effectiveUser = doAs;
            AUDIT_LOG.info("Proxy user [{}] DoAs user [{}]", (Object)user.getName(), (Object)doAs);
        }
        return effectiveUser;
    }

    private <T> T fsExecute(Principal user, String doAs, FileSystemAccess.FileSystemExecutor<T> executor) throws IOException, FileSystemAccessException {
        String hadoopUser = this.getEffectiveUser(user, doAs);
        FileSystemAccess fsAccess = (FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = ((FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class)).getDefaultConfiguration();
        return (T)fsAccess.execute(hadoopUser, conf, executor);
    }

    private FileSystem createFileSystem(Principal user, String doAs) throws IOException, FileSystemAccessException {
        String hadoopUser = this.getEffectiveUser(user, doAs);
        FileSystemAccess fsAccess = (FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class);
        Configuration conf = ((FileSystemAccess)HttpFSServerWebApp.get().get(FileSystemAccess.class)).getDefaultConfiguration();
        FileSystem fs = fsAccess.createFileSystem(hadoopUser, conf);
        FileSystemReleaseFilter.setFileSystem((FileSystem)fs);
        return fs;
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response get(@Context Principal user, @PathParam(value="path") @DefaultValue(value="") HttpFSParams.FsPathParam path, @QueryParam(value="op") HttpFSParams.GetOpParam op, @QueryParam(value="offset") @DefaultValue(value="0") HttpFSParams.OffsetParam offset, @QueryParam(value="len") @DefaultValue(value="-1") HttpFSParams.LenParam len, @QueryParam(value="filter") @DefaultValue(value="") HttpFSParams.FilterParam filter, @QueryParam(value="doas") @DefaultValue(value="") HttpFSParams.DoAsParam doAs, @QueryParam(value="overwrite") @DefaultValue(value="true") HttpFSParams.OverwriteParam override, @QueryParam(value="blocksize") @DefaultValue(value="-1") HttpFSParams.BlockSizeParam blockSize, @QueryParam(value="permission") @DefaultValue(value="default") HttpFSParams.PermissionParam permission, @QueryParam(value="replication") @DefaultValue(value="-1") HttpFSParams.ReplicationParam replication) throws IOException, FileSystemAccessException {
        Response response = null;
        if (op == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Missing [{0}] parameter", "op"));
        }
        path.makeAbsolute();
        MDC.put((String)"op", (String)((HttpFSFileSystem.GetOpValues)op.value()).name());
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$GetOpValues[((HttpFSFileSystem.GetOpValues)op.value()).ordinal()]) {
            case 1: {
                FSOperations.FSOpen command = new FSOperations.FSOpen((String)path.value());
                FileSystem fs = this.createFileSystem(user, (String)doAs.value());
                InputStream is = command.execute(fs);
                AUDIT_LOG.info("[{}] offset [{}] len [{}]", new Object[]{path, offset, len});
                InputStreamEntity entity = new InputStreamEntity(is, ((Long)offset.value()).longValue(), ((Long)len.value()).longValue());
                response = Response.ok((Object)entity).type("application/octet-stream").build();
                break;
            }
            case 2: {
                FSOperations.FSFileStatus command = new FSOperations.FSFileStatus((String)path.value());
                Map json = (Map)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 3: {
                FSOperations.FSListStatus command = new FSOperations.FSListStatus((String)path.value(), (String)filter.value());
                Map json = (Map)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                if (filter.value() == null) {
                    AUDIT_LOG.info("[{}]", (Object)path);
                } else {
                    AUDIT_LOG.info("[{}] filter [{}]", (Object)path, filter.value());
                }
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 4: {
                FSOperations.FSHomeDir command = new FSOperations.FSHomeDir();
                JSONObject json = (JSONObject)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("");
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 5: {
                if (!((String)path.value()).equals("/")) {
                    throw new UnsupportedOperationException(MessageFormat.format("Invalid path for {0}={1}, must be '/'", "op", HttpFSFileSystem.GetOpValues.INSTRUMENTATION));
                }
                Groups groups = (Groups)HttpFSServerWebApp.get().get(Groups.class);
                List userGroups = groups.getGroups(user.getName());
                if (!userGroups.contains(HttpFSServerWebApp.get().getAdminGroup())) {
                    throw new AccessControlException("User not in HttpFSServer admin group");
                }
                Instrumentation instrumentation = (Instrumentation)HttpFSServerWebApp.get().get(Instrumentation.class);
                Map snapshot = instrumentation.getSnapshot();
                response = Response.ok((Object)snapshot).build();
                break;
            }
            case 6: {
                FSOperations.FSContentSummary command = new FSOperations.FSContentSummary((String)path.value());
                Map json = (Map)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 7: {
                FSOperations.FSFileChecksum command = new FSOperations.FSFileChecksum((String)path.value());
                Map json = (Map)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 8: {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                break;
            }
            case 9: {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return response;
    }

    protected URI createUploadRedirectionURL(UriInfo uriInfo, Enum<?> uploadOperation) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        uriBuilder = uriBuilder.replaceQueryParam("op", new Object[]{uploadOperation}).queryParam("data", new Object[]{Boolean.TRUE});
        return uriBuilder.build(null);
    }

    @DELETE
    @Path(value="{path:.*}")
    @Produces(value={"application/json"})
    public Response delete(@Context Principal user, @PathParam(value="path") HttpFSParams.FsPathParam path, @QueryParam(value="op") HttpFSParams.DeleteOpParam op, @QueryParam(value="recursive") @DefaultValue(value="false") HttpFSParams.DeleteRecursiveParam recursive, @QueryParam(value="doas") @DefaultValue(value="") HttpFSParams.DoAsParam doAs) throws IOException, FileSystemAccessException {
        Response response = null;
        if (op == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Missing [{0}] parameter", "op"));
        }
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$DeleteOpValues[((HttpFSFileSystem.DeleteOpValues)op.value()).ordinal()]) {
            case 1: {
                path.makeAbsolute();
                MDC.put((String)"op", (String)"DELETE");
                AUDIT_LOG.info("[{}] recursive [{}]", (Object)path, (Object)recursive);
                FSOperations.FSDelete command = new FSOperations.FSDelete((String)path.value(), ((Boolean)recursive.value()).booleanValue());
                JSONObject json = (JSONObject)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
        }
        return response;
    }

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response put(InputStream is, @Context Principal user, @Context UriInfo uriInfo, @PathParam(value="path") HttpFSParams.FsPathParam path, @QueryParam(value="op") HttpFSParams.PutOpParam op, @QueryParam(value="destination") @DefaultValue(value="") HttpFSParams.ToPathParam toPath, @QueryParam(value="owner") @DefaultValue(value="") HttpFSParams.OwnerParam owner, @QueryParam(value="group") @DefaultValue(value="") HttpFSParams.GroupParam group, @QueryParam(value="overwrite") @DefaultValue(value="true") HttpFSParams.OverwriteParam override, @QueryParam(value="blocksize") @DefaultValue(value="-1") HttpFSParams.BlockSizeParam blockSize, @QueryParam(value="permission") @DefaultValue(value="default") HttpFSParams.PermissionParam permission, @QueryParam(value="replication") @DefaultValue(value="-1") HttpFSParams.ReplicationParam replication, @QueryParam(value="modificationtime") @DefaultValue(value="-1") HttpFSParams.ModifiedTimeParam modifiedTime, @QueryParam(value="accesstime") @DefaultValue(value="-1") HttpFSParams.AccessTimeParam accessTime, @QueryParam(value="data") @DefaultValue(value="false") HttpFSParams.DataParam hasData, @QueryParam(value="doas") @DefaultValue(value="") HttpFSParams.DoAsParam doAs) throws IOException, FileSystemAccessException {
        Response response = null;
        if (op == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Missing [{0}] parameter", "op"));
        }
        path.makeAbsolute();
        MDC.put((String)"op", (String)((HttpFSFileSystem.PutOpValues)op.value()).name());
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$PutOpValues[((HttpFSFileSystem.PutOpValues)op.value()).ordinal()]) {
            case 1: {
                if (!((Boolean)hasData.value()).booleanValue()) {
                    response = Response.temporaryRedirect((URI)this.createUploadRedirectionURL(uriInfo, (Enum)HttpFSFileSystem.PutOpValues.CREATE)).build();
                    break;
                }
                FSOperations.FSCreate command = new FSOperations.FSCreate(is, (String)path.value(), (String)permission.value(), ((Boolean)override.value()).booleanValue(), ((Short)replication.value()).shortValue(), ((Long)blockSize.value()).longValue());
                this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] permission [{}] override [{}] replication [{}] blockSize [{}]", new Object[]{path, permission, override, replication, blockSize});
                response = Response.status((Response.Status)Response.Status.CREATED).build();
                break;
            }
            case 2: {
                FSOperations.FSMkdirs command = new FSOperations.FSMkdirs((String)path.value(), (String)permission.value());
                JSONObject json = (JSONObject)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] permission [{}]", (Object)path, permission.value());
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 3: {
                FSOperations.FSRename command = new FSOperations.FSRename((String)path.value(), (String)toPath.value());
                JSONObject json = (JSONObject)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, (Object)toPath);
                response = Response.ok((Object)json).type("application/json").build();
                break;
            }
            case 4: {
                FSOperations.FSSetOwner command = new FSOperations.FSSetOwner((String)path.value(), (String)owner.value(), (String)group.value());
                this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to (O/G)[{}]", (Object)path, (Object)((String)owner.value() + ":" + (String)group.value()));
                response = Response.ok().build();
                break;
            }
            case 5: {
                FSOperations.FSSetPermission command = new FSOperations.FSSetPermission((String)path.value(), (String)permission.value());
                this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, permission.value());
                response = Response.ok().build();
                break;
            }
            case 6: {
                FSOperations.FSSetReplication command = new FSOperations.FSSetReplication((String)path.value(), ((Short)replication.value()).shortValue());
                JSONObject json = (JSONObject)this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to [{}]", (Object)path, replication.value());
                response = Response.ok((Object)json).build();
                break;
            }
            case 7: {
                FSOperations.FSSetTimes command = new FSOperations.FSSetTimes((String)path.value(), ((Long)modifiedTime.value()).longValue(), ((Long)accessTime.value()).longValue());
                this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}] to (M/A)[{}]", (Object)path, (Object)(modifiedTime.value() + ":" + accessTime.value()));
                response = Response.ok().build();
                break;
            }
            case 8: {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                break;
            }
            case 9: {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        return response;
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response post(InputStream is, @Context Principal user, @Context UriInfo uriInfo, @PathParam(value="path") HttpFSParams.FsPathParam path, @QueryParam(value="op") HttpFSParams.PostOpParam op, @QueryParam(value="data") @DefaultValue(value="false") HttpFSParams.DataParam hasData, @QueryParam(value="doas") @DefaultValue(value="") HttpFSParams.DoAsParam doAs) throws IOException, FileSystemAccessException {
        Response response = null;
        if (op == null) {
            throw new UnsupportedOperationException(MessageFormat.format("Missing [{0}] parameter", "op"));
        }
        path.makeAbsolute();
        MDC.put((String)"op", (String)((HttpFSFileSystem.PostOpValues)op.value()).name());
        switch (1.$SwitchMap$org$apache$hadoop$fs$http$client$HttpFSFileSystem$PostOpValues[((HttpFSFileSystem.PostOpValues)op.value()).ordinal()]) {
            case 1: {
                if (!((Boolean)hasData.value()).booleanValue()) {
                    response = Response.temporaryRedirect((URI)this.createUploadRedirectionURL(uriInfo, (Enum)HttpFSFileSystem.PostOpValues.APPEND)).build();
                    break;
                }
                FSOperations.FSAppend command = new FSOperations.FSAppend(is, (String)path.value());
                this.fsExecute(user, (String)doAs.value(), (FileSystemAccess.FileSystemExecutor)command);
                AUDIT_LOG.info("[{}]", (Object)path);
                response = Response.ok().type("application/json").build();
            }
        }
        return response;
    }
}

