/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http.client;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.http.client.TestHttpFSFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.test.TestJettyHelper;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestWebhdfsFileSystem
extends TestHttpFSFileSystem {
    public TestWebhdfsFileSystem(TestHttpFSFileSystem.Operation operation) {
        super(operation);
    }

    protected FileSystem getHttpFileSystem() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.webhdfs.impl", WebHdfsFileSystem.class.getName());
        URI uri = new URI("webhdfs://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        return FileSystem.get((URI)uri, (Configuration)conf);
    }

    protected void testGet() throws Exception {
        FileSystem fs = this.getHttpFileSystem();
        Assert.assertNotNull((Object)fs);
        URI uri = new URI("webhdfs://" + TestJettyHelper.getJettyURL().toURI().getAuthority());
        Assert.assertEquals((Object)fs.getUri(), (Object)uri);
        fs.close();
    }
}

