/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileReader {
    private static final ObjectReader READER = new ObjectMapper().readerFor(DatanodeAdminProperties.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    private CombinedHostsFileReader() {
    }

    public static Set<DatanodeAdminProperties> readFile(String hostsFile) throws IOException {
        HashSet<DatanodeAdminProperties> allDNs = new HashSet<DatanodeAdminProperties>();
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(hostsFile), "UTF-8");){
            MappingIterator iterator = READER.readValues(JSON_FACTORY.createParser((Reader)input));
            while (iterator.hasNext()) {
                DatanodeAdminProperties properties = (DatanodeAdminProperties)iterator.next();
                allDNs.add(properties);
            }
        }
        return allDNs;
    }
}

