/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.scm.node;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.SCMNodeManager;
import org.apache.hadoop.hdds.scm.node.SCMNodeMetrics;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSCMNodeMetrics {
    private static SCMNodeManager nodeManager;
    private static DatanodeDetails registeredDatanode;

    @BeforeClass
    public static void setup() throws Exception {
        OzoneConfiguration source = new OzoneConfiguration();
        EventQueue publisher = new EventQueue();
        SCMStorageConfig config = new SCMStorageConfig(HddsProtos.NodeType.DATANODE, new File("/tmp"), "storage");
        nodeManager = new SCMNodeManager(source, config, (EventPublisher)publisher, (NetworkTopology)new NetworkTopologyImpl((ConfigurationSource)source));
        registeredDatanode = DatanodeDetails.newBuilder().setHostName("localhost").setIpAddress("127.0.0.1").setUuid(UUID.randomUUID()).build();
        nodeManager.register(registeredDatanode, TestSCMNodeMetrics.createNodeReport(), StorageContainerDatanodeProtocolProtos.PipelineReportsProto.newBuilder().build());
    }

    @AfterClass
    public static void teardown() throws IOException {
        nodeManager.close();
    }

    @Test
    public void testHBProcessing() throws InterruptedException {
        long hbProcessed = this.getCounter("NumHBProcessed");
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = TestSCMNodeMetrics.createNodeReport();
        nodeManager.processHeartbeat(registeredDatanode);
        Assert.assertEquals((String)"NumHBProcessed", (long)(hbProcessed + 1L), (long)this.getCounter("NumHBProcessed"));
    }

    @Test
    public void testHBProcessingFailure() {
        long hbProcessedFailed = this.getCounter("NumHBProcessingFailed");
        nodeManager.processHeartbeat(MockDatanodeDetails.randomDatanodeDetails());
        Assert.assertEquals((String)"NumHBProcessingFailed", (long)(hbProcessedFailed + 1L), (long)this.getCounter("NumHBProcessingFailed"));
    }

    @Test
    public void testNodeReportProcessing() throws InterruptedException {
        long nrProcessed = this.getCounter("NumNodeReportProcessed");
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageReport = TestUtils.createStorageReport(registeredDatanode.getUuid(), "/tmp", 100L, 10L, 90L, null);
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder().addStorageReport(storageReport).build();
        nodeManager.processNodeReport(registeredDatanode, nodeReport);
        Assert.assertEquals((String)"NumNodeReportProcessed", (long)(nrProcessed + 1L), (long)this.getCounter("NumNodeReportProcessed"));
    }

    @Test
    public void testNodeReportProcessingFailure() {
        long nrProcessed = this.getCounter("NumNodeReportProcessingFailed");
        DatanodeDetails randomDatanode = MockDatanodeDetails.randomDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageReport = TestUtils.createStorageReport(randomDatanode.getUuid(), "/tmp", 100L, 10L, 90L, null);
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder().addStorageReport(storageReport).build();
        nodeManager.processNodeReport(randomDatanode, nodeReport);
        Assert.assertEquals((String)"NumNodeReportProcessingFailed", (long)(nrProcessed + 1L), (long)this.getCounter("NumNodeReportProcessingFailed"));
    }

    @Test
    public void testNodeCountAndInfoMetricsReported() throws Exception {
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageReport = TestUtils.createStorageReport(registeredDatanode.getUuid(), "/tmp", 100L, 10L, 90L, null);
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder().addStorageReport(storageReport).build();
        nodeManager.processNodeReport(registeredDatanode, nodeReport);
        MetricsRecordBuilder metricsSource = MetricsAsserts.getMetrics((String)SCMNodeMetrics.SOURCE_NAME);
        MetricsAsserts.assertGauge((String)"HealthyNodes", (int)1, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"StaleNodes", (int)0, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"DeadNodes", (int)0, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"DecommissioningNodes", (int)0, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"DecommissionedNodes", (int)0, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"DiskCapacity", (long)100L, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"DiskUsed", (long)10L, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"DiskRemaining", (long)90L, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"SSDCapacity", (long)0L, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"SSDUsed", (long)0L, (MetricsRecordBuilder)metricsSource);
        MetricsAsserts.assertGauge((String)"SSDRemaining", (long)0L, (MetricsRecordBuilder)metricsSource);
    }

    private long getCounter(String metricName) {
        return MetricsAsserts.getLongCounter((String)metricName, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)SCMNodeMetrics.SOURCE_NAME));
    }

    private static StorageContainerDatanodeProtocolProtos.NodeReportProto createNodeReport() {
        return StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder().addStorageReport(StorageContainerDatanodeProtocolProtos.StorageReportProto.newBuilder().setCapacity(1L).setStorageUuid(UUID.randomUUID().toString()).setStorageLocation("/tmp").build()).build();
    }
}

