/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.placement;

import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeMetrics {
    @Test
    public void testSCMNodeMetric() {
        SCMNodeStat stat = new SCMNodeStat(100L, 10L, 90L);
        Assert.assertEquals((long)stat.getCapacity().get(), (long)100L);
        Assert.assertEquals((long)10L, (long)stat.getScmUsed().get());
        Assert.assertEquals((long)90L, (long)stat.getRemaining().get());
        SCMNodeMetric metric = new SCMNodeMetric(stat);
        SCMNodeStat newStat = new SCMNodeStat(100L, 10L, 90L);
        Assert.assertEquals((long)100L, (long)stat.getCapacity().get());
        Assert.assertEquals((long)10L, (long)stat.getScmUsed().get());
        Assert.assertEquals((long)90L, (long)stat.getRemaining().get());
        SCMNodeMetric newMetric = new SCMNodeMetric(newStat);
        Assert.assertTrue((boolean)metric.isEqual(newMetric.get()));
        newMetric.add(stat);
        Assert.assertTrue((boolean)newMetric.isGreater(metric.get()));
        SCMNodeMetric zeroMetric = new SCMNodeMetric(new SCMNodeStat());
        Assert.assertTrue((boolean)metric.isGreater(zeroMetric.get()));
    }
}

