/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.placement;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementCapacity;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementRandom;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.junit.Assert;
import org.junit.Test;

public class TestContainerPlacement {
    private DescriptiveStatistics computeStatistics(NodeManager nodeManager) {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics();
        for (DatanodeDetails dd : nodeManager.getNodes(HddsProtos.NodeState.HEALTHY)) {
            float weightedValue = (float)nodeManager.getNodeStat(dd).get().getScmUsed().get().longValue() / (float)nodeManager.getNodeStat(dd).get().getCapacity().get().longValue();
            descriptiveStatistics.addValue((double)weightedValue);
        }
        return descriptiveStatistics;
    }

    @Test
    public void testCapacityPlacementYieldsBetterDataDistribution() throws SCMException {
        int opsCount = 200000;
        int nodesRequired = 3;
        Random random = new Random();
        MockNodeManager nodeManagerCapacity = new MockNodeManager(true, 100);
        MockNodeManager nodeManagerRandom = new MockNodeManager(true, 100);
        DescriptiveStatistics beforeCapacity = this.computeStatistics(nodeManagerCapacity);
        DescriptiveStatistics beforeRandom = this.computeStatistics(nodeManagerRandom);
        Assert.assertEquals((double)beforeCapacity.getStandardDeviation(), (double)beforeRandom.getStandardDeviation(), (double)0.001);
        SCMContainerPlacementCapacity capacityPlacer = new SCMContainerPlacementCapacity((NodeManager)nodeManagerCapacity, (ConfigurationSource)new OzoneConfiguration(), null, true, null);
        SCMContainerPlacementRandom randomPlacer = new SCMContainerPlacementRandom((NodeManager)nodeManagerRandom, (ConfigurationSource)new OzoneConfiguration(), null, true, null);
        for (int x = 0; x < 200000; ++x) {
            long containerSize = (long)random.nextInt(100) * 0x40000000L;
            List nodesCapacity = capacityPlacer.chooseDatanodes(new ArrayList(), null, 3, containerSize);
            Assert.assertEquals((long)3L, (long)nodesCapacity.size());
            List nodesRandom = randomPlacer.chooseDatanodes(nodesCapacity, null, 3, containerSize);
            if (x % 5 == 0) {
                this.deleteContainer(nodeManagerCapacity, nodesCapacity, containerSize);
                this.deleteContainer(nodeManagerRandom, nodesRandom, containerSize);
                continue;
            }
            this.createContainer(nodeManagerCapacity, nodesCapacity, containerSize);
            this.createContainer(nodeManagerRandom, nodesRandom, containerSize);
        }
        DescriptiveStatistics postCapacity = this.computeStatistics(nodeManagerCapacity);
        DescriptiveStatistics postRandom = this.computeStatistics(nodeManagerRandom);
        Assert.assertTrue((beforeCapacity.getStandardDeviation() > postCapacity.getStandardDeviation() ? 1 : 0) != 0);
        Assert.assertTrue((postRandom.getStandardDeviation() > postCapacity.getStandardDeviation() ? 1 : 0) != 0);
    }

    private void deleteContainer(MockNodeManager nodeManager, List<DatanodeDetails> nodes, long containerSize) {
        for (DatanodeDetails dd : nodes) {
            nodeManager.delContainer(dd, containerSize);
        }
    }

    private void createContainer(MockNodeManager nodeManager, List<DatanodeDetails> nodes, long containerSize) {
        for (DatanodeDetails dd : nodes) {
            nodeManager.addContainer(dd, containerSize);
        }
    }
}

