/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.VersionInfo;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ozone.container.common.ContainerTestUtils;
import org.apache.hadoop.ozone.container.common.SCMTestUtils;
import org.apache.hadoop.ozone.container.common.ScmTestMock;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.states.endpoint.RegisterEndpointTask;
import org.apache.hadoop.ozone.container.common.states.endpoint.VersionEndpointTask;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.StorageContainerDatanodeProtocol;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.util.Time;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;

public class TestEndPoint {
    private static InetSocketAddress serverAddress;
    private static RPC.Server scmServer;
    private static ScmTestMock scmServerImpl;
    private static File testDir;
    private static OzoneConfiguration config;

    @AfterClass
    public static void tearDown() throws Exception {
        if (scmServer != null) {
            scmServer.stop();
        }
        FileUtil.fullyDelete((File)testDir);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        serverAddress = SCMTestUtils.getReuseableAddress();
        scmServerImpl = new ScmTestMock();
        scmServer = SCMTestUtils.startScmRpcServer((ConfigurationSource)SCMTestUtils.getConf(), (StorageContainerDatanodeProtocol)scmServerImpl, (InetSocketAddress)serverAddress, (int)10);
        testDir = PathUtils.getTestDir(TestEndPoint.class);
        config = SCMTestUtils.getConf();
        config.set("dfs.datanode.data.dir", testDir.getAbsolutePath());
        config.set("ozone.metadata.dirs", testDir.getAbsolutePath());
        config.setBoolean("dfs.container.ratis.ipc.random.port", true);
        config.set("hdds.command.status.report.interval", "1s");
    }

    @Test
    public void testGetVersion() throws Exception {
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)SCMTestUtils.getConf(), (InetSocketAddress)serverAddress, (int)1000);){
            StorageContainerDatanodeProtocolProtos.SCMVersionResponseProto responseProto = rpcEndPoint.getEndPoint().getVersion(null);
            Assert.assertNotNull((Object)responseProto);
            Assert.assertEquals((Object)"Description", (Object)responseProto.getKeys(0).getKey());
            Assert.assertEquals((Object)VersionInfo.getLatestVersion().getDescription(), (Object)responseProto.getKeys(0).getValue());
        }
    }

    @Test
    public void testGetVersionTask() throws Exception {
        OzoneConfiguration conf = SCMTestUtils.getConf();
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)conf, (InetSocketAddress)serverAddress, (int)1000);){
            DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
            OzoneContainer ozoneContainer = new OzoneContainer(datanodeDetails, (ConfigurationSource)conf, this.getContext(datanodeDetails), null);
            rpcEndPoint.setState(EndpointStateMachine.EndPointStates.GETVERSION);
            VersionEndpointTask versionTask = new VersionEndpointTask(rpcEndPoint, (ConfigurationSource)conf, ozoneContainer);
            EndpointStateMachine.EndPointStates newState = versionTask.call();
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.REGISTER, (Object)newState);
            Assert.assertNotNull((Object)rpcEndPoint.getVersion());
        }
    }

    @Test
    public void testCheckVersionResponse() throws Exception {
        OzoneConfiguration conf = SCMTestUtils.getConf();
        conf.setBoolean("dfs.container.ipc.random.port", true);
        conf.setBoolean("dfs.container.ratis.ipc.random.port", true);
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)conf, (InetSocketAddress)serverAddress, (int)1000);){
            GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)VersionEndpointTask.LOG);
            DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
            OzoneContainer ozoneContainer = new OzoneContainer(datanodeDetails, (ConfigurationSource)conf, this.getContext(datanodeDetails), null);
            rpcEndPoint.setState(EndpointStateMachine.EndPointStates.GETVERSION);
            VersionEndpointTask versionTask = new VersionEndpointTask(rpcEndPoint, (ConfigurationSource)conf, ozoneContainer);
            EndpointStateMachine.EndPointStates newState = versionTask.call();
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.REGISTER, (Object)newState);
            Assert.assertNotNull((Object)rpcEndPoint.getVersion());
            String newScmId = UUID.randomUUID().toString();
            scmServerImpl.setScmId(newScmId);
            rpcEndPoint.setState(EndpointStateMachine.EndPointStates.GETVERSION);
            newState = versionTask.call();
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.SHUTDOWN, (Object)newState);
            List volumesList = ozoneContainer.getVolumeSet().getFailedVolumesList();
            Assert.assertTrue((volumesList.size() == 1 ? 1 : 0) != 0);
            File expectedScmDir = new File(((HddsVolume)volumesList.get(0)).getHddsRootDir(), scmServerImpl.getScmId());
            Assert.assertTrue((boolean)logCapturer.getOutput().contains("expected scm directory " + expectedScmDir.getAbsolutePath() + " does not exist"));
            Assert.assertTrue((ozoneContainer.getVolumeSet().getVolumesList().size() == 0 ? 1 : 0) != 0);
            Assert.assertTrue((ozoneContainer.getVolumeSet().getFailedVolumesList().size() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetVersionToInvalidEndpoint() throws Exception {
        OzoneConfiguration conf = SCMTestUtils.getConf();
        InetSocketAddress nonExistentServerAddress = SCMTestUtils.getReuseableAddress();
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)conf, (InetSocketAddress)nonExistentServerAddress, (int)1000);){
            rpcEndPoint.setState(EndpointStateMachine.EndPointStates.GETVERSION);
            DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
            OzoneContainer ozoneContainer = new OzoneContainer(datanodeDetails, (ConfigurationSource)conf, this.getContext(datanodeDetails), null);
            VersionEndpointTask versionTask = new VersionEndpointTask(rpcEndPoint, (ConfigurationSource)conf, ozoneContainer);
            EndpointStateMachine.EndPointStates newState = versionTask.call();
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.GETVERSION, (Object)newState);
        }
    }

    @Test
    public void testGetVersionAssertRpcTimeOut() throws Exception {
        long rpcTimeout = 1000L;
        long tolerance = 100L;
        OzoneConfiguration conf = SCMTestUtils.getConf();
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)conf, (InetSocketAddress)serverAddress, (int)1000);){
            rpcEndPoint.setState(EndpointStateMachine.EndPointStates.GETVERSION);
            DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
            OzoneContainer ozoneContainer = new OzoneContainer(datanodeDetails, (ConfigurationSource)conf, this.getContext(datanodeDetails), null);
            VersionEndpointTask versionTask = new VersionEndpointTask(rpcEndPoint, (ConfigurationSource)conf, ozoneContainer);
            scmServerImpl.setRpcResponseDelay(1500);
            long start = Time.monotonicNow();
            EndpointStateMachine.EndPointStates newState = versionTask.call();
            long end = Time.monotonicNow();
            scmServerImpl.setRpcResponseDelay(0);
            Assert.assertThat((Object)(end - start), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1100L)));
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.GETVERSION, (Object)newState);
        }
    }

    @Test
    public void testRegister() throws Exception {
        DatanodeDetails nodeToRegister = MockDatanodeDetails.randomDatanodeDetails();
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)SCMTestUtils.getConf(), (InetSocketAddress)serverAddress, (int)1000);){
            StorageContainerDatanodeProtocolProtos.SCMRegisteredResponseProto responseProto = rpcEndPoint.getEndPoint().register(nodeToRegister.getProtoBufMessage(), TestUtils.createNodeReport(this.getStorageReports(nodeToRegister.getUuid())), TestUtils.getRandomContainerReports(10), TestUtils.getRandomPipelineReports());
            Assert.assertNotNull((Object)responseProto);
            Assert.assertEquals((Object)nodeToRegister.getUuidString(), (Object)responseProto.getDatanodeUUID());
            Assert.assertNotNull((Object)responseProto.getClusterID());
            Assert.assertEquals((long)10L, (long)scmServerImpl.getContainerCountsForDatanode(nodeToRegister));
            Assert.assertEquals((long)1L, (long)scmServerImpl.getNodeReportsCount(nodeToRegister));
        }
    }

    private StorageContainerDatanodeProtocolProtos.StorageReportProto getStorageReports(UUID id) {
        String storagePath = testDir.getAbsolutePath() + "/" + id;
        return TestUtils.createStorageReport(id, storagePath, 100L, 10L, 90L, null);
    }

    private EndpointStateMachine registerTaskHelper(InetSocketAddress scmAddress, int rpcTimeout, boolean clearDatanodeDetails) throws Exception {
        OzoneConfiguration conf = SCMTestUtils.getConf();
        EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)conf, (InetSocketAddress)scmAddress, (int)rpcTimeout);
        rpcEndPoint.setState(EndpointStateMachine.EndPointStates.REGISTER);
        OzoneContainer ozoneContainer = (OzoneContainer)Mockito.mock(OzoneContainer.class);
        Mockito.when((Object)ozoneContainer.getNodeReport()).thenReturn((Object)TestUtils.createNodeReport(this.getStorageReports(UUID.randomUUID())));
        ContainerController controller = (ContainerController)Mockito.mock(ContainerController.class);
        Mockito.when((Object)controller.getContainerReport()).thenReturn((Object)TestUtils.getRandomContainerReports(10));
        Mockito.when((Object)ozoneContainer.getController()).thenReturn((Object)controller);
        Mockito.when((Object)ozoneContainer.getPipelineReport()).thenReturn((Object)TestUtils.getRandomPipelineReports());
        RegisterEndpointTask endpointTask = new RegisterEndpointTask(rpcEndPoint, (ConfigurationSource)conf, ozoneContainer, (StateContext)Mockito.mock(StateContext.class));
        if (!clearDatanodeDetails) {
            DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
            endpointTask.setDatanodeDetails(datanodeDetails);
        }
        endpointTask.call();
        return rpcEndPoint;
    }

    @Test
    public void testRegisterTask() throws Exception {
        try (EndpointStateMachine rpcEndpoint = this.registerTaskHelper(serverAddress, 1000, false);){
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.HEARTBEAT, (Object)rpcEndpoint.getState());
        }
    }

    @Test
    public void testRegisterToInvalidEndpoint() throws Exception {
        InetSocketAddress address = SCMTestUtils.getReuseableAddress();
        try (EndpointStateMachine rpcEndpoint = this.registerTaskHelper(address, 1000, false);){
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.REGISTER, (Object)rpcEndpoint.getState());
        }
    }

    @Test
    public void testRegisterNoContainerID() throws Exception {
        InetSocketAddress address = SCMTestUtils.getReuseableAddress();
        try (EndpointStateMachine rpcEndpoint = this.registerTaskHelper(address, 1000, true);){
            Assert.assertEquals((Object)EndpointStateMachine.EndPointStates.SHUTDOWN, (Object)rpcEndpoint.getState());
        }
    }

    @Test
    public void testRegisterRpcTimeout() throws Exception {
        long rpcTimeout = 1000L;
        long tolerance = 200L;
        scmServerImpl.setRpcResponseDelay(1500);
        long start = Time.monotonicNow();
        this.registerTaskHelper(serverAddress, 1000, false).close();
        long end = Time.monotonicNow();
        scmServerImpl.setRpcResponseDelay(0);
        Assert.assertThat((Object)(end - start), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1200L)));
    }

    @Test
    public void testHeartbeat() throws Exception {
        DatanodeDetails dataNode = MockDatanodeDetails.randomDatanodeDetails();
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)SCMTestUtils.getConf(), (InetSocketAddress)serverAddress, (int)1000);){
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto request = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(dataNode.getProtoBufMessage()).setNodeReport(TestUtils.createNodeReport(this.getStorageReports(UUID.randomUUID()))).build();
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto responseProto = rpcEndPoint.getEndPoint().sendHeartbeat(request);
            Assert.assertNotNull((Object)responseProto);
            Assert.assertEquals((long)0L, (long)responseProto.getCommandsCount());
        }
    }

    @Test
    public void testHeartbeatWithCommandStatusReport() throws Exception {
        DatanodeDetails dataNode = MockDatanodeDetails.randomDatanodeDetails();
        try (EndpointStateMachine rpcEndPoint = ContainerTestUtils.createEndpoint((Configuration)SCMTestUtils.getConf(), (InetSocketAddress)serverAddress, (int)1000);){
            this.addScmCommands();
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto request = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(dataNode.getProtoBufMessage()).setNodeReport(TestUtils.createNodeReport(this.getStorageReports(UUID.randomUUID()))).build();
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto responseProto = rpcEndPoint.getEndPoint().sendHeartbeat(request);
            Assert.assertNotNull((Object)responseProto);
            Assert.assertEquals((long)3L, (long)responseProto.getCommandsCount());
            Assert.assertEquals((long)0L, (long)scmServerImpl.getCommandStatusReportCount());
            StateContext stateContext = this.heartbeatTaskHelper(serverAddress, 3000);
            Map map = stateContext.getCommandStatusMap();
            Assert.assertNotNull((Object)map);
            Assert.assertEquals((String)"Should have 1 objects", (long)1L, (long)map.size());
            Assert.assertTrue((boolean)map.containsKey(3L));
            Assert.assertEquals((Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand, (Object)((CommandStatus)map.get(3L)).getType());
            Assert.assertEquals((Object)StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING, (Object)((CommandStatus)map.get(3L)).getStatus());
            scmServerImpl.clearScmCommandRequests();
        }
    }

    private void addScmCommands() {
        StorageContainerDatanodeProtocolProtos.SCMCommandProto closeCommand = StorageContainerDatanodeProtocolProtos.SCMCommandProto.newBuilder().setCloseContainerCommandProto(StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto.newBuilder().setCmdId(1L).setContainerID(1L).setPipelineID(PipelineID.randomId().getProtobuf()).build()).setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand).build();
        StorageContainerDatanodeProtocolProtos.SCMCommandProto replicationCommand = StorageContainerDatanodeProtocolProtos.SCMCommandProto.newBuilder().setReplicateContainerCommandProto(StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto.newBuilder().setCmdId(2L).setContainerID(2L).build()).setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand).build();
        StorageContainerDatanodeProtocolProtos.SCMCommandProto deleteBlockCommand = StorageContainerDatanodeProtocolProtos.SCMCommandProto.newBuilder().setDeleteBlocksCommandProto(StorageContainerDatanodeProtocolProtos.DeleteBlocksCommandProto.newBuilder().setCmdId(3L).addDeletedBlocksTransactions(StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction.newBuilder().setContainerID(45L).setCount(1).setTxID(23L).build()).build()).setCommandType(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand).build();
        scmServerImpl.addScmCommandRequest(closeCommand);
        scmServerImpl.addScmCommandRequest(deleteBlockCommand);
        scmServerImpl.addScmCommandRequest(replicationCommand);
    }

    /*
     * Exception decompiling
     */
    private StateContext heartbeatTaskHelper(InetSocketAddress scmAddress, int rpcTimeout) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testHeartbeatTask() throws Exception {
        this.heartbeatTaskHelper(serverAddress, 1000);
    }

    @Test
    public void testHeartbeatTaskToInvalidNode() throws Exception {
        InetSocketAddress invalidAddress = SCMTestUtils.getReuseableAddress();
        this.heartbeatTaskHelper(invalidAddress, 1000);
    }

    @Test
    public void testHeartbeatTaskRpcTimeOut() throws Exception {
        long rpcTimeout = 1000L;
        long tolerance = 200L;
        scmServerImpl.setRpcResponseDelay(1500);
        long start = Time.monotonicNow();
        InetSocketAddress invalidAddress = SCMTestUtils.getReuseableAddress();
        this.heartbeatTaskHelper(invalidAddress, 1000);
        long end = Time.monotonicNow();
        scmServerImpl.setRpcResponseDelay(0);
        Assert.assertThat((Object)(end - start), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1200L)));
    }

    private StateContext getContext(DatanodeDetails datanodeDetails) {
        DatanodeStateMachine stateMachine = (DatanodeStateMachine)Mockito.mock(DatanodeStateMachine.class);
        StateContext context = (StateContext)Mockito.mock(StateContext.class);
        Mockito.when((Object)stateMachine.getDatanodeDetails()).thenReturn((Object)datanodeDetails);
        Mockito.when((Object)context.getParent()).thenReturn((Object)stateMachine);
        return context;
    }
}

