/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.server.SCMStarterInterface;
import org.apache.hadoop.hdds.scm.server.StorageContainerManagerStarter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStorageContainerManagerStarter {
    private final ByteArrayOutputStream outContent = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private final PrintStream originalOut = System.out;
    private final PrintStream originalErr = System.err;
    private MockSCMStarter mock;

    @Before
    public void setUpStreams() {
        System.setOut(new PrintStream(this.outContent));
        System.setErr(new PrintStream(this.errContent));
        this.mock = new MockSCMStarter();
    }

    @After
    public void restoreStreams() {
        System.setOut(this.originalOut);
        System.setErr(this.originalErr);
    }

    @Test
    public void testCallsStartWhenServerStarted() throws Exception {
        this.executeCommand(new String[0]);
        Assert.assertTrue((boolean)this.mock.startCalled);
    }

    @Test
    public void testExceptionThrownWhenStartFails() throws Exception {
        this.mock.throwOnStart = true;
        try {
            this.executeCommand(new String[0]);
            Assert.fail((String)"Exception show have been thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testStartNotCalledWithInvalidParam() throws Exception {
        this.executeCommand("--invalid");
        Assert.assertFalse((boolean)this.mock.startCalled);
    }

    @Test
    public void testPassingInitSwitchCallsInit() {
        this.executeCommand("--init");
        Assert.assertTrue((boolean)this.mock.initCalled);
    }

    @Test
    public void testInitSwitchAcceptsClusterIdSSwitch() {
        this.executeCommand("--init", "--clusterid=abcdefg");
        Assert.assertEquals((Object)"abcdefg", (Object)this.mock.clusterId);
    }

    @Test
    public void testInitSwitchWithInvalidParamDoesNotRun() {
        this.executeCommand("--init", "--clusterid=abcdefg", "--invalid");
        Assert.assertFalse((boolean)this.mock.initCalled);
    }

    @Test
    public void testUnSuccessfulInitThrowsException() {
        this.mock.throwOnInit = true;
        try {
            this.executeCommand("--init");
            Assert.fail((String)"Exception show have been thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGenClusterIdRunsGenerate() {
        this.executeCommand("--genclusterid");
        Assert.assertTrue((boolean)this.mock.generateCalled);
    }

    @Test
    public void testGenClusterIdWithInvalidParamDoesNotRun() {
        this.executeCommand("--genclusterid", "--invalid");
        Assert.assertFalse((boolean)this.mock.generateCalled);
    }

    @Test
    public void testUsagePrintedOnInvalidInput() {
        this.executeCommand("--invalid");
        Pattern p = Pattern.compile("^Unknown option:.*--invalid.*\nUsage");
        Matcher m = p.matcher(this.errContent.toString());
        Assert.assertTrue((boolean)m.find());
    }

    private void executeCommand(String ... args) {
        new StorageContainerManagerStarter((SCMStarterInterface)this.mock).execute(args);
    }

    static class MockSCMStarter
    implements SCMStarterInterface {
        private boolean initStatus = true;
        private boolean throwOnStart = false;
        private boolean throwOnInit = false;
        private boolean startCalled = false;
        private boolean initCalled = false;
        private boolean generateCalled = false;
        private String clusterId = null;

        MockSCMStarter() {
        }

        public void start(OzoneConfiguration conf) throws Exception {
            if (this.throwOnStart) {
                throw new Exception("Simulated error on start");
            }
            this.startCalled = true;
        }

        public boolean init(OzoneConfiguration conf, String cid) throws IOException {
            if (this.throwOnInit) {
                throw new IOException("Simulated error on init");
            }
            this.initCalled = true;
            this.clusterId = cid;
            return this.initStatus;
        }

        public String generateClusterId() {
            this.generateCalled = true;
            return "static-cluster-id";
        }
    }
}

