/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.protocol.commands.ReregisterCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSCMDatanodeHeartbeatDispatcher {
    @Test
    public void testNodeReportDispatcher() throws IOException {
        final AtomicInteger eventReceived = new AtomicInteger();
        final StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReport = StorageContainerDatanodeProtocolProtos.NodeReportProto.getDefaultInstance();
        NodeManager mockNodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)mockNodeManager.isNodeRegistered((DatanodeDetails)Mockito.any())).thenReturn((Object)true);
        SCMDatanodeHeartbeatDispatcher dispatcher = new SCMDatanodeHeartbeatDispatcher(mockNodeManager, new EventPublisher(){

            public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void fireEvent(EVENT_TYPE event, PAYLOAD payload) {
                Assert.assertEquals(event, (Object)SCMEvents.NODE_REPORT);
                eventReceived.incrementAndGet();
                Assert.assertEquals((Object)nodeReport, (Object)((SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode)payload).getReport());
            }
        });
        DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(datanodeDetails.getProtoBufMessage()).setNodeReport(nodeReport).build();
        dispatcher.dispatch(heartbeat);
        Assert.assertEquals((long)1L, (long)eventReceived.get());
    }

    @Test
    public void testContainerReportDispatcher() throws IOException {
        final AtomicInteger eventReceived = new AtomicInteger();
        final StorageContainerDatanodeProtocolProtos.ContainerReportsProto containerReport = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.getDefaultInstance();
        final StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto commandStatusReport = StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.getDefaultInstance();
        NodeManager mockNodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        Mockito.when((Object)mockNodeManager.isNodeRegistered((DatanodeDetails)Mockito.any())).thenReturn((Object)true);
        SCMDatanodeHeartbeatDispatcher dispatcher = new SCMDatanodeHeartbeatDispatcher(mockNodeManager, new EventPublisher(){

            public <PAYLOAD, EVENT_TYPE extends Event<PAYLOAD>> void fireEvent(EVENT_TYPE event, PAYLOAD payload) {
                Assert.assertTrue((event.equals(SCMEvents.CONTAINER_REPORT) || event.equals(SCMEvents.CMD_STATUS_REPORT) ? 1 : 0) != 0);
                if (payload instanceof SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode) {
                    Assert.assertEquals((Object)containerReport, (Object)((SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode)payload).getReport());
                }
                if (payload instanceof SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode) {
                    Assert.assertEquals((Object)commandStatusReport, (Object)((SCMDatanodeHeartbeatDispatcher.CommandStatusReportFromDatanode)payload).getReport());
                }
                eventReceived.incrementAndGet();
            }
        });
        DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(datanodeDetails.getProtoBufMessage()).setContainerReport(containerReport).addCommandStatusReports(commandStatusReport).build();
        dispatcher.dispatch(heartbeat);
        Assert.assertEquals((long)2L, (long)eventReceived.get());
    }

    @Test
    public void testScmHeartbeatAfterRestart() throws Exception {
        NodeManager mockNodeManager = (NodeManager)Mockito.mock(NodeManager.class);
        SCMDatanodeHeartbeatDispatcher dispatcher = new SCMDatanodeHeartbeatDispatcher(mockNodeManager, (EventPublisher)Mockito.mock(EventPublisher.class));
        DatanodeDetails datanodeDetails = MockDatanodeDetails.randomDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(datanodeDetails.getProtoBufMessage()).build();
        dispatcher.dispatch(heartbeat);
        ((NodeManager)Mockito.verify((Object)mockNodeManager, (VerificationMode)Mockito.times((int)1))).addDatanodeCommand((UUID)Mockito.any(UUID.class), (SCMCommand)Mockito.any(ReregisterCommand.class));
    }
}

