/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.util.HashMap;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.server.SCMContainerMetrics;
import org.apache.hadoop.hdds.scm.server.SCMMXBean;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSCMContainerMetrics {
    @Test
    public void testSCMContainerMetrics() {
        SCMMXBean scmmxBean = (SCMMXBean)Mockito.mock(SCMMXBean.class);
        HashMap<String, Integer> stateInfo = new HashMap<String, Integer>(){
            {
                this.put(HddsProtos.LifeCycleState.OPEN.toString(), 2);
                this.put(HddsProtos.LifeCycleState.CLOSING.toString(), 3);
                this.put(HddsProtos.LifeCycleState.QUASI_CLOSED.toString(), 4);
                this.put(HddsProtos.LifeCycleState.CLOSED.toString(), 5);
                this.put(HddsProtos.LifeCycleState.DELETING.toString(), 6);
                this.put(HddsProtos.LifeCycleState.DELETED.toString(), 7);
            }
        };
        Mockito.when((Object)scmmxBean.getContainerStateCount()).thenReturn((Object)stateInfo);
        MetricsRecordBuilder mb = (MetricsRecordBuilder)Mockito.mock(MetricsRecordBuilder.class);
        Mockito.when((Object)mb.addGauge((MetricsInfo)Matchers.any(MetricsInfo.class), Matchers.anyInt())).thenReturn((Object)mb);
        MetricsCollector metricsCollector = (MetricsCollector)Mockito.mock(MetricsCollector.class);
        Mockito.when((Object)metricsCollector.addRecord(Matchers.anyString())).thenReturn((Object)mb);
        SCMContainerMetrics containerMetrics = new SCMContainerMetrics(scmmxBean);
        containerMetrics.getMetrics(metricsCollector, true);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)1))).addGauge(Interns.info((String)"OpenContainers", (String)"Number of open containers"), 2);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)1))).addGauge(Interns.info((String)"ClosingContainers", (String)"Number of containers in closing state"), 3);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)1))).addGauge(Interns.info((String)"QuasiClosedContainers", (String)"Number of containers in quasi closed state"), 4);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)1))).addGauge(Interns.info((String)"ClosedContainers", (String)"Number of containers in closed state"), 5);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)1))).addGauge(Interns.info((String)"DeletingContainers", (String)"Number of containers in deleting state"), 6);
        ((MetricsRecordBuilder)Mockito.verify((Object)mb, (VerificationMode)Mockito.times((int)1))).addGauge(Interns.info((String)"DeletedContainers", (String)"Number of containers in deleted state"), 7);
    }
}

