/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.ScmBlockLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.server.SCMBlockProtocolServer;
import org.apache.hadoop.hdds.scm.server.SCMConfigurator;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSCMBlockProtocolServer {
    private OzoneConfiguration config;
    private SCMBlockProtocolServer server;
    private StorageContainerManager scm;
    private NodeManager nodeManager;
    private ScmBlockLocationProtocolServerSideTranslatorPB service;
    private final int nodeCount = 10;

    @Before
    public void setUp() throws Exception {
        this.config = new OzoneConfiguration();
        File dir = GenericTestUtils.getRandomizedTestDir();
        this.config.set("ozone.metadata.dirs", dir.toString());
        SCMConfigurator configurator = new SCMConfigurator();
        this.scm = TestUtils.getScm(this.config, configurator);
        this.scm.start();
        this.scm.exitSafeMode();
        this.nodeManager = this.scm.getScmNodeManager();
        for (int i = 0; i < 10; ++i) {
            this.nodeManager.register(MockDatanodeDetails.randomDatanodeDetails(), null, null);
        }
        this.server = this.scm.getBlockProtocolServer();
        this.service = new ScmBlockLocationProtocolServerSideTranslatorPB((ScmBlockLocationProtocol)this.server, (ProtocolMessageMetrics)Mockito.mock(ProtocolMessageMetrics.class));
    }

    @After
    public void tearDown() throws Exception {
        if (this.scm != null) {
            this.scm.stop();
            this.scm.join();
        }
    }

    @Test
    public void testSortDatanodes() throws Exception {
        ArrayList<String> nodes = new ArrayList<String>();
        this.nodeManager.getAllNodes().stream().forEach(node -> nodes.add(node.getNetworkName()));
        String client = (String)nodes.get(0);
        List datanodeDetails = this.server.sortDatanodes(nodes, client);
        System.out.println("client = " + client);
        datanodeDetails.stream().forEach(node -> System.out.println(node.toString()));
        Assert.assertTrue((datanodeDetails.size() == 10 ? 1 : 0) != 0);
        client = client + "X";
        datanodeDetails = this.server.sortDatanodes(nodes, client);
        System.out.println("client = " + client);
        datanodeDetails.stream().forEach(node -> System.out.println(node.toString()));
        Assert.assertTrue((datanodeDetails.size() == 10 ? 1 : 0) != 0);
        client = "/default-rack";
        datanodeDetails = this.server.sortDatanodes(nodes, client);
        System.out.println("client = " + client);
        datanodeDetails.stream().forEach(node -> System.out.println(node.toString()));
        Assert.assertTrue((datanodeDetails.size() == 10 ? 1 : 0) != 0);
        nodes.add(UUID.randomUUID().toString());
        ScmBlockLocationProtocolProtos.SortDatanodesRequestProto request = ScmBlockLocationProtocolProtos.SortDatanodesRequestProto.newBuilder().addAllNodeNetworkName(nodes).setClient(client).build();
        ScmBlockLocationProtocolProtos.SortDatanodesResponseProto resp = this.service.sortDatanodes(request);
        Assert.assertTrue((resp.getNodeList().size() == 10 ? 1 : 0) != 0);
        System.out.println("client = " + client);
        resp.getNodeList().stream().forEach(node -> System.out.println(node.getNetworkName()));
        nodes.clear();
        nodes.add(UUID.randomUUID().toString());
        nodes.add(UUID.randomUUID().toString());
        nodes.add(UUID.randomUUID().toString());
        request = ScmBlockLocationProtocolProtos.SortDatanodesRequestProto.newBuilder().addAllNodeNetworkName(nodes).setClient(client).build();
        resp = this.service.sortDatanodes(request);
        System.out.println("client = " + client);
        Assert.assertTrue((resp.getNodeList().size() == 0 ? 1 : 0) != 0);
        resp.getNodeList().stream().forEach(node -> System.out.println(node.getNetworkName()));
    }
}

