/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestSCMSafeModeManager {
    private static EventQueue queue;
    private SCMSafeModeManager scmSafeModeManager;
    private static OzoneConfiguration config;
    private List<ContainerInfo> containers = Collections.emptyList();
    @Rule
    public Timeout timeout = new Timeout(300000);
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();
    private SCMMetadataStore scmMetadataStore;

    @Before
    public void setUp() {
        queue = new EventQueue();
        config = new OzoneConfiguration();
        config.setBoolean("hdds.scm.safemode.pipeline.creation", false);
    }

    @Before
    public void initDbStore() throws IOException {
        config.set("ozone.metadata.dirs", this.tempDir.newFolder().getAbsolutePath());
        this.scmMetadataStore = new SCMMetadataStoreImpl(config);
    }

    @After
    public void destroyDbStore() throws Exception {
        if (this.scmMetadataStore.getStore() != null) {
            this.scmMetadataStore.getStore().close();
        }
    }

    @Test
    public void testSafeModeState() throws Exception {
        this.testSafeMode(0);
        this.testSafeMode(20);
    }

    @Test
    public void testSafeModeStateWithNullContainers() {
        new SCMSafeModeManager((ConfigurationSource)config, Collections.emptyList(), null, queue);
    }

    private void testSafeMode(int numContainers) throws Exception {
        this.containers = new ArrayList<ContainerInfo>();
        this.containers.addAll(HddsTestUtils.getContainerInfo(numContainers));
        for (ContainerInfo container : this.containers) {
            container.setState(HddsProtos.LifeCycleState.CLOSED);
        }
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, this.containers, null, queue);
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(this.containers));
        long cutOff = (long)Math.ceil((double)numContainers * config.getDouble("hdds.scm.safemode.threshold.pct", 0.99));
        Assert.assertEquals((long)cutOff, (long)this.scmSafeModeManager.getSafeModeMetrics().getNumContainerWithOneReplicaReportedThreshold().value());
        GenericTestUtils.waitFor(() -> !this.scmSafeModeManager.getInSafeMode(), (int)100, (int)5000);
        Assert.assertEquals((long)cutOff, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentContainersWithOneReplicaReportedCount().value());
    }

    @Test
    public void testDelayedEventNotification() throws Exception {
        ArrayList delayedSafeModeEvents = new ArrayList();
        ArrayList safeModeEvents = new ArrayList();
        EventQueue eventQueue = new EventQueue();
        eventQueue.addHandler((Event)SCMEvents.SAFE_MODE_STATUS, (safeModeStatus, publisher) -> safeModeEvents.add(safeModeStatus));
        eventQueue.addHandler((Event)SCMEvents.DELAYED_SAFE_MODE_STATUS, (safeModeStatus, publisher) -> delayedSafeModeEvents.add(safeModeStatus));
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.setTimeDuration("hdds.scm.wait.time.after.safemode.exit", 3L, TimeUnit.SECONDS);
        ozoneConfiguration.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)ozoneConfiguration, this.containers, null, eventQueue);
        this.scmSafeModeManager.setInSafeMode(true);
        this.scmSafeModeManager.setPreCheckComplete(true);
        this.scmSafeModeManager.emitSafeModeStatus();
        eventQueue.processAll(1000L);
        Assert.assertEquals((long)1L, (long)delayedSafeModeEvents.size());
        Assert.assertEquals((long)1L, (long)safeModeEvents.size());
        this.scmSafeModeManager.setInSafeMode(false);
        this.scmSafeModeManager.setPreCheckComplete(true);
        this.scmSafeModeManager.emitSafeModeStatus();
        eventQueue.processAll(1000L);
        Assert.assertEquals((long)2L, (long)safeModeEvents.size());
        Assert.assertEquals((long)1L, (long)delayedSafeModeEvents.size());
        GenericTestUtils.waitFor(() -> delayedSafeModeEvents.size() == 2, (int)300, (int)6000);
    }

    @Test
    public void testSafeModeExitRule() throws Exception {
        this.containers = new ArrayList<ContainerInfo>();
        int numContainers = 100;
        this.containers.addAll(HddsTestUtils.getContainerInfo(numContainers));
        for (ContainerInfo container : this.containers) {
            container.setState(HddsProtos.LifeCycleState.CLOSED);
        }
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, this.containers, null, queue);
        long cutOff = (long)Math.ceil((double)numContainers * config.getDouble("hdds.scm.safemode.threshold.pct", 0.99));
        Assert.assertEquals((long)cutOff, (long)this.scmSafeModeManager.getSafeModeMetrics().getNumContainerWithOneReplicaReportedThreshold().value());
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers.subList(0, 25), 0.25);
        Assert.assertEquals((long)25L, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentContainersWithOneReplicaReportedCount().value());
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers.subList(25, 50), 0.5);
        Assert.assertEquals((long)50L, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentContainersWithOneReplicaReportedCount().value());
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers.subList(50, 75), 0.75);
        Assert.assertEquals((long)75L, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentContainersWithOneReplicaReportedCount().value());
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers.subList(75, 100), 1.0);
        Assert.assertEquals((long)100L, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentContainersWithOneReplicaReportedCount().value());
        GenericTestUtils.waitFor(() -> !this.scmSafeModeManager.getInSafeMode(), (int)100, (int)5000);
    }

    private OzoneConfiguration createConf(double healthyPercent, double oneReplicaPercent) throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration();
        conf.set("ozone.metadata.dirs", this.tempDir.newFolder().toString());
        conf.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        conf.setDouble("hdds.scm.safemode.healthy.pipeline.pct", healthyPercent);
        conf.setDouble("hdds.scm.safemode.atleast.one.node.reported.pipeline.pct", oneReplicaPercent);
        conf.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        return conf;
    }

    @Test
    public void testSafeModeExitRuleWithPipelineAvailabilityCheck1() throws Exception {
        this.testSafeModeExitRuleWithPipelineAvailabilityCheck(100, 30, 8, 0.9, 1.0);
    }

    @Test
    public void testSafeModeExitRuleWithPipelineAvailabilityCheck2() throws Exception {
        this.testSafeModeExitRuleWithPipelineAvailabilityCheck(100, 90, 22, 0.1, 0.9);
    }

    @Test
    public void testSafeModeExitRuleWithPipelineAvailabilityCheck3() throws Exception {
        this.testSafeModeExitRuleWithPipelineAvailabilityCheck(100, 30, 8, 0.0, 0.9);
    }

    @Test
    public void testSafeModeExitRuleWithPipelineAvailabilityCheck4() throws Exception {
        this.testSafeModeExitRuleWithPipelineAvailabilityCheck(100, 90, 22, 0.0, 0.0);
    }

    @Test
    public void testSafeModeExitRuleWithPipelineAvailabilityCheck5() throws Exception {
        this.testSafeModeExitRuleWithPipelineAvailabilityCheck(100, 90, 22, 0.0, 0.5);
    }

    @Test
    public void testFailWithIncorrectValueForHealthyPipelinePercent() throws Exception {
        try {
            OzoneConfiguration conf = this.createConf(100.0, 0.9);
            MockNodeManager mockNodeManager = new MockNodeManager(true, 10);
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)mockNodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)queue);
            this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, this.containers, (PipelineManager)pipelineManager, queue);
            Assert.fail((String)"testFailWithIncorrectValueForHealthyPipelinePercent");
        }
        catch (IllegalArgumentException ex) {
            GenericTestUtils.assertExceptionContains((String)"value should be >= 0.0 and <= 1.0", (Throwable)ex);
        }
    }

    @Test
    public void testFailWithIncorrectValueForOneReplicaPipelinePercent() throws Exception {
        try {
            OzoneConfiguration conf = this.createConf(0.9, 200.0);
            MockNodeManager mockNodeManager = new MockNodeManager(true, 10);
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)mockNodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)queue);
            this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, this.containers, (PipelineManager)pipelineManager, queue);
            Assert.fail((String)"testFailWithIncorrectValueForOneReplicaPipelinePercent");
        }
        catch (IllegalArgumentException ex) {
            GenericTestUtils.assertExceptionContains((String)"value should be >= 0.0 and <= 1.0", (Throwable)ex);
        }
    }

    @Test
    public void testFailWithIncorrectValueForSafeModePercent() throws Exception {
        try {
            OzoneConfiguration conf = this.createConf(0.9, 0.1);
            conf.setDouble("hdds.scm.safemode.threshold.pct", -1.0);
            MockNodeManager mockNodeManager = new MockNodeManager(true, 10);
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)mockNodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)queue);
            this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, this.containers, (PipelineManager)pipelineManager, queue);
            Assert.fail((String)"testFailWithIncorrectValueForSafeModePercent");
        }
        catch (IllegalArgumentException ex) {
            GenericTestUtils.assertExceptionContains((String)"value should be >= 0.0 and <= 1.0", (Throwable)ex);
        }
    }

    public void testSafeModeExitRuleWithPipelineAvailabilityCheck(int containerCount, int nodeCount, int pipelineCount, double healthyPipelinePercent, double oneReplicaPercent) throws Exception {
        OzoneConfiguration conf = this.createConf(healthyPipelinePercent, oneReplicaPercent);
        this.containers = new ArrayList<ContainerInfo>();
        this.containers.addAll(HddsTestUtils.getContainerInfo(containerCount));
        MockNodeManager mockNodeManager = new MockNodeManager(true, nodeCount);
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)mockNodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)queue);
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)mockNodeManager, pipelineManager.getStateManager(), (ConfigurationSource)config, true);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        pipelineManager.allowPipelineCreation();
        for (int i = 0; i < pipelineCount; ++i) {
            pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        }
        for (ContainerInfo container : this.containers) {
            container.setState(HddsProtos.LifeCycleState.CLOSED);
        }
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, this.containers, (PipelineManager)pipelineManager, queue);
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers, 1.0);
        List pipelines = pipelineManager.getPipelines();
        int healthyPipelineThresholdCount = this.scmSafeModeManager.getHealthyPipelineSafeModeRule().getHealthyPipelineThresholdCount();
        int oneReplicaThresholdCount = this.scmSafeModeManager.getOneReplicaPipelineSafeModeRule().getThresholdCount();
        Assert.assertEquals((long)healthyPipelineThresholdCount, (long)this.scmSafeModeManager.getSafeModeMetrics().getNumHealthyPipelinesThreshold().value());
        Assert.assertEquals((long)oneReplicaThresholdCount, (long)this.scmSafeModeManager.getSafeModeMetrics().getNumPipelinesWithAtleastOneReplicaReportedThreshold().value());
        if (Math.max(healthyPipelinePercent, (double)oneReplicaThresholdCount) == 0.0) {
            this.firePipelineEvent(pipelineManager, (Pipeline)pipelines.get(0));
        }
        for (int i = 0; i < Math.max(healthyPipelineThresholdCount, Math.min(oneReplicaThresholdCount, pipelines.size())); ++i) {
            this.firePipelineEvent(pipelineManager, (Pipeline)pipelines.get(i));
            if (i < healthyPipelineThresholdCount) {
                this.checkHealthy(i + 1);
                Assert.assertEquals((long)(i + 1), (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentHealthyPipelinesCount().value());
            }
            if (i >= oneReplicaThresholdCount) continue;
            this.checkOpen(i + 1);
            Assert.assertEquals((long)(i + 1), (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentPipelinesWithAtleastOneReplicaCount().value());
        }
        Assert.assertEquals((long)healthyPipelineThresholdCount, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentHealthyPipelinesCount().value());
        Assert.assertEquals((long)oneReplicaThresholdCount, (long)this.scmSafeModeManager.getSafeModeMetrics().getCurrentPipelinesWithAtleastOneReplicaCount().value());
        GenericTestUtils.waitFor(() -> !this.scmSafeModeManager.getInSafeMode(), (int)100, (int)5000);
    }

    private void checkHealthy(int expectedCount) throws Exception {
        GenericTestUtils.waitFor(() -> this.scmSafeModeManager.getHealthyPipelineSafeModeRule().getCurrentHealthyPipelineCount() == expectedCount, (int)100, (int)5000);
    }

    private void checkOpen(int expectedCount) throws Exception {
        GenericTestUtils.waitFor(() -> this.scmSafeModeManager.getOneReplicaPipelineSafeModeRule().getCurrentReportedPipelineCount() == expectedCount, (int)1000, (int)5000);
    }

    private void firePipelineEvent(SCMPipelineManager pipelineManager, Pipeline pipeline) throws Exception {
        pipelineManager.openPipeline(pipeline.getId());
        queue.fireEvent((Event)SCMEvents.OPEN_PIPELINE, (Object)pipelineManager.getPipeline(pipeline.getId()));
    }

    @Test
    public void testDisableSafeMode() {
        OzoneConfiguration conf = new OzoneConfiguration((Configuration)config);
        conf.setBoolean("hdds.scm.safemode.enabled", false);
        PipelineManager pipelineManager = (PipelineManager)Mockito.mock(PipelineManager.class);
        ((PipelineManager)Mockito.doNothing().when((Object)pipelineManager)).startPipelineCreator();
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, this.containers, pipelineManager, queue);
        Assert.assertFalse((boolean)this.scmSafeModeManager.getInSafeMode());
    }

    @Test
    public void testSafeModeDataNodeExitRule() throws Exception {
        this.containers = new ArrayList<ContainerInfo>();
        this.testSafeModeDataNodes(0);
        this.testSafeModeDataNodes(3);
        this.testSafeModeDataNodes(5);
    }

    @Test
    public void testContainerSafeModeRule() throws Exception {
        this.containers = new ArrayList<ContainerInfo>();
        this.containers.addAll(HddsTestUtils.getContainerInfo(100));
        for (ContainerInfo container : this.containers.subList(0, 25)) {
            container.setState(HddsProtos.LifeCycleState.CLOSED);
        }
        for (ContainerInfo container : this.containers.subList(25, 100)) {
            container.setState(HddsProtos.LifeCycleState.OPEN);
        }
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, this.containers, null, queue);
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers.subList(0, 10), 0.4);
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        this.testContainerThreshold(this.containers.subList(10, 25), 1.0);
        GenericTestUtils.waitFor(() -> !this.scmSafeModeManager.getInSafeMode(), (int)100, (int)5000);
    }

    private void testSafeModeDataNodes(int numOfDns) throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration((Configuration)config);
        conf.setInt("hdds.scm.safemode.min.datanode", numOfDns);
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, this.containers, null, queue);
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        for (int i = 0; i < numOfDns - 1; ++i) {
            queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(this.containers));
            Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
            Assert.assertTrue((this.scmSafeModeManager.getCurrentContainerThreshold() == 1.0 ? 1 : 0) != 0);
        }
        if (numOfDns == 0) {
            GenericTestUtils.waitFor(() -> this.scmSafeModeManager.getInSafeMode(), (int)10, (int)10000);
            return;
        }
        queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(this.containers));
        GenericTestUtils.waitFor(() -> !this.scmSafeModeManager.getInSafeMode(), (int)10, (int)10000);
    }

    private void testContainerThreshold(List<ContainerInfo> dnContainers, double expectedThreshold) throws Exception {
        queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(dnContainers));
        GenericTestUtils.waitFor(() -> {
            double threshold = this.scmSafeModeManager.getCurrentContainerThreshold();
            return threshold == expectedThreshold;
        }, (int)100, (int)18000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSafeModePipelineExitRule() throws Exception {
        this.containers = new ArrayList<ContainerInfo>();
        this.containers.addAll(HddsTestUtils.getContainerInfo(100));
        String storageDir = GenericTestUtils.getTempPath((String)(TestSCMSafeModeManager.class.getName() + UUID.randomUUID()));
        try {
            MockNodeManager nodeManager = new MockNodeManager(true, 3);
            config.set("ozone.metadata.dirs", storageDir);
            config.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)config, (NodeManager)nodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)queue);
            MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)config, true);
            pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
            pipelineManager.allowPipelineCreation();
            Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, this.containers, (PipelineManager)pipelineManager, queue);
            queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(this.containers));
            Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
            this.firePipelineEvent(pipelineManager, pipeline);
            GenericTestUtils.waitFor(() -> !this.scmSafeModeManager.getInSafeMode(), (int)100, (int)10000);
            pipelineManager.close();
        }
        finally {
            config.setBoolean("hdds.scm.safemode.pipeline-availability.check", false);
            FileUtil.fullyDelete((File)new File(storageDir));
        }
    }

    @Test
    public void testPipelinesNotCreatedUntilPreCheckPasses() throws Exception {
        int numOfDns = 5;
        config.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        config.setInt("hdds.scm.safemode.min.datanode", numOfDns);
        config.setBoolean("hdds.scm.safemode.pipeline.creation", true);
        MockNodeManager nodeManager = new MockNodeManager(true, numOfDns);
        String storageDir = GenericTestUtils.getTempPath((String)(TestSCMSafeModeManager.class.getName() + UUID.randomUUID()));
        config.set("ozone.metadata.dirs", storageDir);
        config.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)config, (NodeManager)nodeManager, this.scmMetadataStore.getPipelineTable(), (EventPublisher)queue);
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)config, true);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        SafeModeEventHandler smHandler = new SafeModeEventHandler();
        queue.addHandler((Event)SCMEvents.SAFE_MODE_STATUS, (EventHandler)smHandler);
        this.scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, this.containers, (PipelineManager)pipelineManager, queue);
        Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
        for (int i = 0; i < numOfDns - 1; ++i) {
            queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(this.containers));
            Assert.assertTrue((boolean)this.scmSafeModeManager.getInSafeMode());
            Assert.assertFalse((boolean)this.scmSafeModeManager.getPreCheckComplete());
        }
        queue.processAll(5000L);
        Assert.assertEquals((long)0L, (long)smHandler.getInvokedCount());
        queue.fireEvent((Event)SCMEvents.NODE_REGISTRATION_CONT_REPORT, (Object)HddsTestUtils.createNodeRegistrationContainerReport(this.containers));
        queue.processAll(5000L);
        Assert.assertEquals((long)1L, (long)smHandler.getInvokedCount());
        Assert.assertEquals((Object)true, (Object)smHandler.getPreCheckComplete());
        Assert.assertEquals((Object)true, (Object)smHandler.getIsInSafeMode());
        pipelineManager.allowPipelineCreation();
        Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        this.firePipelineEvent(pipelineManager, pipeline);
        queue.processAll(5000L);
        Assert.assertEquals((long)2L, (long)smHandler.getInvokedCount());
        Assert.assertEquals((Object)true, (Object)smHandler.getPreCheckComplete());
        Assert.assertEquals((Object)false, (Object)smHandler.getIsInSafeMode());
    }

    private static class SafeModeEventHandler
    implements EventHandler<SCMSafeModeManager.SafeModeStatus> {
        private AtomicInteger invokedCount = new AtomicInteger(0);
        private AtomicBoolean preCheckComplete = new AtomicBoolean(false);
        private AtomicBoolean isInSafeMode = new AtomicBoolean(true);

        private SafeModeEventHandler() {
        }

        public int getInvokedCount() {
            return this.invokedCount.get();
        }

        public boolean getPreCheckComplete() {
            return this.preCheckComplete.get();
        }

        public boolean getIsInSafeMode() {
            return this.isInSafeMode.get();
        }

        public void onMessage(SCMSafeModeManager.SafeModeStatus safeModeStatus, EventPublisher publisher) {
            this.invokedCount.incrementAndGet();
            this.preCheckComplete.set(safeModeStatus.isPreCheckComplete());
            this.isInSafeMode.set(safeModeStatus.isInSafeMode());
        }
    }
}

