/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.safemode.OneReplicaPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOneReplicaPipelineSafeModeRule {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private OneReplicaPipelineSafeModeRule rule;
    private SCMPipelineManager pipelineManager;
    private EventQueue eventQueue;

    private void setup(int nodes, int pipelineFactorThreeCount, int pipelineFactorOneCount) throws Exception {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        ozoneConfiguration.set("ozone.metadata.dirs", this.folder.newFolder().toString());
        ozoneConfiguration.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>();
        containers.addAll(HddsTestUtils.getContainerInfo(1));
        MockNodeManager mockNodeManager = new MockNodeManager(true, nodes);
        this.eventQueue = new EventQueue();
        SCMMetadataStoreImpl scmMetadataStore = new SCMMetadataStoreImpl(ozoneConfiguration);
        this.pipelineManager = new SCMPipelineManager((ConfigurationSource)ozoneConfiguration, (NodeManager)mockNodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)this.eventQueue);
        this.pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(mockNodeManager, this.pipelineManager.getStateManager(), (ConfigurationSource)ozoneConfiguration);
        this.pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        this.createPipelines(pipelineFactorThreeCount, HddsProtos.ReplicationFactor.THREE);
        this.createPipelines(pipelineFactorOneCount, HddsProtos.ReplicationFactor.ONE);
        SCMSafeModeManager scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)ozoneConfiguration, containers, (PipelineManager)this.pipelineManager, this.eventQueue);
        this.rule = scmSafeModeManager.getOneReplicaPipelineSafeModeRule();
    }

    @Test
    public void testOneReplicaPipelineRule() throws Exception {
        int nodes = 30;
        int pipelineFactorThreeCount = 7;
        int pipelineCountOne = 0;
        this.setup(nodes, pipelineFactorThreeCount, pipelineCountOne);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SCMSafeModeManager.class));
        List pipelines = this.pipelineManager.getPipelines();
        for (int i = 0; i < pipelineFactorThreeCount - 1; ++i) {
            this.firePipelineEvent((Pipeline)pipelines.get(i));
        }
        GenericTestUtils.waitFor(() -> logCapturer.getOutput().contains("reported count is 6"), (int)1000, (int)5000);
        Assert.assertFalse((boolean)this.rule.validate());
        this.firePipelineEvent((Pipeline)pipelines.get(pipelineFactorThreeCount - 1));
        GenericTestUtils.waitFor(() -> this.rule.validate(), (int)1000, (int)5000);
    }

    @Test
    public void testOneReplicaPipelineRuleMixedPipelines() throws Exception {
        int i;
        int nodes = 30;
        int pipelineCountThree = 7;
        int pipelineCountOne = 21;
        this.setup(nodes, pipelineCountThree, pipelineCountOne);
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SCMSafeModeManager.class));
        List pipelines = this.pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE);
        for (i = 0; i < pipelineCountOne; ++i) {
            this.firePipelineEvent((Pipeline)pipelines.get(i));
        }
        GenericTestUtils.waitFor(() -> logCapturer.getOutput().contains("reported count is 0"), (int)1000, (int)5000);
        Assert.assertFalse((boolean)this.rule.validate());
        pipelines = this.pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        for (i = 0; i < pipelineCountThree - 1; ++i) {
            this.firePipelineEvent((Pipeline)pipelines.get(i));
        }
        GenericTestUtils.waitFor(() -> logCapturer.getOutput().contains("reported count is 6"), (int)1000, (int)5000);
        this.firePipelineEvent((Pipeline)pipelines.get(pipelineCountThree - 1));
        GenericTestUtils.waitFor(() -> this.rule.validate(), (int)1000, (int)5000);
    }

    private void createPipelines(int count, HddsProtos.ReplicationFactor factor) throws Exception {
        for (int i = 0; i < count; ++i) {
            this.pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, factor);
        }
    }

    private void firePipelineEvent(Pipeline pipeline) {
        this.eventQueue.fireEvent((Event)SCMEvents.OPEN_PIPELINE, (Object)pipeline);
    }
}

