/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHealthyPipelineSafeModeRule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHealthyPipelineSafeModeRuleWithNoPipelines() throws Exception {
        EventQueue eventQueue = new EventQueue();
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>(HddsTestUtils.getContainerInfo(1));
        String storageDir = GenericTestUtils.getTempPath((String)(TestHealthyPipelineSafeModeRule.class.getName() + UUID.randomUUID()));
        OzoneConfiguration config = new OzoneConfiguration();
        MockNodeManager nodeManager = new MockNodeManager(true, 0);
        config.set("ozone.metadata.dirs", storageDir);
        config.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        config.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        SCMMetadataStoreImpl scmMetadataStore = new SCMMetadataStoreImpl(config);
        try {
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)config, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
            MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)config);
            pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
            SCMSafeModeManager scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, containers, (PipelineManager)pipelineManager, eventQueue);
            HealthyPipelineSafeModeRule healthyPipelineSafeModeRule = scmSafeModeManager.getHealthyPipelineSafeModeRule();
            Assert.assertTrue((boolean)healthyPipelineSafeModeRule.validate());
        }
        finally {
            scmMetadataStore.getStore().close();
            FileUtil.fullyDelete((File)new File(storageDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHealthyPipelineSafeModeRuleWithPipelines() throws Exception {
        String storageDir = GenericTestUtils.getTempPath((String)(TestHealthyPipelineSafeModeRule.class.getName() + UUID.randomUUID()));
        EventQueue eventQueue = new EventQueue();
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>(HddsTestUtils.getContainerInfo(1));
        OzoneConfiguration config = new OzoneConfiguration();
        MockNodeManager nodeManager = new MockNodeManager(true, 12);
        config.set("ozone.metadata.dirs", storageDir);
        config.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        config.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        SCMMetadataStoreImpl scmMetadataStore = new SCMMetadataStoreImpl(config);
        try {
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)config, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
            pipelineManager.allowPipelineCreation();
            MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)config, true);
            pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
            Pipeline pipeline1 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            Pipeline pipeline2 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            Pipeline pipeline3 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            SCMSafeModeManager scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, containers, (PipelineManager)pipelineManager, eventQueue);
            HealthyPipelineSafeModeRule healthyPipelineSafeModeRule = scmSafeModeManager.getHealthyPipelineSafeModeRule();
            Assert.assertFalse((boolean)healthyPipelineSafeModeRule.validate());
            this.firePipelineEvent(pipeline1, eventQueue);
            GenericTestUtils.waitFor(() -> healthyPipelineSafeModeRule.validate(), (int)1000, (int)5000);
        }
        finally {
            scmMetadataStore.getStore().close();
            FileUtil.fullyDelete((File)new File(storageDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHealthyPipelineSafeModeRuleWithMixedPipelines() throws Exception {
        String storageDir = GenericTestUtils.getTempPath((String)(TestHealthyPipelineSafeModeRule.class.getName() + UUID.randomUUID()));
        EventQueue eventQueue = new EventQueue();
        ArrayList<ContainerInfo> containers = new ArrayList<ContainerInfo>(HddsTestUtils.getContainerInfo(1));
        OzoneConfiguration config = new OzoneConfiguration();
        MockNodeManager nodeManager = new MockNodeManager(true, 12);
        config.set("ozone.metadata.dirs", storageDir);
        config.setBoolean("hdds.scm.safemode.pipeline-availability.check", true);
        config.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        SCMMetadataStoreImpl scmMetadataStore = new SCMMetadataStoreImpl(config);
        try {
            SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)config, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
            pipelineManager.allowPipelineCreation();
            MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider((NodeManager)nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)config, true);
            pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
            Pipeline pipeline1 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE);
            Pipeline pipeline2 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            Pipeline pipeline3 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            SCMSafeModeManager scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)config, containers, (PipelineManager)pipelineManager, eventQueue);
            HealthyPipelineSafeModeRule healthyPipelineSafeModeRule = scmSafeModeManager.getHealthyPipelineSafeModeRule();
            Assert.assertFalse((boolean)healthyPipelineSafeModeRule.validate());
            GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SCMSafeModeManager.class));
            this.firePipelineEvent(pipeline1, eventQueue);
            GenericTestUtils.waitFor(() -> logCapturer.getOutput().contains("reported count is 1"), (int)1000, (int)5000);
            Assert.assertFalse((boolean)healthyPipelineSafeModeRule.validate());
            this.firePipelineEvent(pipeline2, eventQueue);
            this.firePipelineEvent(pipeline3, eventQueue);
            GenericTestUtils.waitFor(() -> healthyPipelineSafeModeRule.validate(), (int)1000, (int)5000);
        }
        finally {
            scmMetadataStore.getStore().close();
            FileUtil.fullyDelete((File)new File(storageDir));
        }
    }

    private void firePipelineEvent(Pipeline pipeline, EventQueue eventQueue) {
        eventQueue.fireEvent((Event)SCMEvents.OPEN_PIPELINE, (Object)pipeline);
    }
}

