/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.SimplePipelineProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSimplePipelineProvider {
    private NodeManager nodeManager;
    private PipelineProvider provider;
    private PipelineStateManager stateManager;

    @Before
    public void init() throws Exception {
        this.nodeManager = new MockNodeManager(true, 10);
        this.stateManager = new PipelineStateManager();
        this.provider = new SimplePipelineProvider(this.nodeManager, this.stateManager);
    }

    @Test
    public void testCreatePipelineWithFactor() throws IOException {
        HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.THREE;
        Pipeline pipeline = this.provider.create(factor);
        this.stateManager.addPipeline(pipeline);
        Assert.assertEquals((Object)pipeline.getType(), (Object)HddsProtos.ReplicationType.STAND_ALONE);
        Assert.assertEquals((Object)pipeline.getFactor(), (Object)factor);
        Assert.assertEquals((Object)pipeline.getPipelineState(), (Object)Pipeline.PipelineState.OPEN);
        Assert.assertEquals((long)pipeline.getNodes().size(), (long)factor.getNumber());
        factor = HddsProtos.ReplicationFactor.ONE;
        Pipeline pipeline1 = this.provider.create(factor);
        this.stateManager.addPipeline(pipeline1);
        Assert.assertEquals((Object)pipeline1.getType(), (Object)HddsProtos.ReplicationType.STAND_ALONE);
        Assert.assertEquals((Object)pipeline1.getFactor(), (Object)factor);
        Assert.assertEquals((Object)pipeline1.getPipelineState(), (Object)Pipeline.PipelineState.OPEN);
        Assert.assertEquals((long)pipeline1.getNodes().size(), (long)factor.getNumber());
    }

    private List<DatanodeDetails> createListOfNodes(int nodeCount) {
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < nodeCount; ++i) {
            nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        return nodes;
    }

    @Test
    public void testCreatePipelineWithNodes() throws IOException {
        HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.THREE;
        Pipeline pipeline = this.provider.create(factor, this.createListOfNodes(factor.getNumber()));
        Assert.assertEquals((Object)pipeline.getType(), (Object)HddsProtos.ReplicationType.STAND_ALONE);
        Assert.assertEquals((Object)pipeline.getFactor(), (Object)factor);
        Assert.assertEquals((Object)pipeline.getPipelineState(), (Object)Pipeline.PipelineState.OPEN);
        Assert.assertEquals((long)pipeline.getNodes().size(), (long)factor.getNumber());
        factor = HddsProtos.ReplicationFactor.ONE;
        pipeline = this.provider.create(factor, this.createListOfNodes(factor.getNumber()));
        Assert.assertEquals((Object)pipeline.getType(), (Object)HddsProtos.ReplicationType.STAND_ALONE);
        Assert.assertEquals((Object)pipeline.getFactor(), (Object)factor);
        Assert.assertEquals((Object)pipeline.getPipelineState(), (Object)Pipeline.PipelineState.OPEN);
        Assert.assertEquals((long)pipeline.getNodes().size(), (long)factor.getNumber());
    }
}

