/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.metadata.PipelineCodec;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateStore;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;

public class TestSCMStoreImplWithOldPipelineIDKeyFormat
implements SCMMetadataStore {
    private DBStore store;
    private final OzoneConfiguration configuration;
    private Table<PipelineID, Pipeline> pipelineTable;

    public TestSCMStoreImplWithOldPipelineIDKeyFormat(OzoneConfiguration config) throws IOException {
        this.configuration = config;
        this.start(this.configuration);
    }

    public void start(OzoneConfiguration config) throws IOException {
        if (this.store == null) {
            this.store = DBStoreBuilder.createDBStore((ConfigurationSource)config, (DBDefinition)new SCMDBTestDefinition());
            this.pipelineTable = SCMDBDefinition.PIPELINES.getTable(this.store);
        }
    }

    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    public DBStore getStore() {
        return null;
    }

    public Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> getDeletedBlocksTXTable() {
        return null;
    }

    public Long getCurrentTXID() {
        return null;
    }

    public Long getNextDeleteBlockTXID() {
        return null;
    }

    public Table<BigInteger, X509Certificate> getValidCertsTable() {
        return null;
    }

    public Table<BigInteger, X509Certificate> getRevokedCertsTable() {
        return null;
    }

    public TableIterator getAllCerts(CertificateStore.CertType certType) {
        return null;
    }

    public Table<PipelineID, Pipeline> getPipelineTable() {
        return this.pipelineTable;
    }

    public BatchOperationHandler getBatchHandler() {
        return null;
    }

    public Table<ContainerID, ContainerInfo> getContainerTable() {
        return null;
    }

    public static class OldPipelineIDCodec
    implements Codec<PipelineID> {
        public byte[] toPersistedFormat(PipelineID object) throws IOException {
            return object.getProtobuf().toByteArray();
        }

        public PipelineID fromPersistedFormat(byte[] rawData) throws IOException {
            return null;
        }

        public PipelineID copyObject(PipelineID object) {
            throw new UnsupportedOperationException();
        }
    }

    public static class SCMDBTestDefinition
    implements DBDefinition {
        public static final DBColumnFamilyDefinition<PipelineID, Pipeline> PIPELINES = new DBColumnFamilyDefinition("pipelines", PipelineID.class, (Codec)new OldPipelineIDCodec(), Pipeline.class, (Codec)new PipelineCodec());

        public String getName() {
            return "scm.db";
        }

        public String getLocationConfigKey() {
            return "ozone.scm.db.dirs";
        }

        public DBColumnFamilyDefinition[] getColumnFamilies() {
            return new DBColumnFamilyDefinition[]{PIPELINES};
        }
    }
}

