/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.metadata.PipelineIDCodec;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStoreImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineReportHandler;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.SCMPipelineMetrics;
import org.apache.hadoop.hdds.scm.pipeline.TestSCMStoreImplWithOldPipelineIDKeyFormat;
import org.apache.hadoop.hdds.scm.safemode.SCMSafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestSCMPipelineManager {
    private static MockNodeManager nodeManager;
    private static File testDir;
    private static OzoneConfiguration conf;
    private static SCMMetadataStore scmMetadataStore;

    @Before
    public void setUp() throws Exception {
        boolean folderExisted;
        conf = new OzoneConfiguration();
        conf.setInt("ozone.datanode.pipeline.limit", 1);
        testDir = GenericTestUtils.getTestDir((String)TestSCMPipelineManager.class.getSimpleName());
        conf.set("ozone.metadata.dirs", testDir.getAbsolutePath());
        conf.setBoolean("hdds.scm.safemode.pipeline.creation", false);
        boolean bl = folderExisted = testDir.exists() || testDir.mkdirs();
        if (!folderExisted) {
            throw new IOException("Unable to create test directory path");
        }
        nodeManager = new MockNodeManager(true, 20);
        scmMetadataStore = new SCMMetadataStoreImpl(conf);
    }

    @After
    public void cleanup() throws Exception {
        scmMetadataStore.getStore().close();
        FileUtil.fullyDelete((File)testDir);
    }

    @Test
    public void testPipelineReload() throws IOException {
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        int pipelineNum = 5;
        HashSet<Pipeline> pipelines = new HashSet<Pipeline>();
        for (int i = 0; i < pipelineNum; ++i) {
            Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            pipelines.add(pipeline);
        }
        pipelineManager.close();
        pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        pipelineManager.allowPipelineCreation();
        mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        for (Pipeline p : pipelines) {
            pipelineManager.openPipeline(p.getId());
        }
        List pipelineList = pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS);
        Assert.assertEquals(pipelines, new HashSet(pipelineList));
        Set originalPipelines = pipelineList.stream().map(Pipeline::getNodeSet).collect(Collectors.toSet());
        Set reloadedPipelineHash = pipelines.stream().map(Pipeline::getNodeSet).collect(Collectors.toSet());
        Assert.assertEquals(reloadedPipelineHash, originalPipelines);
        Assert.assertEquals((long)pipelineNum, (long)originalPipelines.size());
        for (Pipeline pipeline : pipelines) {
            pipelineManager.finalizeAndDestroyPipeline(pipeline, false);
        }
        pipelineManager.close();
    }

    @Test
    public void testRemovePipeline() throws IOException {
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        pipelineManager.openPipeline(pipeline.getId());
        pipelineManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)1L));
        pipelineManager.finalizeAndDestroyPipeline(pipeline, false);
        pipelineManager.close();
        pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        try {
            pipelineManager.getPipeline(pipeline.getId());
            Assert.fail((String)"Pipeline should not have been retrieved");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not found"));
        }
        pipelineManager.close();
    }

    @Test
    public void testPipelineReport() throws IOException {
        EventQueue eventQueue = new EventQueue();
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        SCMSafeModeManager scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)conf, new ArrayList(), (PipelineManager)pipelineManager, eventQueue);
        Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        Assert.assertFalse((boolean)pipelineManager.getPipeline(pipeline.getId()).isHealthy());
        Assert.assertFalse((boolean)pipelineManager.getPipeline(pipeline.getId()).isOpen());
        List nodes = pipeline.getNodes();
        Assert.assertFalse((boolean)pipelineManager.getPipeline(pipeline.getId()).isHealthy());
        PipelineReportHandler pipelineReportHandler = new PipelineReportHandler((SafeModeManager)scmSafeModeManager, (PipelineManager)pipelineManager, (ConfigurationSource)conf);
        nodes.subList(0, 2).forEach(dn -> this.sendPipelineReport((DatanodeDetails)dn, pipeline, pipelineReportHandler, false, eventQueue));
        this.sendPipelineReport((DatanodeDetails)nodes.get(nodes.size() - 1), pipeline, pipelineReportHandler, true, eventQueue);
        Assert.assertTrue((boolean)pipelineManager.getPipeline(pipeline.getId()).isHealthy());
        Assert.assertTrue((boolean)pipelineManager.getPipeline(pipeline.getId()).isOpen());
        pipelineManager.finalizeAndDestroyPipeline(pipeline, false);
        nodes.subList(0, 2).forEach(dn -> this.sendPipelineReport((DatanodeDetails)dn, pipeline, pipelineReportHandler, false, eventQueue));
        this.sendPipelineReport((DatanodeDetails)nodes.get(nodes.size() - 1), pipeline, pipelineReportHandler, true, eventQueue);
        try {
            pipelineManager.getPipeline(pipeline.getId());
            Assert.fail((String)"Pipeline should not have been retrieved");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not found"));
        }
        pipelineManager.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPipelineCreationFailedMetric() throws Exception {
        MockNodeManager nodeManagerMock = new MockNodeManager(true, 20);
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManagerMock, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManagerMock, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        MetricsRecordBuilder metrics = MetricsAsserts.getMetrics((String)SCMPipelineMetrics.class.getSimpleName());
        long numPipelineAllocated = MetricsAsserts.getLongCounter((String)"NumPipelineAllocated", (MetricsRecordBuilder)metrics);
        Assert.assertEquals((long)0L, (long)numPipelineAllocated);
        for (int i = 0; i < 5; ++i) {
            Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            Assert.assertNotNull((Object)pipeline);
        }
        metrics = MetricsAsserts.getMetrics((String)SCMPipelineMetrics.class.getSimpleName());
        numPipelineAllocated = MetricsAsserts.getLongCounter((String)"NumPipelineAllocated", (MetricsRecordBuilder)metrics);
        Assert.assertEquals((long)5L, (long)numPipelineAllocated);
        long numPipelineCreateFailed = MetricsAsserts.getLongCounter((String)"NumPipelineCreationFailed", (MetricsRecordBuilder)metrics);
        Assert.assertEquals((long)0L, (long)numPipelineCreateFailed);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)SCMPipelineManager.getLog());
        GenericTestUtils.setLogLevel((Logger)SCMPipelineManager.getLog(), (Level)Level.INFO);
        try {
            pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            Assert.fail();
        }
        catch (SCMException ioe) {
            Assert.assertEquals((Object)SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE, (Object)ioe.getResult());
            Assert.assertFalse((boolean)logs.getOutput().contains("Failed to create pipeline of type"));
        }
        finally {
            logs.stopCapturing();
        }
        metrics = MetricsAsserts.getMetrics((String)SCMPipelineMetrics.class.getSimpleName());
        numPipelineAllocated = MetricsAsserts.getLongCounter((String)"NumPipelineAllocated", (MetricsRecordBuilder)metrics);
        Assert.assertEquals((long)5L, (long)numPipelineAllocated);
        numPipelineCreateFailed = MetricsAsserts.getLongCounter((String)"NumPipelineCreationFailed", (MetricsRecordBuilder)metrics);
        Assert.assertEquals((long)1L, (long)numPipelineCreateFailed);
        pipelineManager.close();
    }

    @Test
    public void testActivateDeactivatePipeline() throws IOException {
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        PipelineID pid = pipeline.getId();
        pipelineManager.openPipeline(pid);
        pipelineManager.addContainerToPipeline(pid, ContainerID.valueof((long)1L));
        Assert.assertTrue((boolean)pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).contains(pipeline));
        Assert.assertEquals((Object)Pipeline.PipelineState.OPEN, (Object)pipelineManager.getPipeline(pid).getPipelineState());
        pipelineManager.deactivatePipeline(pid);
        Assert.assertEquals((Object)Pipeline.PipelineState.DORMANT, (Object)pipelineManager.getPipeline(pid).getPipelineState());
        Assert.assertFalse((boolean)pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).contains(pipeline));
        pipelineManager.activatePipeline(pid);
        Assert.assertTrue((boolean)pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).contains(pipeline));
        pipelineManager.close();
    }

    @Test
    public void testPipelineOpenOnlyWhenLeaderReported() throws Exception {
        EventQueue eventQueue = new EventQueue();
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        pipelineManager.onMessage(new SCMSafeModeManager.SafeModeStatus(true, true), null);
        Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        pipelineManager.close();
        pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        mockRatisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)mockRatisProvider);
        Assert.assertEquals((Object)Pipeline.PipelineState.ALLOCATED, (Object)pipelineManager.getPipeline(pipeline.getId()).getPipelineState());
        SCMSafeModeManager scmSafeModeManager = new SCMSafeModeManager((ConfigurationSource)new OzoneConfiguration(), new ArrayList(), (PipelineManager)pipelineManager, eventQueue);
        PipelineReportHandler pipelineReportHandler = new PipelineReportHandler((SafeModeManager)scmSafeModeManager, (PipelineManager)pipelineManager, (ConfigurationSource)conf);
        List nodes = pipeline.getNodes();
        Assert.assertEquals((long)3L, (long)nodes.size());
        nodes.forEach(dn -> this.sendPipelineReport((DatanodeDetails)dn, pipeline, pipelineReportHandler, false, eventQueue));
        Assert.assertEquals((Object)Pipeline.PipelineState.ALLOCATED, (Object)pipelineManager.getPipeline(pipeline.getId()).getPipelineState());
        nodes.subList(0, 2).forEach(dn -> this.sendPipelineReport((DatanodeDetails)dn, pipeline, pipelineReportHandler, false, eventQueue));
        this.sendPipelineReport((DatanodeDetails)nodes.get(nodes.size() - 1), pipeline, pipelineReportHandler, true, eventQueue);
        Assert.assertEquals((Object)Pipeline.PipelineState.OPEN, (Object)pipelineManager.getPipeline(pipeline.getId()).getPipelineState());
        pipelineManager.close();
    }

    @Test
    public void testScrubPipeline() throws IOException {
        conf.setTimeDuration("ozone.scm.pipeline.allocated.timeout", -1L, TimeUnit.MILLISECONDS);
        EventQueue eventQueue = new EventQueue();
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        pipelineManager.allowPipelineCreation();
        MockRatisPipelineProvider ratisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf, (EventPublisher)eventQueue, false);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)ratisProvider);
        Pipeline pipeline = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        Assert.assertEquals((Object)Pipeline.PipelineState.ALLOCATED, (Object)pipeline.getPipelineState());
        Assert.assertTrue((boolean)pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.ALLOCATED).contains(pipeline));
        pipelineManager.scrubPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
        Assert.assertFalse((boolean)pipelineManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.ALLOCATED).contains(pipeline));
        pipelineManager.close();
    }

    @Test
    public void testPipelineNotCreatedUntilSafeModePrecheck() throws IOException, TimeoutException, InterruptedException {
        Pipeline pipeline2;
        conf.setTimeDuration("ozone.scm.pipeline.allocated.timeout", -1L, TimeUnit.MILLISECONDS);
        EventQueue eventQueue = new EventQueue();
        final SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        MockRatisPipelineProvider ratisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf, (EventPublisher)eventQueue, false);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)ratisProvider);
        try {
            pipeline2 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE);
            Assert.fail((String)"Pipelines should not have been created");
        }
        catch (IOException pipeline2) {
            // empty catch block
        }
        pipeline2 = pipelineManager.createPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE);
        pipelineManager.onMessage(new SCMSafeModeManager.SafeModeStatus(true, true), null);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return pipelineManager.getPipelines().size() != 0;
            }
        }, (int)100, (int)10000);
        pipelineManager.close();
    }

    @Test
    public void testSafeModeUpdatedOnSafemodeExit() throws IOException, TimeoutException, InterruptedException {
        conf.setTimeDuration("ozone.scm.pipeline.allocated.timeout", -1L, TimeUnit.MILLISECONDS);
        EventQueue eventQueue = new EventQueue();
        SCMPipelineManager pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, scmMetadataStore.getPipelineTable(), (EventPublisher)eventQueue);
        MockRatisPipelineProvider ratisProvider = new MockRatisPipelineProvider(nodeManager, pipelineManager.getStateManager(), (ConfigurationSource)conf, (EventPublisher)eventQueue, false);
        pipelineManager.setPipelineProvider(HddsProtos.ReplicationType.RATIS, (PipelineProvider)ratisProvider);
        Assert.assertEquals((Object)true, (Object)pipelineManager.getSafeModeStatus());
        Assert.assertEquals((Object)false, (Object)pipelineManager.isPipelineCreationAllowed());
        pipelineManager.onMessage(new SCMSafeModeManager.SafeModeStatus(true, true), null);
        Assert.assertEquals((Object)true, (Object)pipelineManager.getSafeModeStatus());
        Assert.assertEquals((Object)true, (Object)pipelineManager.isPipelineCreationAllowed());
        pipelineManager.onMessage(new SCMSafeModeManager.SafeModeStatus(false, true), null);
        Assert.assertEquals((Object)false, (Object)pipelineManager.getSafeModeStatus());
        Assert.assertEquals((Object)true, (Object)pipelineManager.isPipelineCreationAllowed());
        pipelineManager.close();
    }

    @Test
    public void testPipelineDBKeyFormatChange() throws Exception {
        Pipeline p1 = this.pipelineStub();
        Pipeline p2 = this.pipelineStub();
        Pipeline p3 = this.pipelineStub();
        TableIterator iteratorMock = (TableIterator)Mockito.mock(TableIterator.class);
        Table.KeyValue<PipelineID, Pipeline> kv1 = this.mockKeyValueToProvideOldKeyFormat(p1);
        Table.KeyValue<PipelineID, Pipeline> kv2 = this.mockKeyValueToProvideNormalFormat(p2);
        Table.KeyValue<PipelineID, Pipeline> kv3 = this.mockKeyValueToProvideOldKeyFormat(p3);
        Mockito.when((Object)iteratorMock.next()).thenReturn(kv1, (Object[])new Table.KeyValue[]{kv2, kv3}).thenThrow(new Throwable[]{new NoSuchElementException()});
        Mockito.when((Object)iteratorMock.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Table pipelineStore = (Table)Mockito.mock(Table.class);
        ((Table)Mockito.doReturn((Object)iteratorMock).when((Object)pipelineStore)).iterator();
        Mockito.when((Object)pipelineStore.isEmpty()).thenReturn((Object)false);
        InOrder inorderVerifier = Mockito.inOrder((Object[])new Object[]{pipelineStore, iteratorMock});
        new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, pipelineStore, (EventPublisher)new EventQueue());
        ((TableIterator)inorderVerifier.verify((Object)iteratorMock)).removeFromDB();
        ((Table)inorderVerifier.verify((Object)pipelineStore)).put((Object)p1.getId(), (Object)p1);
        ((TableIterator)inorderVerifier.verify((Object)iteratorMock)).removeFromDB();
        ((Table)inorderVerifier.verify((Object)pipelineStore)).put((Object)p3.getId(), (Object)p3);
        ((Table)Mockito.verify((Object)pipelineStore, (VerificationMode)Mockito.never())).put((Object)p2.getId(), (Object)p2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScmWithPipelineDBKeyFormatChange() throws Exception {
        SCMPipelineManager pipelineManager;
        TemporaryFolder tempDir = new TemporaryFolder();
        tempDir.create();
        File dir = tempDir.newFolder();
        conf.set("ozone.metadata.dirs", dir.getAbsolutePath());
        TestSCMStoreImplWithOldPipelineIDKeyFormat scmDbWithOldKeyFormat = null;
        HashMap<UUID, Pipeline> oldPipelines = new HashMap<UUID, Pipeline>();
        try {
            scmDbWithOldKeyFormat = new TestSCMStoreImplWithOldPipelineIDKeyFormat(conf);
            for (int i = 0; i < 3; ++i) {
                Pipeline pipeline = this.pipelineStub();
                scmDbWithOldKeyFormat.getPipelineTable().put((Object)pipeline.getId(), (Object)pipeline);
                oldPipelines.put(pipeline.getId().getId(), pipeline);
            }
        }
        finally {
            if (scmDbWithOldKeyFormat != null) {
                scmDbWithOldKeyFormat.stop();
            }
        }
        GenericTestUtils.LogCapturer logCapturer = GenericTestUtils.LogCapturer.captureLogs((Logger)SCMPipelineManager.getLog());
        SCMMetadataStoreImpl newScmMetadataStore = null;
        try {
            newScmMetadataStore = new SCMMetadataStoreImpl(conf);
            pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, newScmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
            TestSCMPipelineManager.waitForLog(logCapturer);
            Assert.assertEquals((long)3L, (long)pipelineManager.getPipelines().size());
            oldPipelines.values().forEach(p -> pipelineManager.containsPipeline(p.getId()));
        }
        finally {
            newScmMetadataStore.stop();
        }
        try {
            logCapturer.clearOutput();
            newScmMetadataStore = new SCMMetadataStoreImpl(conf);
            pipelineManager = new SCMPipelineManager((ConfigurationSource)conf, (NodeManager)nodeManager, newScmMetadataStore.getPipelineTable(), (EventPublisher)new EventQueue());
            try {
                TestSCMPipelineManager.waitForLog(logCapturer);
                Assert.fail((String)("Unexpected log: " + logCapturer.getOutput()));
            }
            catch (TimeoutException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("Timed out"));
            }
            Assert.assertEquals((long)3L, (long)pipelineManager.getPipelines().size());
            oldPipelines.values().forEach(p -> pipelineManager.containsPipeline(p.getId()));
        }
        finally {
            newScmMetadataStore.stop();
        }
    }

    private static void waitForLog(GenericTestUtils.LogCapturer logCapturer) throws TimeoutException, InterruptedException {
        GenericTestUtils.waitFor(() -> logCapturer.getOutput().contains("Found pipeline in old format key"), (int)1000, (int)5000);
    }

    private Pipeline pipelineStub() {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setType(HddsProtos.ReplicationType.RATIS).setFactor(HddsProtos.ReplicationFactor.ONE).setState(Pipeline.PipelineState.OPEN).setNodes(Arrays.asList(nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).get(0))).setNodesInOrder(Arrays.asList(0)).build();
    }

    private Table.KeyValue<PipelineID, Pipeline> mockKeyValueToProvideOldKeyFormat(Pipeline pipeline) throws IOException {
        Table.KeyValue kv = (Table.KeyValue)Mockito.mock(Table.KeyValue.class);
        Mockito.when((Object)kv.getValue()).thenReturn((Object)pipeline);
        Mockito.when((Object)kv.getKey()).thenReturn((Object)new PipelineIDCodec().fromPersistedFormat(pipeline.getId().getProtobuf().toByteArray()));
        return kv;
    }

    private Table.KeyValue<PipelineID, Pipeline> mockKeyValueToProvideNormalFormat(Pipeline pipeline) throws IOException {
        Table.KeyValue kv = (Table.KeyValue)Mockito.mock(Table.KeyValue.class);
        Mockito.when((Object)kv.getValue()).thenReturn((Object)pipeline);
        Mockito.when((Object)kv.getKey()).thenReturn((Object)pipeline.getId());
        return kv;
    }

    private void sendPipelineReport(DatanodeDetails dn, Pipeline pipeline, PipelineReportHandler pipelineReportHandler, boolean isLeader, EventQueue eventQueue) {
        SCMDatanodeHeartbeatDispatcher.PipelineReportFromDatanode report = TestUtils.getPipelineReportFromDatanode(dn, pipeline.getId(), isLeader);
        pipelineReportHandler.onMessage(report, (EventPublisher)eventQueue);
    }
}

