/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestRatisPipelineProvider {
    private static final HddsProtos.ReplicationType REPLICATION_TYPE = HddsProtos.ReplicationType.RATIS;
    private NodeManager nodeManager;
    private PipelineProvider provider;
    private PipelineStateManager stateManager;
    private OzoneConfiguration conf;

    public void init(int maxPipelinePerNode) throws Exception {
        this.nodeManager = new MockNodeManager(true, 10);
        this.conf = new OzoneConfiguration();
        this.conf.setInt("ozone.datanode.pipeline.limit", maxPipelinePerNode);
        this.stateManager = new PipelineStateManager();
        this.provider = new MockRatisPipelineProvider(this.nodeManager, this.stateManager, (ConfigurationSource)this.conf);
    }

    private void createPipelineAndAssertions(HddsProtos.ReplicationFactor factor) throws IOException {
        Pipeline pipeline = this.provider.create(factor);
        TestRatisPipelineProvider.assertPipelineProperties(pipeline, factor, REPLICATION_TYPE, Pipeline.PipelineState.ALLOCATED);
        this.stateManager.addPipeline(pipeline);
        this.nodeManager.addPipeline(pipeline);
        Pipeline pipeline1 = this.provider.create(factor);
        TestRatisPipelineProvider.assertPipelineProperties(pipeline1, factor, REPLICATION_TYPE, Pipeline.PipelineState.ALLOCATED);
        Assert.assertTrue((CollectionUtils.intersection((Collection)pipeline.getNodes(), (Collection)pipeline1.getNodes()).size() < factor.getNumber() ? 1 : 0) != 0);
        if (pipeline.getFactor() == HddsProtos.ReplicationFactor.THREE) {
            Assert.assertNotEquals((Object)pipeline.getNodeSet(), (Object)pipeline1.getNodeSet());
        }
        this.stateManager.addPipeline(pipeline1);
        this.nodeManager.addPipeline(pipeline1);
    }

    @Test
    public void testCreatePipelineWithFactor() throws Exception {
        this.init(1);
        HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.THREE;
        Pipeline pipeline = this.provider.create(factor);
        TestRatisPipelineProvider.assertPipelineProperties(pipeline, factor, REPLICATION_TYPE, Pipeline.PipelineState.ALLOCATED);
        this.stateManager.addPipeline(pipeline);
        factor = HddsProtos.ReplicationFactor.ONE;
        Pipeline pipeline1 = this.provider.create(factor);
        TestRatisPipelineProvider.assertPipelineProperties(pipeline1, factor, REPLICATION_TYPE, Pipeline.PipelineState.ALLOCATED);
        this.stateManager.addPipeline(pipeline1);
        Assert.assertNotEquals((Object)pipeline.getNodeSet(), (Object)pipeline1.getNodeSet());
    }

    @Test
    public void testCreatePipelineWithFactorThree() throws Exception {
        this.init(1);
        this.createPipelineAndAssertions(HddsProtos.ReplicationFactor.THREE);
    }

    @Test
    public void testCreatePipelineWithFactorOne() throws Exception {
        this.init(1);
        this.createPipelineAndAssertions(HddsProtos.ReplicationFactor.ONE);
    }

    private List<DatanodeDetails> createListOfNodes(int nodeCount) {
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < nodeCount; ++i) {
            nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        return nodes;
    }

    @Test
    public void testCreatePipelineWithNodes() throws Exception {
        this.init(1);
        HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.THREE;
        Pipeline pipeline = this.provider.create(factor, this.createListOfNodes(factor.getNumber()));
        TestRatisPipelineProvider.assertPipelineProperties(pipeline, factor, REPLICATION_TYPE, Pipeline.PipelineState.OPEN);
        factor = HddsProtos.ReplicationFactor.ONE;
        pipeline = this.provider.create(factor, this.createListOfNodes(factor.getNumber()));
        TestRatisPipelineProvider.assertPipelineProperties(pipeline, factor, REPLICATION_TYPE, Pipeline.PipelineState.OPEN);
    }

    @Test
    public void testCreateFactorTHREEPipelineWithSameDatanodes() throws Exception {
        this.init(2);
        List healthyNodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY).stream().limit(3L).collect(Collectors.toList());
        Pipeline pipeline1 = this.provider.create(HddsProtos.ReplicationFactor.THREE, healthyNodes);
        Pipeline pipeline2 = this.provider.create(HddsProtos.ReplicationFactor.THREE, healthyNodes);
        Assert.assertEquals((Object)pipeline1.getNodeSet(), (Object)pipeline2.getNodeSet());
    }

    @Test
    public void testCreatePipelinesDnExclude() throws Exception {
        int maxPipelinePerNode = 2;
        this.init(maxPipelinePerNode);
        List healthyNodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
        Assume.assumeTrue((healthyNodes.size() == 8 ? 1 : 0) != 0);
        HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.THREE;
        List<Object> dns = healthyNodes.subList(0, 3);
        for (int i = 0; i < maxPipelinePerNode; ++i) {
            this.addPipeline(dns, factor, Pipeline.PipelineState.OPEN, REPLICATION_TYPE);
        }
        HashSet membersOfOpenPipelines = new HashSet(dns);
        dns = healthyNodes.subList(3, 6);
        this.addPipeline(dns, factor, Pipeline.PipelineState.CLOSED, REPLICATION_TYPE);
        HashSet<DatanodeDetails> membersOfClosedPipelines = new HashSet<DatanodeDetails>(dns);
        Pipeline pipeline = this.provider.create(factor);
        TestRatisPipelineProvider.assertPipelineProperties(pipeline, factor, REPLICATION_TYPE, Pipeline.PipelineState.ALLOCATED);
        this.nodeManager.addPipeline(pipeline);
        this.stateManager.addPipeline(pipeline);
        List nodes = pipeline.getNodes();
        Assert.assertTrue((String)"nodes of new pipeline cannot be all from open pipelines", (boolean)nodes.stream().noneMatch(membersOfOpenPipelines::contains));
        Assert.assertTrue((String)"at least 1 node should have been from members of closed pipelines", (boolean)nodes.stream().anyMatch(membersOfClosedPipelines::contains));
    }

    private static void assertPipelineProperties(Pipeline pipeline, HddsProtos.ReplicationFactor expectedFactor, HddsProtos.ReplicationType expectedReplicationType, Pipeline.PipelineState expectedState) {
        Assert.assertEquals((Object)expectedState, (Object)pipeline.getPipelineState());
        Assert.assertEquals((Object)expectedReplicationType, (Object)pipeline.getType());
        Assert.assertEquals((Object)expectedFactor, (Object)pipeline.getFactor());
        Assert.assertEquals((long)expectedFactor.getNumber(), (long)pipeline.getNodes().size());
    }

    private void addPipeline(List<DatanodeDetails> dns, HddsProtos.ReplicationFactor factor, Pipeline.PipelineState open, HddsProtos.ReplicationType replicationType) throws IOException {
        Pipeline openPipeline = Pipeline.newBuilder().setType(replicationType).setFactor(factor).setNodes(dns).setState(open).setId(PipelineID.randomId()).build();
        this.stateManager.addPipeline(openPipeline);
        this.nodeManager.addPipeline(openPipeline);
    }
}

