/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPipelineStateManager {
    private PipelineStateManager stateManager;

    @Before
    public void init() throws Exception {
        this.stateManager = new PipelineStateManager();
    }

    private Pipeline createDummyPipeline(int numNodes) {
        return this.createDummyPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.ONE, numNodes);
    }

    private Pipeline createDummyPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, int numNodes) {
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        return Pipeline.newBuilder().setType(type).setFactor(factor).setNodes(nodes).setState(Pipeline.PipelineState.ALLOCATED).setId(PipelineID.randomId()).build();
    }

    @Test
    public void testAddAndGetPipeline() throws IOException {
        Pipeline pipeline = this.createDummyPipeline(0);
        try {
            this.stateManager.addPipeline(pipeline);
            Assert.fail((String)"Pipeline should not have been added");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("do not match"));
        }
        pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        try {
            this.stateManager.addPipeline(pipeline);
            Assert.fail((String)"Pipeline should not have been added");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Duplicate pipeline ID"));
        }
        Pipeline pipeline1 = this.stateManager.getPipeline(pipeline.getId());
        Assert.assertTrue((pipeline == pipeline1 ? 1 : 0) != 0);
        this.removePipeline(pipeline);
    }

    @Test
    public void testGetPipelines() throws IOException {
        Assert.assertTrue((boolean)this.stateManager.getPipelines().isEmpty());
        HashSet<Pipeline> pipelines = new HashSet<Pipeline>();
        Pipeline pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        pipelines.add(pipeline);
        pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        pipelines.add(pipeline);
        HashSet pipelines1 = new HashSet(this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS));
        Assert.assertEquals((long)pipelines1.size(), (long)pipelines.size());
        pipelines1 = new HashSet(this.stateManager.getPipelines());
        Assert.assertEquals((long)pipelines1.size(), (long)pipelines.size());
        for (Pipeline pipeline1 : pipelines) {
            this.removePipeline(pipeline1);
        }
    }

    @Test
    public void testGetPipelinesByTypeAndFactor() throws IOException {
        HashSet<Pipeline> pipelines = new HashSet<Pipeline>();
        for (HddsProtos.ReplicationType type : HddsProtos.ReplicationType.values()) {
            for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
                for (int i = 0; i < 5; ++i) {
                    Pipeline pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    pipelines.add(pipeline);
                    pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    this.stateManager.openPipeline(pipeline.getId());
                    pipelines.add(pipeline);
                    pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    this.stateManager.finalizePipeline(pipeline.getId());
                    pipelines.add(pipeline);
                }
            }
        }
        for (HddsProtos.ReplicationType type : HddsProtos.ReplicationType.values()) {
            for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
                List pipelines1 = this.stateManager.getPipelines(type, factor);
                Assert.assertEquals((long)15L, (long)pipelines1.size());
                pipelines1.stream().forEach(p -> {
                    Assert.assertEquals((Object)type, (Object)p.getType());
                    Assert.assertEquals((Object)factor, (Object)p.getFactor());
                });
            }
        }
        for (Pipeline pipeline : pipelines) {
            this.removePipeline(pipeline);
        }
    }

    @Test
    public void testGetPipelinesByTypeAndState() throws IOException {
        HashSet<Pipeline> pipelines = new HashSet<Pipeline>();
        for (HddsProtos.ReplicationType type : HddsProtos.ReplicationType.values()) {
            HddsProtos.ReplicationFactor factor = HddsProtos.ReplicationFactor.THREE;
            for (int i = 0; i < 5; ++i) {
                Pipeline pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                this.stateManager.addPipeline(pipeline);
                pipelines.add(pipeline);
                pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                this.stateManager.addPipeline(pipeline);
                this.stateManager.openPipeline(pipeline.getId());
                pipelines.add(pipeline);
                pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                this.stateManager.addPipeline(pipeline);
                this.stateManager.finalizePipeline(pipeline.getId());
                pipelines.add(pipeline);
            }
        }
        for (HddsProtos.ReplicationType type : HddsProtos.ReplicationType.values()) {
            List pipelines1 = this.stateManager.getPipelines(type, new Pipeline.PipelineState[]{Pipeline.PipelineState.OPEN});
            Assert.assertEquals((long)5L, (long)pipelines1.size());
            pipelines1.forEach(p -> {
                Assert.assertEquals((Object)type, (Object)p.getType());
                Assert.assertEquals((Object)Pipeline.PipelineState.OPEN, (Object)p.getPipelineState());
            });
            pipelines1 = this.stateManager.getPipelines(type, new Pipeline.PipelineState[]{Pipeline.PipelineState.OPEN, Pipeline.PipelineState.CLOSED, Pipeline.PipelineState.ALLOCATED});
            Assert.assertEquals((long)15L, (long)pipelines1.size());
        }
        for (Pipeline pipeline : pipelines) {
            this.removePipeline(pipeline);
        }
    }

    @Test
    public void testGetPipelinesByTypeFactorAndState() throws IOException {
        HashSet<Pipeline> pipelines = new HashSet<Pipeline>();
        for (HddsProtos.ReplicationType type : HddsProtos.ReplicationType.values()) {
            for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
                for (int i = 0; i < 5; ++i) {
                    Pipeline pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    pipelines.add(pipeline);
                    pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    this.stateManager.openPipeline(pipeline.getId());
                    pipelines.add(pipeline);
                    pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    this.stateManager.openPipeline(pipeline.getId());
                    this.stateManager.deactivatePipeline(pipeline.getId());
                    pipelines.add(pipeline);
                    pipeline = this.createDummyPipeline(type, factor, factor.getNumber());
                    this.stateManager.addPipeline(pipeline);
                    this.stateManager.finalizePipeline(pipeline.getId());
                    pipelines.add(pipeline);
                }
            }
        }
        for (HddsProtos.ReplicationType type : HddsProtos.ReplicationType.values()) {
            for (HddsProtos.ReplicationFactor factor : HddsProtos.ReplicationFactor.values()) {
                for (Pipeline.PipelineState state : Pipeline.PipelineState.values()) {
                    List pipelines1 = this.stateManager.getPipelines(type, factor, state);
                    Assert.assertEquals((long)5L, (long)pipelines1.size());
                    pipelines1.forEach(p -> {
                        Assert.assertEquals((Object)type, (Object)p.getType());
                        Assert.assertEquals((Object)factor, (Object)p.getFactor());
                        Assert.assertEquals((Object)state, (Object)p.getPipelineState());
                    });
                }
            }
        }
        for (Pipeline pipeline : pipelines) {
            this.removePipeline(pipeline);
        }
    }

    @Test
    public void testAddAndGetContainer() throws IOException {
        long containerID = 0L;
        Pipeline pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        pipeline = this.stateManager.getPipeline(pipeline.getId());
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)(++containerID)));
        this.stateManager.openPipeline(pipeline.getId());
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)(++containerID)));
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)(++containerID)));
        NavigableSet containerIDs = this.stateManager.getContainers(pipeline.getId());
        Assert.assertEquals((long)containerIDs.size(), (long)containerID);
        this.removePipeline(pipeline);
        try {
            this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)(++containerID)));
            Assert.fail((String)"Container should not have been added");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not found"));
        }
    }

    @Test
    public void testRemovePipeline() throws IOException {
        Pipeline pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)1L));
        try {
            this.stateManager.removePipeline(pipeline.getId());
            Assert.fail((String)"Pipeline should not have been removed");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("not yet closed"));
        }
        this.stateManager.finalizePipeline(pipeline.getId());
        this.removePipeline(pipeline);
    }

    @Test
    public void testRemoveContainer() throws IOException {
        long containerID = 1L;
        Pipeline pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)containerID));
        Assert.assertEquals((long)1L, (long)this.stateManager.getContainers(pipeline.getId()).size());
        this.stateManager.removeContainerFromPipeline(pipeline.getId(), ContainerID.valueof((long)containerID));
        Assert.assertEquals((long)0L, (long)this.stateManager.getContainers(pipeline.getId()).size());
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)(++containerID)));
        this.stateManager.addContainerToPipeline(pipeline.getId(), ContainerID.valueof((long)(++containerID)));
        Assert.assertEquals((long)2L, (long)this.stateManager.getContainers(pipeline.getId()).size());
        this.stateManager.finalizePipeline(pipeline.getId());
        this.stateManager.removeContainerFromPipeline(pipeline.getId(), ContainerID.valueof((long)containerID));
        this.stateManager.removeContainerFromPipeline(pipeline.getId(), ContainerID.valueof((long)(--containerID)));
        Assert.assertEquals((long)0L, (long)this.stateManager.getContainers(pipeline.getId()).size());
        this.stateManager.removePipeline(pipeline.getId());
    }

    @Test
    public void testFinalizePipeline() throws IOException {
        Pipeline pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.finalizePipeline(pipeline.getId());
        Assert.assertEquals((Object)Pipeline.PipelineState.CLOSED, (Object)this.stateManager.getPipeline(pipeline.getId()).getPipelineState());
        this.removePipeline(pipeline);
        pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        this.stateManager.finalizePipeline(pipeline.getId());
        Assert.assertEquals((Object)Pipeline.PipelineState.CLOSED, (Object)this.stateManager.getPipeline(pipeline.getId()).getPipelineState());
        this.removePipeline(pipeline);
        pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        this.stateManager.finalizePipeline(pipeline.getId());
        this.stateManager.finalizePipeline(pipeline.getId());
        Assert.assertEquals((Object)Pipeline.PipelineState.CLOSED, (Object)this.stateManager.getPipeline(pipeline.getId()).getPipelineState());
        this.removePipeline(pipeline);
    }

    @Test
    public void testOpenPipeline() throws IOException {
        Pipeline pipeline = this.createDummyPipeline(1);
        this.stateManager.addPipeline(pipeline);
        this.stateManager.openPipeline(pipeline.getId());
        Assert.assertEquals((Object)Pipeline.PipelineState.OPEN, (Object)this.stateManager.getPipeline(pipeline.getId()).getPipelineState());
        this.stateManager.openPipeline(pipeline.getId());
        Assert.assertEquals((Object)Pipeline.PipelineState.OPEN, (Object)this.stateManager.getPipeline(pipeline.getId()).getPipelineState());
        this.removePipeline(pipeline);
    }

    @Test
    public void testQueryPipeline() throws IOException {
        Pipeline pipeline = this.createDummyPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, 3);
        this.stateManager.addPipeline(pipeline);
        Assert.assertEquals((long)0L, (long)this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).size());
        this.stateManager.openPipeline(pipeline.getId());
        Assert.assertEquals((long)1L, (long)this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).size());
        Pipeline pipeline2 = this.createDummyPipeline(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, 3);
        pipeline2 = Pipeline.newBuilder((Pipeline)pipeline2).setState(Pipeline.PipelineState.OPEN).build();
        this.stateManager.addPipeline(pipeline2);
        Assert.assertEquals((long)2L, (long)this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).size());
        this.stateManager.finalizePipeline(pipeline2.getId());
        Assert.assertEquals((long)1L, (long)this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE, Pipeline.PipelineState.OPEN).size());
        this.removePipeline(pipeline);
        this.removePipeline(pipeline2);
    }

    private void removePipeline(Pipeline pipeline) throws IOException {
        this.stateManager.finalizePipeline(pipeline.getId());
        this.stateManager.removePipeline(pipeline.getId());
    }
}

