/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.hdds.scm.net.NodeImpl;
import org.apache.hadoop.hdds.scm.net.NodeSchema;
import org.apache.hadoop.hdds.scm.net.NodeSchemaManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.Node2PipelineMap;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelinePlacementPolicy;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPipelinePlacementPolicy {
    private MockNodeManager nodeManager;
    private PipelineStateManager stateManager;
    private OzoneConfiguration conf;
    private PipelinePlacementPolicy placementPolicy;
    private NetworkTopologyImpl cluster;
    private static final int PIPELINE_PLACEMENT_MAX_NODES_COUNT = 10;
    private static final int PIPELINE_LOAD_LIMIT = 5;
    private List<DatanodeDetails> nodesWithOutRackAwareness = new ArrayList<DatanodeDetails>();
    private List<DatanodeDetails> nodesWithRackAwareness = new ArrayList<DatanodeDetails>();
    static final Logger LOG = LoggerFactory.getLogger(TestPipelinePlacementPolicy.class);
    private static final Node[] NODES = new NodeImpl[]{new NodeImpl("h1", "/r1", 0), new NodeImpl("h2", "/r1", 0), new NodeImpl("h3", "/r2", 0), new NodeImpl("h4", "/r2", 0), new NodeImpl("h5", "/r3", 0), new NodeImpl("h6", "/r3", 0), new NodeImpl("h7", "/r4", 0), new NodeImpl("h8", "/r4", 0)};
    private static final Node[] SINGLE_NODE_RACK = new NodeImpl[]{new NodeImpl("h1", "/r1", 0), new NodeImpl("h2", "/r2", 0), new NodeImpl("h3", "/r3", 0)};

    @Before
    public void init() throws Exception {
        this.cluster = this.initTopology();
        this.nodeManager = new MockNodeManager(this.cluster, this.getNodesWithRackAwareness(), false, 10);
        this.conf = new OzoneConfiguration();
        this.conf.setInt("ozone.datanode.pipeline.limit", 5);
        this.stateManager = new PipelineStateManager();
        this.placementPolicy = new PipelinePlacementPolicy((NodeManager)this.nodeManager, this.stateManager, (ConfigurationSource)this.conf);
    }

    private NetworkTopologyImpl initTopology() {
        NodeSchema[] schemas = new NodeSchema[]{NetConstants.ROOT_SCHEMA, NetConstants.RACK_SCHEMA, NetConstants.LEAF_SCHEMA};
        NodeSchemaManager.getInstance().init(schemas, true);
        NetworkTopologyImpl topology = new NetworkTopologyImpl(NodeSchemaManager.getInstance());
        return topology;
    }

    private List<DatanodeDetails> getNodesWithRackAwareness() {
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        int delimiter = NODES.length;
        for (int iter = 0; iter < 10; ++iter) {
            DatanodeDetails datanode = this.overwriteLocationInNode(this.getNodesWithoutRackAwareness(), NODES[iter % delimiter]);
            this.nodesWithRackAwareness.add(datanode);
            datanodes.add(datanode);
        }
        return datanodes;
    }

    private DatanodeDetails getNodesWithoutRackAwareness() {
        DatanodeDetails node = MockDatanodeDetails.randomDatanodeDetails();
        this.nodesWithOutRackAwareness.add(node);
        return node;
    }

    @Test
    public void testChooseNodeBasedOnNetworkTopology() {
        DatanodeDetails anchor = this.placementPolicy.chooseNode(this.nodesWithRackAwareness);
        Assert.assertFalse((boolean)this.nodesWithRackAwareness.contains(anchor));
        ArrayList<DatanodeDetails> excludedNodes = new ArrayList<DatanodeDetails>(10);
        excludedNodes.add(anchor);
        DatanodeDetails nextNode = this.placementPolicy.chooseNodeBasedOnSameRack(this.nodesWithRackAwareness, excludedNodes, this.nodeManager.getClusterNetworkTopologyMap(), anchor);
        Assert.assertFalse((boolean)excludedNodes.contains(nextNode));
        Assert.assertTrue((anchor.getUuid() != nextNode.getUuid() ? 1 : 0) != 0);
        Assert.assertEquals((Object)anchor.getNetworkLocation(), (Object)nextNode.getNetworkLocation());
    }

    @Test
    public void testChooseNodeWithSingleNodeRack() throws SCMException {
        ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
        for (Node node : SINGLE_NODE_RACK) {
            DatanodeDetails datanode = this.overwriteLocationInNode(MockDatanodeDetails.randomDatanodeDetails(), node);
            datanodes.add(datanode);
        }
        MockNodeManager localNodeManager = new MockNodeManager(this.initTopology(), datanodes, false, datanodes.size());
        PipelinePlacementPolicy localPlacementPolicy = new PipelinePlacementPolicy((NodeManager)localNodeManager, new PipelineStateManager(), (ConfigurationSource)this.conf);
        int nodesRequired = HddsProtos.ReplicationFactor.THREE.getNumber();
        List results = localPlacementPolicy.chooseDatanodes(new ArrayList(datanodes.size()), new ArrayList(datanodes.size()), nodesRequired, 0L);
        Assert.assertEquals((long)nodesRequired, (long)results.size());
        Assert.assertNotEquals((Object)((DatanodeDetails)results.get(0)).getNetworkLocation(), (Object)((DatanodeDetails)results.get(1)).getNetworkLocation());
        Assert.assertNotEquals((Object)((DatanodeDetails)results.get(0)).getNetworkLocation(), (Object)((DatanodeDetails)results.get(2)).getNetworkLocation());
        Assert.assertNotEquals((Object)((DatanodeDetails)results.get(1)).getNetworkLocation(), (Object)((DatanodeDetails)results.get(2)).getNetworkLocation());
    }

    @Test
    public void testPickLowestLoadAnchor() throws IOException {
        List<DatanodeDetails> healthyNodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
        int maxPipelineCount = 5 * healthyNodes.size() / HddsProtos.ReplicationFactor.THREE.getNumber();
        for (int i = 0; i < maxPipelineCount; ++i) {
            try {
                List nodes = this.placementPolicy.chooseDatanodes(null, null, HddsProtos.ReplicationFactor.THREE.getNumber(), 0L);
                Pipeline pipeline = Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.ALLOCATED).setType(HddsProtos.ReplicationType.RATIS).setFactor(HddsProtos.ReplicationFactor.THREE).setNodes(nodes).build();
                this.nodeManager.addPipeline(pipeline);
                this.stateManager.addPipeline(pipeline);
                continue;
            }
            catch (SCMException e) {
                break;
            }
        }
        int averageLoadOnNode = maxPipelineCount * HddsProtos.ReplicationFactor.THREE.getNumber() / healthyNodes.size();
        for (DatanodeDetails node : healthyNodes) {
            Assert.assertTrue((this.nodeManager.getPipelinesCount(node) >= averageLoadOnNode ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)maxPipelineCount, (long)this.stateManager.getPipelines(HddsProtos.ReplicationType.RATIS).size());
    }

    @Test
    public void testChooseNodeBasedOnRackAwareness() {
        List<DatanodeDetails> healthyNodes = this.overWriteLocationInNodes(this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY));
        DatanodeDetails anchor = this.placementPolicy.chooseNode(healthyNodes);
        NetworkTopology topologyWithDifRacks = this.createNetworkTopologyOnDifRacks();
        DatanodeDetails nextNode = this.placementPolicy.chooseNodeBasedOnRackAwareness(healthyNodes, new ArrayList(10), topologyWithDifRacks, anchor);
        Assert.assertNotNull((Object)nextNode);
        Assert.assertNotEquals((Object)anchor.getNetworkLocation(), (Object)nextNode.getNetworkLocation());
    }

    @Test
    public void testFallBackPickNodes() {
        DatanodeDetails node;
        List<DatanodeDetails> healthyNodes = this.overWriteLocationInNodes(this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY));
        try {
            node = this.placementPolicy.fallBackPickNodes(healthyNodes, null);
            Assert.assertNotNull((Object)node);
        }
        catch (SCMException e) {
            Assert.fail((String)"Should not reach here.");
        }
        List<DatanodeDetails> exclude = healthyNodes;
        try {
            node = this.placementPolicy.fallBackPickNodes(healthyNodes, exclude);
            Assert.assertNull((Object)node);
        }
        catch (SCMException e) {
            Assert.assertEquals((Object)SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE, (Object)e.getResult());
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not reach here.");
        }
    }

    @Test
    public void testRackAwarenessNotEnabledWithFallBack() throws SCMException {
        DatanodeDetails anchor = this.placementPolicy.chooseNode(this.nodesWithOutRackAwareness);
        DatanodeDetails randomNode = this.placementPolicy.chooseNode(this.nodesWithOutRackAwareness);
        Assert.assertTrue((boolean)anchor.getNetworkLocation().equals(randomNode.getNetworkLocation()));
        NetworkTopologyImpl topology = new NetworkTopologyImpl((ConfigurationSource)new OzoneConfiguration());
        DatanodeDetails nextNode = this.placementPolicy.chooseNodeBasedOnRackAwareness(this.nodesWithOutRackAwareness, new ArrayList(10), (NetworkTopology)topology, anchor);
        Assert.assertNull((Object)nextNode);
        int numOfNodes = HddsProtos.ReplicationFactor.THREE.getNumber();
        List results = this.placementPolicy.getResultSet(numOfNodes, this.nodesWithOutRackAwareness);
        Assert.assertEquals((long)numOfNodes, (long)results.size());
        Assert.assertEquals((Object)((DatanodeDetails)results.get(0)).getNetworkLocation(), (Object)((DatanodeDetails)results.get(1)).getNetworkLocation());
        Assert.assertEquals((Object)((DatanodeDetails)results.get(0)).getNetworkLocation(), (Object)((DatanodeDetails)results.get(2)).getNetworkLocation());
    }

    private NetworkTopology createNetworkTopologyOnDifRacks() {
        NetworkTopologyImpl topology = new NetworkTopologyImpl((ConfigurationSource)new OzoneConfiguration());
        for (Node n : NODES) {
            topology.add(n);
        }
        return topology;
    }

    private DatanodeDetails overwriteLocationInNode(DatanodeDetails datanode, Node node) {
        DatanodeDetails result = DatanodeDetails.newBuilder().setUuid(datanode.getUuid()).setHostName(datanode.getHostName()).setIpAddress(datanode.getIpAddress()).addPort(datanode.getPort(DatanodeDetails.Port.Name.STANDALONE)).addPort(datanode.getPort(DatanodeDetails.Port.Name.RATIS)).addPort(datanode.getPort(DatanodeDetails.Port.Name.REST)).setNetworkLocation(node.getNetworkLocation()).build();
        return result;
    }

    private List<DatanodeDetails> overWriteLocationInNodes(List<DatanodeDetails> datanodes) {
        ArrayList<DatanodeDetails> results = new ArrayList<DatanodeDetails>(datanodes.size());
        for (int i = 0; i < datanodes.size(); ++i) {
            DatanodeDetails datanode = this.overwriteLocationInNode(datanodes.get(i), NODES[i]);
            results.add(datanode);
        }
        return results;
    }

    @Test
    public void testHeavyNodeShouldBeExcluded() throws SCMException {
        List<DatanodeDetails> healthyNodes = this.nodeManager.getNodes(HddsProtos.NodeState.HEALTHY);
        int nodesRequired = HddsProtos.ReplicationFactor.THREE.getNumber();
        int minorityHeavy = healthyNodes.size() / 2 - 1;
        List pickedNodes1 = this.placementPolicy.chooseDatanodes(new ArrayList(10), new ArrayList(10), nodesRequired, 0L);
        this.insertHeavyNodesIntoNodeManager(healthyNodes, minorityHeavy);
        Assert.assertEquals((long)nodesRequired, (long)pickedNodes1.size());
        Assert.assertTrue((boolean)this.checkDuplicateNodesUUID(pickedNodes1));
        int majorityHeavy = healthyNodes.size() / 2 + 2;
        this.insertHeavyNodesIntoNodeManager(healthyNodes, majorityHeavy);
        boolean thrown = false;
        List pickedNodes2 = null;
        try {
            pickedNodes2 = this.placementPolicy.chooseDatanodes(new ArrayList(10), new ArrayList(10), nodesRequired, 0L);
        }
        catch (SCMException e) {
            Assert.assertFalse((boolean)thrown);
            thrown = true;
        }
        Assert.assertNull(pickedNodes2);
        Assert.assertTrue((boolean)thrown);
    }

    @Test
    public void testValidatePlacementPolicyOK() {
        this.cluster = this.initTopology();
        this.nodeManager = new MockNodeManager(this.cluster, this.getNodesWithRackAwareness(), false, 10);
        this.placementPolicy = new PipelinePlacementPolicy((NodeManager)this.nodeManager, this.stateManager, (ConfigurationSource)this.conf);
        ArrayList<DatanodeDetails> dns = new ArrayList<DatanodeDetails>();
        dns.add(MockDatanodeDetails.createDatanodeDetails((String)"host1", (String)"/rack1"));
        dns.add(MockDatanodeDetails.createDatanodeDetails((String)"host2", (String)"/rack1"));
        dns.add(MockDatanodeDetails.createDatanodeDetails((String)"host3", (String)"/rack2"));
        for (DatanodeDetails dn : dns) {
            this.cluster.add((Node)dn);
        }
        ContainerPlacementStatus status = this.placementPolicy.validateContainerPlacement(dns, 3);
        TestCase.assertTrue((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)status.misReplicationCount());
        ArrayList subSet = new ArrayList();
        subSet.add(dns.get(0));
        subSet.add(dns.get(2));
        status = this.placementPolicy.validateContainerPlacement(subSet, 3);
        TestCase.assertTrue((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)status.misReplicationCount());
        subSet = new ArrayList();
        subSet.add(dns.get(0));
        subSet.add(dns.get(1));
        status = this.placementPolicy.validateContainerPlacement(subSet, 3);
        Assert.assertFalse((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((int)1, (int)status.misReplicationCount());
        subSet = new ArrayList();
        subSet.add(dns.get(0));
        status = this.placementPolicy.validateContainerPlacement(subSet, 1);
        TestCase.assertTrue((boolean)status.isPolicySatisfied());
    }

    @Test
    public void testValidatePlacementPolicySingleRackInCluster() {
        this.cluster = this.initTopology();
        this.nodeManager = new MockNodeManager(this.cluster, new ArrayList<DatanodeDetails>(), false, 10);
        this.placementPolicy = new PipelinePlacementPolicy((NodeManager)this.nodeManager, this.stateManager, (ConfigurationSource)this.conf);
        ArrayList<DatanodeDetails> dns = new ArrayList<DatanodeDetails>();
        dns.add(MockDatanodeDetails.createDatanodeDetails((String)"host1", (String)"/rack1"));
        dns.add(MockDatanodeDetails.createDatanodeDetails((String)"host2", (String)"/rack1"));
        dns.add(MockDatanodeDetails.createDatanodeDetails((String)"host3", (String)"/rack1"));
        for (DatanodeDetails dn : dns) {
            this.cluster.add((Node)dn);
        }
        ContainerPlacementStatus status = this.placementPolicy.validateContainerPlacement(dns, 3);
        TestCase.assertTrue((boolean)status.isPolicySatisfied());
        TestCase.assertEquals((int)0, (int)status.misReplicationCount());
    }

    private boolean checkDuplicateNodesUUID(List<DatanodeDetails> nodes) {
        HashSet uuids = nodes.stream().map(DatanodeDetails::getUuid).collect(Collectors.toCollection(HashSet::new));
        return uuids.size() == nodes.size();
    }

    private Set<PipelineID> mockPipelineIDs(int count) {
        HashSet<PipelineID> pipelineIDs = new HashSet<PipelineID>(count);
        for (int i = 0; i < count; ++i) {
            pipelineIDs.add(PipelineID.randomId());
        }
        return pipelineIDs;
    }

    private void insertHeavyNodesIntoNodeManager(List<DatanodeDetails> nodes, int heavyNodeCount) throws SCMException {
        if (nodes == null) {
            throw new SCMException("", SCMException.ResultCodes.FAILED_TO_FIND_SUITABLE_NODE);
        }
        int considerHeavyCount = this.conf.getInt("ozone.datanode.pipeline.limit", 2) + 1;
        Node2PipelineMap mockMap = new Node2PipelineMap();
        for (DatanodeDetails node : nodes) {
            if (heavyNodeCount > 0) {
                mockMap.insertNewDatanode(node.getUuid(), this.mockPipelineIDs(considerHeavyCount));
                --heavyNodeCount;
                continue;
            }
            mockMap.insertNewDatanode(node.getUuid(), this.mockPipelineIDs(1));
        }
        this.nodeManager.setNode2PipelineMap(mockMap);
    }
}

