/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.MockNodeManager;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.pipeline.MockRatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestPipelineDatanodesIntersection {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestPipelineDatanodesIntersection.class.getName());
    private int nodeCount;
    private int nodeHeaviness;
    private OzoneConfiguration conf;
    private boolean end;

    @Before
    public void initialize() {
        this.conf = new OzoneConfiguration();
        this.end = false;
    }

    public TestPipelineDatanodesIntersection(int nodeCount, int nodeHeaviness) {
        this.nodeCount = nodeCount;
        this.nodeHeaviness = nodeHeaviness;
    }

    @Parameterized.Parameters
    public static Collection inputParams() {
        return Arrays.asList({4, 5}, {10, 5}, {20, 5}, {50, 5}, {100, 5}, {100, 10});
    }

    @Test
    public void testPipelineDatanodesIntersection() {
        MockNodeManager nodeManager = new MockNodeManager(true, this.nodeCount);
        this.conf.setInt("ozone.datanode.pipeline.limit", this.nodeHeaviness);
        this.conf.setBoolean("ozone.scm.pipeline.creation.auto.factor.one", false);
        PipelineStateManager stateManager = new PipelineStateManager();
        MockRatisPipelineProvider provider = new MockRatisPipelineProvider(nodeManager, stateManager, (ConfigurationSource)this.conf);
        int healthyNodeCount = nodeManager.getNodeCount(HddsProtos.NodeState.HEALTHY);
        int intersectionCount = 0;
        int createdPipelineCount = 0;
        while (!this.end && createdPipelineCount <= healthyNodeCount * this.nodeHeaviness) {
            try {
                Pipeline pipeline = provider.create(HddsProtos.ReplicationFactor.THREE);
                stateManager.addPipeline(pipeline);
                nodeManager.addPipeline(pipeline);
                List overlapPipelines = RatisPipelineUtils.checkPipelineContainSameDatanodes((PipelineStateManager)stateManager, (Pipeline)pipeline);
                if (overlapPipelines.isEmpty()) {
                    ++intersectionCount;
                    for (Pipeline overlapPipeline : overlapPipelines) {
                        LOG.info("This pipeline: " + pipeline.getId().toString() + " overlaps with previous pipeline: " + overlapPipeline.getId() + ". They share same set of datanodes as: " + ((DatanodeDetails)pipeline.getNodesInOrder().get(0)).getUuid() + "/" + ((DatanodeDetails)pipeline.getNodesInOrder().get(1)).getUuid() + "/" + ((DatanodeDetails)pipeline.getNodesInOrder().get(2)).getUuid() + " and " + ((DatanodeDetails)overlapPipeline.getNodesInOrder().get(0)).getUuid() + "/" + ((DatanodeDetails)overlapPipeline.getNodesInOrder().get(1)).getUuid() + "/" + ((DatanodeDetails)overlapPipeline.getNodesInOrder().get(2)).getUuid() + " is the same.");
                    }
                }
                ++createdPipelineCount;
            }
            catch (SCMException e) {
                this.end = true;
            }
            catch (IOException e) {
                this.end = true;
                Assert.fail();
            }
        }
        this.end = false;
        LOG.info("Among total " + stateManager.getPipelines(HddsProtos.ReplicationType.RATIS, HddsProtos.ReplicationFactor.THREE).size() + " created pipelines with " + healthyNodeCount + " healthy datanodes and " + this.nodeHeaviness + " as node heaviness, " + intersectionCount + " pipelines has same set of datanodes.");
    }
}

