/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.util.UUID;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineActionHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.ozone.protocol.commands.CommandForDatanode;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestPipelineActionHandler {
    @Test
    public void testCloseActionForMissingPipeline() throws PipelineNotFoundException {
        PipelineManager manager = (PipelineManager)Mockito.mock(PipelineManager.class);
        EventQueue queue = (EventQueue)Mockito.mock(EventQueue.class);
        Mockito.when((Object)manager.getPipeline((PipelineID)Mockito.any(PipelineID.class))).thenThrow(new Throwable[]{new PipelineNotFoundException()});
        PipelineActionHandler actionHandler = new PipelineActionHandler(manager, null);
        StorageContainerDatanodeProtocolProtos.PipelineActionsProto actionsProto = StorageContainerDatanodeProtocolProtos.PipelineActionsProto.newBuilder().addPipelineActions(StorageContainerDatanodeProtocolProtos.PipelineAction.newBuilder().setClosePipeline(StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.newBuilder().setPipelineID(HddsProtos.PipelineID.newBuilder().setId(UUID.randomUUID().toString()).build()).setReason(StorageContainerDatanodeProtocolProtos.ClosePipelineInfo.Reason.PIPELINE_FAILED)).setAction(StorageContainerDatanodeProtocolProtos.PipelineAction.Action.CLOSE).build()).build();
        SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode pipelineActions = new SCMDatanodeHeartbeatDispatcher.PipelineActionsFromDatanode(MockDatanodeDetails.randomDatanodeDetails(), actionsProto);
        actionHandler.onMessage(pipelineActions, (EventPublisher)queue);
        ((EventQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)1))).fireEvent((Event)Mockito.any(), Mockito.any(CommandForDatanode.class));
    }
}

