/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineProvider;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;

public class MockRatisPipelineProvider
extends RatisPipelineProvider {
    private boolean autoOpenPipeline;
    private boolean isHealthy;

    public MockRatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf, EventPublisher eventPublisher, boolean autoOpen) {
        super(nodeManager, stateManager, conf, eventPublisher);
        this.autoOpenPipeline = autoOpen;
    }

    public MockRatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf) {
        super(nodeManager, stateManager, conf, (EventPublisher)new EventQueue());
    }

    public MockRatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf, boolean isHealthy) {
        super(nodeManager, stateManager, conf, (EventPublisher)new EventQueue());
        this.isHealthy = isHealthy;
    }

    public MockRatisPipelineProvider(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf, EventPublisher eventPublisher) {
        super(nodeManager, stateManager, conf, eventPublisher);
        this.autoOpenPipeline = true;
    }

    protected void initializePipeline(Pipeline pipeline) throws IOException {
    }

    public Pipeline create(HddsProtos.ReplicationFactor factor) throws IOException {
        if (this.autoOpenPipeline) {
            return super.create(factor);
        }
        Pipeline initialPipeline = super.create(factor);
        Pipeline pipeline = Pipeline.newBuilder().setId(initialPipeline.getId()).setState(Pipeline.PipelineState.ALLOCATED).setType(initialPipeline.getType()).setFactor(factor).setNodes(initialPipeline.getNodes()).build();
        if (this.isHealthy) {
            for (DatanodeDetails datanodeDetails : initialPipeline.getNodes()) {
                pipeline.reportDatanode(datanodeDetails);
            }
            pipeline.setLeaderId(initialPipeline.getFirstNode().getUuid());
        }
        return pipeline;
    }

    public void shutdown() {
    }

    public Pipeline create(HddsProtos.ReplicationFactor factor, List<DatanodeDetails> nodes) {
        return Pipeline.newBuilder().setId(PipelineID.randomId()).setState(Pipeline.PipelineState.OPEN).setType(HddsProtos.ReplicationType.RATIS).setFactor(factor).setNodes(nodes).build();
    }
}

