/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node.states;

import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.states.Node2ContainerMap;
import org.apache.hadoop.hdds.scm.node.states.ReportResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestNode2ContainerMap {
    private static final int DATANODE_COUNT = 300;
    private static final int CONTAINER_COUNT = 1000;
    private final Map<UUID, TreeSet<ContainerID>> testData = new ConcurrentHashMap<UUID, TreeSet<ContainerID>>();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private void generateData() {
        for (int dnIndex = 1; dnIndex <= 300; ++dnIndex) {
            TreeSet<ContainerID> currentSet = new TreeSet<ContainerID>();
            for (int cnIndex = 1; cnIndex <= 1000; ++cnIndex) {
                long currentCnIndex = (long)(dnIndex * 1000) + (long)cnIndex;
                currentSet.add(new ContainerID(currentCnIndex));
            }
            this.testData.put(UUID.randomUUID(), currentSet);
        }
    }

    private UUID getFirstKey() {
        return this.testData.keySet().iterator().next();
    }

    @Before
    public void setUp() throws Exception {
        this.generateData();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIsKnownDatanode() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        UUID knownNode = this.getFirstKey();
        UUID unknownNode = UUID.randomUUID();
        Set containerIDs = this.testData.get(knownNode);
        map.insertNewDatanode(knownNode, containerIDs);
        Assert.assertTrue((String)"Not able to detect a known node", (boolean)map.isKnownDatanode(knownNode));
        Assert.assertFalse((String)"Unknown node detected", (boolean)map.isKnownDatanode(unknownNode));
    }

    @Test
    public void testInsertNewDatanode() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        UUID knownNode = this.getFirstKey();
        Set containerIDs = this.testData.get(knownNode);
        map.insertNewDatanode(knownNode, containerIDs);
        Set readSet = map.getContainers(knownNode);
        TreeSet newSet = new TreeSet(readSet);
        Assert.assertTrue((boolean)newSet.removeAll(containerIDs));
        Assert.assertTrue((newSet.size() == 0 ? 1 : 0) != 0);
        this.thrown.expect(SCMException.class);
        this.thrown.expectMessage("already exists");
        map.insertNewDatanode(knownNode, containerIDs);
        map.removeDatanode(knownNode);
        map.insertNewDatanode(knownNode, containerIDs);
    }

    @Test
    public void testProcessReportCheckOneNode() throws SCMException {
        UUID key = this.getFirstKey();
        Set values = this.testData.get(key);
        Node2ContainerMap map = new Node2ContainerMap();
        map.insertNewDatanode(key, values);
        Assert.assertTrue((boolean)map.isKnownDatanode(key));
        ReportResult result = map.processReport(key, values);
        Assert.assertEquals((Object)ReportResult.ReportStatus.ALL_IS_WELL, (Object)result.getStatus());
    }

    @Test
    public void testUpdateDatanodeMap() throws SCMException {
        UUID datanodeId = this.getFirstKey();
        Set values = this.testData.get(datanodeId);
        Node2ContainerMap map = new Node2ContainerMap();
        map.insertNewDatanode(datanodeId, values);
        Assert.assertTrue((boolean)map.isKnownDatanode(datanodeId));
        Assert.assertEquals((long)1000L, (long)map.getContainers(datanodeId).size());
        values.remove(values.iterator().next());
        Assert.assertEquals((long)999L, (long)values.size());
        Assert.assertEquals((long)1000L, (long)map.getContainers(datanodeId).size());
        map.setContainersForDatanode(datanodeId, values);
        Assert.assertEquals((long)values.size(), (long)map.getContainers(datanodeId).size());
        Assert.assertEquals((Object)values, (Object)map.getContainers(datanodeId));
    }

    @Test
    public void testProcessReportInsertAll() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        for (Map.Entry<UUID, TreeSet<ContainerID>> keyEntry : this.testData.entrySet()) {
            map.insertNewDatanode(keyEntry.getKey(), (Set)keyEntry.getValue());
        }
        for (UUID key : this.testData.keySet()) {
            Assert.assertTrue((boolean)map.isKnownDatanode(key));
        }
    }

    @Test
    public void testProcessReportDetectNewDataNode() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        UUID key = this.getFirstKey();
        TreeSet<ContainerID> values = this.testData.get(key);
        ReportResult result = map.processReport(key, values);
        Assert.assertEquals((Object)ReportResult.ReportStatus.NEW_DATANODE_FOUND, (Object)result.getStatus());
        Assert.assertEquals((long)result.getNewEntries().size(), (long)values.size());
    }

    @Test
    public void testProcessReportDetectNewContainers() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        UUID key = this.getFirstKey();
        TreeSet<ContainerID> values = this.testData.get(key);
        map.insertNewDatanode(key, values);
        int newCount = 100;
        ContainerID last = values.last();
        TreeSet<ContainerID> addedContainers = new TreeSet<ContainerID>();
        for (int x = 1; x <= 100; ++x) {
            long cTemp = last.getId() + (long)x;
            addedContainers.add(new ContainerID(cTemp));
        }
        TreeSet<ContainerID> newContainersSet = new TreeSet<ContainerID>((SortedSet<ContainerID>)values);
        newContainersSet.addAll(addedContainers);
        ReportResult result = map.processReport(key, newContainersSet);
        Assert.assertEquals((Object)ReportResult.ReportStatus.NEW_ENTRIES_FOUND, (Object)result.getStatus());
        Assert.assertEquals((long)addedContainers.size(), (long)result.getNewEntries().size());
        Assert.assertTrue((String)"All objects are not removed.", (boolean)result.getNewEntries().removeAll(addedContainers));
    }

    @Test
    public void testProcessReportDetectMissingContainers() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        UUID key = this.getFirstKey();
        TreeSet<ContainerID> values = this.testData.get(key);
        map.insertNewDatanode(key, values);
        int removeCount = 100;
        Random r = new Random();
        ContainerID first = values.first();
        TreeSet<ContainerID> removedContainers = new TreeSet<ContainerID>();
        for (int x = 0; x < 100; ++x) {
            int startBase = (int)first.getId();
            long cTemp = r.nextInt(values.size());
            removedContainers.add(new ContainerID(cTemp + (long)startBase));
        }
        TreeSet<ContainerID> newContainersSet = new TreeSet<ContainerID>((SortedSet<ContainerID>)values);
        newContainersSet.removeAll(removedContainers);
        ReportResult result = map.processReport(key, newContainersSet);
        Assert.assertEquals((Object)ReportResult.ReportStatus.MISSING_ENTRIES, (Object)result.getStatus());
        Assert.assertEquals((long)removedContainers.size(), (long)result.getMissingEntries().size());
        Assert.assertTrue((String)"All missing containers not found.", (boolean)result.getMissingEntries().removeAll(removedContainers));
    }

    @Test
    public void testProcessReportDetectNewAndMissingContainers() throws SCMException {
        Node2ContainerMap map = new Node2ContainerMap();
        UUID key = this.getFirstKey();
        TreeSet<ContainerID> values = this.testData.get(key);
        map.insertNewDatanode(key, values);
        TreeSet<ContainerID> insertedSet = new TreeSet<ContainerID>();
        for (int x = 1; x <= 30; ++x) {
            insertedSet.add(new ContainerID((long)x));
        }
        int removeCount = 100;
        Random r = new Random();
        ContainerID first = values.first();
        TreeSet<ContainerID> removedContainers = new TreeSet<ContainerID>();
        for (int x = 0; x < 100; ++x) {
            int startBase = (int)first.getId();
            long cTemp = r.nextInt(values.size());
            removedContainers.add(new ContainerID(cTemp + (long)startBase));
        }
        TreeSet<ContainerID> newSet = new TreeSet<ContainerID>((SortedSet<ContainerID>)values);
        newSet.addAll(insertedSet);
        newSet.removeAll(removedContainers);
        ReportResult result = map.processReport(key, newSet);
        Assert.assertEquals((Object)ReportResult.ReportStatus.MISSING_AND_NEW_ENTRIES_FOUND, (Object)result.getStatus());
        Assert.assertEquals((long)removedContainers.size(), (long)result.getMissingEntries().size());
        Assert.assertTrue((String)"All missing containers not found.", (boolean)result.getMissingEntries().removeAll(removedContainers));
        Assert.assertEquals((long)insertedSet.size(), (long)result.getNewEntries().size());
        Assert.assertTrue((String)"All inserted containers are not found.", (boolean)result.getNewEntries().removeAll(insertedSet));
    }
}

