/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.HddsTestUtils;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeMetric;
import org.apache.hadoop.hdds.scm.container.placement.metrics.SCMNodeStat;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.DeadNodeHandler;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.node.TestDeadNodeHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestStatisticsUpdate {
    private NodeManager nodeManager;
    private NodeReportHandler nodeReportHandler;

    @Before
    public void setup() throws IOException, AuthenticationException {
        OzoneConfiguration conf = new OzoneConfiguration();
        String storageDir = GenericTestUtils.getTempPath((String)(TestDeadNodeHandler.class.getSimpleName() + UUID.randomUUID()));
        conf.set("ozone.metadata.dirs", storageDir);
        conf.set("hdds.heartbeat.interval", "100ms");
        conf.set("ozone.scm.heartbeat.thread.interval", "50ms");
        conf.set("ozone.scm.stale.node.interval", "1s");
        conf.set("ozone.scm.dead.node.interval", "2s");
        EventQueue eventQueue = new EventQueue();
        StorageContainerManager scm = HddsTestUtils.getScm(conf);
        this.nodeManager = scm.getScmNodeManager();
        DeadNodeHandler deadNodeHandler = new DeadNodeHandler(this.nodeManager, (PipelineManager)Mockito.mock(PipelineManager.class), scm.getContainerManager());
        eventQueue.addHandler((Event)SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.nodeReportHandler = new NodeReportHandler(this.nodeManager);
    }

    @Test
    public void testStatisticsUpdate() throws Exception {
        DatanodeDetails datanode1 = MockDatanodeDetails.randomDatanodeDetails();
        DatanodeDetails datanode2 = MockDatanodeDetails.randomDatanodeDetails();
        String storagePath1 = GenericTestUtils.getRandomizedTempPath().concat("/" + datanode1.getUuidString());
        String storagePath2 = GenericTestUtils.getRandomizedTempPath().concat("/" + datanode2.getUuidString());
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageOne = TestUtils.createStorageReport(datanode1.getUuid(), storagePath1, 100L, 10L, 90L, null);
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageTwo = TestUtils.createStorageReport(datanode2.getUuid(), storagePath2, 200L, 20L, 180L, null);
        this.nodeManager.register(datanode1, TestUtils.createNodeReport(storageOne), null);
        this.nodeManager.register(datanode2, TestUtils.createNodeReport(storageTwo), null);
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReportProto1 = TestUtils.createNodeReport(storageOne);
        StorageContainerDatanodeProtocolProtos.NodeReportProto nodeReportProto2 = TestUtils.createNodeReport(storageTwo);
        this.nodeReportHandler.onMessage(new SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode(datanode1, nodeReportProto1), (EventPublisher)Mockito.mock(EventPublisher.class));
        this.nodeReportHandler.onMessage(new SCMDatanodeHeartbeatDispatcher.NodeReportFromDatanode(datanode2, nodeReportProto2), (EventPublisher)Mockito.mock(EventPublisher.class));
        SCMNodeStat stat = this.nodeManager.getStats();
        Assert.assertEquals((long)300L, (long)stat.getCapacity().get());
        Assert.assertEquals((long)270L, (long)stat.getRemaining().get());
        Assert.assertEquals((long)30L, (long)stat.getScmUsed().get());
        SCMNodeMetric nodeStat = this.nodeManager.getNodeStat(datanode1);
        Assert.assertEquals((long)100L, (long)nodeStat.get().getCapacity().get());
        Assert.assertEquals((long)90L, (long)nodeStat.get().getRemaining().get());
        Assert.assertEquals((long)10L, (long)nodeStat.get().getScmUsed().get());
        this.nodeManager.processHeartbeat(datanode2);
        Thread.sleep(1000L);
        this.nodeManager.processHeartbeat(datanode2);
        Thread.sleep(1000L);
        this.nodeManager.processHeartbeat(datanode2);
        Thread.sleep(1000L);
        this.nodeManager.processHeartbeat(datanode2);
        stat = this.nodeManager.getStats();
        Assert.assertEquals((long)200L, (long)stat.getCapacity().get());
        Assert.assertEquals((long)180L, (long)stat.getRemaining().get());
        Assert.assertEquals((long)20L, (long)stat.getScmUsed().get());
    }
}

