/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.node;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.TestUtils;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.SCMNodeStorageStatMap;
import org.apache.hadoop.hdds.scm.node.StorageReportResult;
import org.apache.hadoop.ozone.container.common.impl.StorageLocationReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestSCMNodeStorageStatMap {
    private static final int DATANODE_COUNT = 100;
    private final long capacity = 0x280000000L;
    private final long used = 0x80000000L;
    private final long remaining = 0x200000000L;
    private static OzoneConfiguration conf = new OzoneConfiguration();
    private final Map<UUID, Set<StorageLocationReport>> testData = new ConcurrentHashMap<UUID, Set<StorageLocationReport>>();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private void generateData() {
        for (int dnIndex = 1; dnIndex <= 100; ++dnIndex) {
            UUID dnId = UUID.randomUUID();
            HashSet<StorageLocationReport> reportSet = new HashSet<StorageLocationReport>();
            String path = GenericTestUtils.getTempPath((String)(TestSCMNodeStorageStatMap.class.getSimpleName() + "-" + Integer.toString(dnIndex)));
            StorageLocationReport.Builder builder = StorageLocationReport.newBuilder();
            builder.setStorageType(StorageType.DISK).setId(dnId.toString()).setStorageLocation(path).setScmUsed(0x80000000L).setRemaining(0x200000000L).setCapacity(0x280000000L).setFailed(false);
            reportSet.add(builder.build());
            this.testData.put(UUID.randomUUID(), reportSet);
        }
    }

    private UUID getFirstKey() {
        return this.testData.keySet().iterator().next();
    }

    @Before
    public void setUp() throws Exception {
        this.generateData();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIsKnownDatanode() throws SCMException {
        SCMNodeStorageStatMap map = new SCMNodeStorageStatMap(conf);
        UUID knownNode = this.getFirstKey();
        UUID unknownNode = UUID.randomUUID();
        Set<StorageLocationReport> report = this.testData.get(knownNode);
        map.insertNewDatanode(knownNode, report);
        Assert.assertTrue((String)"Not able to detect a known node", (boolean)map.isKnownDatanode(knownNode));
        Assert.assertFalse((String)"Unknown node detected", (boolean)map.isKnownDatanode(unknownNode));
    }

    @Test
    public void testInsertNewDatanode() throws SCMException {
        SCMNodeStorageStatMap map = new SCMNodeStorageStatMap(conf);
        UUID knownNode = this.getFirstKey();
        Set<StorageLocationReport> report = this.testData.get(knownNode);
        map.insertNewDatanode(knownNode, report);
        Assert.assertEquals((Object)map.getStorageVolumes(knownNode), this.testData.get(knownNode));
        this.thrown.expect(SCMException.class);
        this.thrown.expectMessage("already exists");
        map.insertNewDatanode(knownNode, report);
    }

    @Test
    public void testUpdateUnknownDatanode() throws SCMException {
        SCMNodeStorageStatMap map = new SCMNodeStorageStatMap(conf);
        UUID unknownNode = UUID.randomUUID();
        String path = GenericTestUtils.getTempPath((String)(TestSCMNodeStorageStatMap.class.getSimpleName() + "-" + unknownNode.toString()));
        HashSet<StorageLocationReport> reportSet = new HashSet<StorageLocationReport>();
        StorageLocationReport.Builder builder = StorageLocationReport.newBuilder();
        builder.setStorageType(StorageType.DISK).setId(unknownNode.toString()).setStorageLocation(path).setScmUsed(0x80000000L).setRemaining(0x200000000L).setCapacity(0x280000000L).setFailed(false);
        reportSet.add(builder.build());
        this.thrown.expect(SCMException.class);
        this.thrown.expectMessage("No such datanode");
        map.updateDatanodeMap(unknownNode, reportSet);
    }

    @Test
    public void testProcessNodeReportCheckOneNode() throws IOException {
        UUID key = this.getFirstKey();
        ArrayList<StorageContainerDatanodeProtocolProtos.StorageReportProto> reportList = new ArrayList<StorageContainerDatanodeProtocolProtos.StorageReportProto>();
        Set<StorageLocationReport> reportSet = this.testData.get(key);
        SCMNodeStorageStatMap map = new SCMNodeStorageStatMap(conf);
        map.insertNewDatanode(key, reportSet);
        Assert.assertTrue((boolean)map.isKnownDatanode(key));
        UUID storageId = UUID.randomUUID();
        String path = GenericTestUtils.getRandomizedTempPath().concat("/" + storageId);
        StorageLocationReport report = reportSet.iterator().next();
        long reportCapacity = report.getCapacity();
        long reportScmUsed = report.getScmUsed();
        long reportRemaining = report.getRemaining();
        StorageContainerDatanodeProtocolProtos.StorageReportProto storageReport = TestUtils.createStorageReport(storageId, path, reportCapacity, reportScmUsed, reportRemaining, null);
        StorageReportResult result = map.processNodeReport(key, TestUtils.createNodeReport(storageReport));
        Assert.assertEquals((Object)SCMNodeStorageStatMap.ReportStatus.ALL_IS_WELL, (Object)result.getStatus());
        StorageContainerDatanodeProtocolProtos.NodeReportProto.Builder nrb = StorageContainerDatanodeProtocolProtos.NodeReportProto.newBuilder();
        StorageContainerDatanodeProtocolProtos.StorageReportProto srb = reportSet.iterator().next().getProtoBufMessage();
        reportList.add(srb);
        result = map.processNodeReport(key, TestUtils.createNodeReport(reportList));
        Assert.assertEquals((Object)SCMNodeStorageStatMap.ReportStatus.ALL_IS_WELL, (Object)result.getStatus());
        reportList.add(TestUtils.createStorageReport(UUID.randomUUID(), path, reportCapacity, reportCapacity, 0L, null));
        result = map.processNodeReport(key, TestUtils.createNodeReport(reportList));
        Assert.assertEquals((Object)SCMNodeStorageStatMap.ReportStatus.STORAGE_OUT_OF_SPACE, (Object)result.getStatus());
        StorageContainerDatanodeProtocolProtos.StorageReportProto srb2 = StorageContainerDatanodeProtocolProtos.StorageReportProto.newBuilder().setStorageUuid(UUID.randomUUID().toString()).setStorageLocation(srb.getStorageLocation()).setScmUsed(reportCapacity).setCapacity(reportCapacity).setRemaining(0L).setFailed(true).build();
        reportList.add(srb2);
        nrb.addAllStorageReport(reportList);
        result = map.processNodeReport(key, nrb.addStorageReport(srb).build());
        Assert.assertEquals((Object)SCMNodeStorageStatMap.ReportStatus.FAILED_AND_OUT_OF_SPACE_STORAGE, (Object)result.getStatus());
    }

    @Test
    public void testProcessMultipleNodeReports() throws SCMException {
        SCMNodeStorageStatMap map = new SCMNodeStorageStatMap(conf);
        int counter = 1;
        for (Map.Entry<UUID, Set<StorageLocationReport>> keyEntry : this.testData.entrySet()) {
            map.insertNewDatanode(keyEntry.getKey(), keyEntry.getValue());
        }
        Assert.assertEquals((long)0xFA00000000L, (long)map.getTotalCapacity());
        Assert.assertEquals((long)0xC800000000L, (long)map.getTotalFreeSpace());
        Assert.assertEquals((long)0x3200000000L, (long)map.getTotalSpaceUsed());
        for (Map.Entry<UUID, Set<StorageLocationReport>> keyEntry : this.testData.entrySet()) {
            HashSet<StorageLocationReport> reportSet = new HashSet<StorageLocationReport>();
            String path = GenericTestUtils.getTempPath((String)(TestSCMNodeStorageStatMap.class.getSimpleName() + "-" + keyEntry.getKey().toString()));
            StorageLocationReport.Builder builder = StorageLocationReport.newBuilder();
            builder.setStorageType(StorageType.DISK).setId(keyEntry.getKey().toString()).setStorageLocation(path).setScmUsed(0x280000000L).setRemaining(0L).setCapacity(0x280000000L).setFailed(false);
            reportSet.add(builder.build());
            map.updateDatanodeMap(keyEntry.getKey(), reportSet);
            if (++counter <= 25) continue;
            break;
        }
        Assert.assertEquals((long)25L, (long)map.getDatanodeList(SCMNodeStorageStatMap.UtilizationThreshold.CRITICAL).size());
        Assert.assertEquals((long)0L, (long)map.getDatanodeList(SCMNodeStorageStatMap.UtilizationThreshold.WARN).size());
        Assert.assertEquals((double)75.0, (double)map.getDatanodeList(SCMNodeStorageStatMap.UtilizationThreshold.NORMAL).size(), (double)0.0);
        Assert.assertEquals((float)1.0737418E12f, (float)map.getTotalCapacity(), (float)0.0f);
        Assert.assertEquals((double)6.442450944E11, (double)map.getTotalFreeSpace(), (double)0.0);
        Assert.assertEquals((double)4.294967296E11, (double)map.getTotalSpaceUsed(), (double)0.0);
        counter = 1;
        for (Map.Entry<UUID, Set<StorageLocationReport>> keyEntry : this.testData.entrySet()) {
            map.removeDatanode(keyEntry.getKey());
            if (++counter <= 25) continue;
            break;
        }
        Assert.assertEquals((long)0L, (long)map.getDatanodeList(SCMNodeStorageStatMap.UtilizationThreshold.CRITICAL).size());
        Assert.assertEquals((long)0L, (long)map.getDatanodeList(SCMNodeStorageStatMap.UtilizationThreshold.WARN).size());
        Assert.assertEquals((double)75.0, (double)map.getDatanodeList(SCMNodeStorageStatMap.UtilizationThreshold.NORMAL).size(), (double)0.0);
        Assert.assertEquals((double)8.05306368E11, (double)map.getTotalCapacity(), (double)0.0);
        Assert.assertEquals((double)6.442450944E11, (double)map.getTotalFreeSpace(), (double)0.0);
        Assert.assertEquals((double)1.610612736E11, (double)map.getTotalSpaceUsed(), (double)0.0);
    }
}

